<!-- Size/Color Filter Widget -->
<div class="variable-widget bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 max-w-sm">

    <!-- Widget Header -->
    <div class="flex items-center justify-between mb-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Size & Color</h3>
        <button id="clearSizeColor" class="text-sm text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors">
            Clear
        </button>
    </div>

    <!-- Size Filter -->
    <div class="mb-6">
        <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-3">Size</h4>
        <div class="grid grid-cols-4 gap-2">
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="XS">
                XS
            </button>
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="S">
                S
            </button>
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="M">
                M
            </button>
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="L">
                L
            </button>
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="XL">
                XL
            </button>
            <button class="size-btn h-10 border border-gray-300 dark:border-gray-600 rounded-md text-sm font-medium text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="XXL">
                XXL
            </button>
        </div>

        <!-- Shoe Sizes -->
        <div class="mt-4">
            <div class="text-xs text-gray-500 dark:text-gray-400 mb-2">Shoe Sizes</div>
            <div class="grid grid-cols-5 gap-1.5">
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="38">38</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="39">39</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="40">40</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="41">41</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="42">42</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="43">43</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="44">44</button>
                <button class="shoe-size-btn h-8 border border-gray-300 dark:border-gray-600 rounded text-xs text-gray-700 dark:text-gray-300 hover:border-primary-500 hover:text-primary-600 dark:hover:text-primary-400 transition-colors" data-size="45">45</button>
            </div>
        </div>
    </div>

    <!-- Color Filter -->
    <div class="mb-6">
        <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-3">Color</h4>
        <div class="grid grid-cols-6 gap-3">
            <!-- Black -->
            <button class="color-btn w-8 h-8 rounded-full bg-black border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="black" title="Black">
                <span class="sr-only">Black</span>
            </button>
            <!-- White -->
            <button class="color-btn w-8 h-8 rounded-full bg-white border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="white" title="White">
                <span class="sr-only">White</span>
            </button>
            <!-- Gray -->
            <button class="color-btn w-8 h-8 rounded-full bg-gray-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="gray" title="Gray">
                <span class="sr-only">Gray</span>
            </button>
            <!-- Red -->
            <button class="color-btn w-8 h-8 rounded-full bg-red-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="red" title="Red">
                <span class="sr-only">Red</span>
            </button>
            <!-- Blue -->
            <button class="color-btn w-8 h-8 rounded-full bg-blue-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="blue" title="Blue">
                <span class="sr-only">Blue</span>
            </button>
            <!-- Green -->
            <button class="color-btn w-8 h-8 rounded-full bg-green-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="green" title="Green">
                <span class="sr-only">Green</span>
            </button>
            <!-- Yellow -->
            <button class="color-btn w-8 h-8 rounded-full bg-yellow-400 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="yellow" title="Yellow">
                <span class="sr-only">Yellow</span>
            </button>
            <!-- Orange -->
            <button class="color-btn w-8 h-8 rounded-full bg-orange-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="orange" title="Orange">
                <span class="sr-only">Orange</span>
            </button>
            <!-- Purple -->
            <button class="color-btn w-8 h-8 rounded-full bg-purple-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="purple" title="Purple">
                <span class="sr-only">Purple</span>
            </button>
            <!-- Pink -->
            <button class="color-btn w-8 h-8 rounded-full bg-pink-500 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="pink" title="Pink">
                <span class="sr-only">Pink</span>
            </button>
            <!-- Brown -->
            <button class="color-btn w-8 h-8 rounded-full bg-amber-700 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="brown" title="Brown">
                <span class="sr-only">Brown</span>
            </button>
            <!-- Navy -->
            <button class="color-btn w-8 h-8 rounded-full bg-blue-900 border-2 border-gray-300 hover:border-primary-500 transition-colors relative" data-color="navy" title="Navy">
                <span class="sr-only">Navy</span>
            </button>
        </div>
    </div>

    <!-- Selected Filters Display -->
    <div id="selectedFilters" class="mb-6 hidden">
        <div class="text-sm font-medium text-gray-900 dark:text-white mb-2">Selected:</div>
        <div class="space-y-2">
            <div id="selectedSizes" class="hidden">
                <span class="text-xs text-gray-500 dark:text-gray-400">Sizes:</span>
                <div class="flex flex-wrap gap-1 mt-1" id="sizeTagsContainer"></div>
            </div>
            <div id="selectedColors" class="hidden">
                <span class="text-xs text-gray-500 dark:text-gray-400">Colors:</span>
                <div class="flex flex-wrap gap-1 mt-1" id="colorTagsContainer"></div>
            </div>
        </div>
    </div>

    <!-- Apply Button -->
    <button id="applySizeColorFilter" class="w-full te-btn te-btn-default">
        Apply Filter
    </button>

    <!-- Results Count -->
    <div class="mt-4 text-center">
        <span class="text-xs text-gray-500 dark:text-gray-400" id="sizeColorResults">
            Showing 124 products
        </span>
    </div>
</div>

<style>
    .size-btn.active,
    .shoe-size-btn.active {
        background-color: #3b82f6;
        border-color: #3b82f6;
        color: white;
    }

    .color-btn.active::after {
        content: '✓';
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: white;
        font-weight: bold;
        font-size: 12px;
        text-shadow: 0 0 2px rgba(0, 0, 0, 0.8);
    }

    .color-btn[data-color="white"].active::after {
        color: #3b82f6;
        text-shadow: none;
    }

    .color-btn[data-color="yellow"].active::after {
        color: #1f2937;
        text-shadow: none;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const sizeBtns = document.querySelectorAll('.size-btn');
        const shoeSizeBtns = document.querySelectorAll('.shoe-size-btn');
        const colorBtns = document.querySelectorAll('.color-btn');
        const clearBtn = document.getElementById('clearSizeColor');
        const applyBtn = document.getElementById('applySizeColorFilter');
        const selectedFilters = document.getElementById('selectedFilters');
        const selectedSizes = document.getElementById('selectedSizes');
        const selectedColors = document.getElementById('selectedColors');
        const sizeTagsContainer = document.getElementById('sizeTagsContainer');
        const colorTagsContainer = document.getElementById('colorTagsContainer');
        const resultsCount = document.getElementById('sizeColorResults');

        let selectedSizesList = [];
        let selectedColorsList = [];

        function toggleButton(btn, list, value) {
            if (btn.classList.contains('active')) {
                btn.classList.remove('active');
                const index = list.indexOf(value);
                if (index > -1) list.splice(index, 1);
            } else {
                btn.classList.add('active');
                list.push(value);
            }
            updateSelectedDisplay();
        }

        function updateSelectedDisplay() {
            // Update sizes display
            if (selectedSizesList.length > 0) {
                selectedSizes.classList.remove('hidden');
                sizeTagsContainer.innerHTML = '';
                selectedSizesList.forEach(size => {
                    const tag = document.createElement('span');
                    tag.className = 'inline-flex items-center gap-1 px-2 py-1 bg-primary-100 text-white text-xs rounded-full';
                    tag.innerHTML = `
                    ${size}
                    <button class="hover:bg-primary-200 rounded-full p-0.5" onclick="removeSize('${size}')">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                `;
                    sizeTagsContainer.appendChild(tag);
                });
            } else {
                selectedSizes.classList.add('hidden');
            }

            // Update colors display
            if (selectedColorsList.length > 0) {
                selectedColors.classList.remove('hidden');
                colorTagsContainer.innerHTML = '';
                selectedColorsList.forEach(color => {
                    const tag = document.createElement('span');
                    tag.className = 'inline-flex items-center gap-1 px-2 py-1 bg-primary-100 text-white text-xs rounded-full';
                    tag.innerHTML = `
                    ${color.charAt(0).toUpperCase() + color.slice(1)}
                    <button class="hover:bg-primary-200 rounded-full p-0.5" onclick="removeColor('${color}')">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                `;
                    colorTagsContainer.appendChild(tag);
                });
            } else {
                selectedColors.classList.add('hidden');
            }

            // Show/hide selected filters section
            if (selectedSizesList.length > 0 || selectedColorsList.length > 0) {
                selectedFilters.classList.remove('hidden');
            } else {
                selectedFilters.classList.add('hidden');
            }

            // Update results count
            const baseCount = 124;
            const sizeMultiplier = selectedSizesList.length > 0 ? 0.3 + (selectedSizesList.length * 0.1) : 1;
            const colorMultiplier = selectedColorsList.length > 0 ? 0.4 + (selectedColorsList.length * 0.1) : 1;
            const filteredCount = Math.max(5, Math.floor(baseCount * sizeMultiplier * colorMultiplier));
            resultsCount.textContent = `Showing ${filteredCount} products`;
        }

        // Size button events
        sizeBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                toggleButton(this, selectedSizesList, this.dataset.size);
            });
        });

        shoeSizeBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                toggleButton(this, selectedSizesList, this.dataset.size);
            });
        });

        // Color button events
        colorBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                toggleButton(this, selectedColorsList, this.dataset.color);
            });
        });

        // Global functions for tag removal
        window.removeSize = function(size) {
            const btn = document.querySelector(`.size-btn[data-size="${size}"], .shoe-size-btn[data-size="${size}"]`);
            if (btn) {
                btn.classList.remove('active');
                const index = selectedSizesList.indexOf(size);
                if (index > -1) selectedSizesList.splice(index, 1);
                updateSelectedDisplay();
            }
        };

        window.removeColor = function(color) {
            const btn = document.querySelector(`.color-btn[data-color="${color}"]`);
            if (btn) {
                btn.classList.remove('active');
                const index = selectedColorsList.indexOf(color);
                if (index > -1) selectedColorsList.splice(index, 1);
                updateSelectedDisplay();
            }
        };

        // Clear button
        clearBtn.addEventListener('click', function() {
            sizeBtns.forEach(btn => btn.classList.remove('active'));
            shoeSizeBtns.forEach(btn => btn.classList.remove('active'));
            colorBtns.forEach(btn => btn.classList.remove('active'));
            selectedSizesList = [];
            selectedColorsList = [];
            updateSelectedDisplay();
        });

        // Apply button
        applyBtn.addEventListener('click', function() {
            console.log('Selected sizes:', selectedSizesList);
            console.log('Selected colors:', selectedColorsList);
            alert(`Filter applied - Sizes: ${selectedSizesList.join(', ')} | Colors: ${selectedColorsList.join(', ')}`);
        });

        // Initialize
        updateSelectedDisplay();
    });
</script>