<!-- Product Search Widget -->
<div class="search-widget bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 max-w-sm">

    <!-- Widget Header -->
    <div class="flex items-center justify-between mb-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Search Products</h3>
        <button id="clearSearch" class="text-sm text-primary-600 hover:text-primary-700 dark:text-primary-400 dark:hover:text-primary-300 font-medium transition-colors">
            Clear
        </button>
    </div>

    <!-- Main Search -->
    <div class="mb-6">
        <div class="relative">
            <input type="text"
                id="productSearch"
                placeholder="Search products..."
                class="w-full pl-10 pr-4 py-3 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent">

            <!-- Search Icon -->
            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <svg class="w-5 h-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                </svg>
            </div>

            <!-- Clear Search Button -->
            <button id="clearSearchInput" class="absolute inset-y-0 right-0 pr-3 items-center text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 hidden">
                <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>

        <!-- Search Suggestions Dropdown -->
        <div id="searchSuggestions" class="absolute z-50 w-full mt-1 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-600 rounded-md shadow-lg hidden">
            <div class="py-2" id="suggestionsContainer">
                <!-- Suggestions will be populated here -->
            </div>
        </div>
    </div>

    <!-- Search by SKU -->
    <div class="mb-6">
        <label class="text-sm font-medium text-gray-900 dark:text-white block mb-2">Search by SKU</label>
        <div class="relative">
            <input type="text"
                id="skuSearch"
                placeholder="Enter product SKU..."
                class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:border-transparent">
        </div>
    </div>

    <!-- Recent Searches -->
    <div class="mb-6" id="recentSearches">
        <div class="flex items-center justify-between mb-3">
            <h4 class="text-sm font-medium text-gray-900 dark:text-white">Recent Searches</h4>
            <button id="clearRecent" class="text-xs text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                Clear all
            </button>
        </div>
        <div class="space-y-2" id="recentSearchList">
            <button class="recent-search-item w-full text-left px-3 py-2 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md transition-colors" data-search="t-shirt">
                t-shirt
            </button>
            <button class="recent-search-item w-full text-left px-3 py-2 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md transition-colors" data-search="jeans">
                jeans
            </button>
            <button class="recent-search-item w-full text-left px-3 py-2 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md transition-colors" data-search="sneakers">
                sneakers
            </button>
        </div>
    </div>

    <!-- Popular Searches -->
    <div class="mb-6">
        <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-3">Popular Searches</h4>
        <div class="flex flex-wrap gap-2">
            <button class="popular-search-tag px-3 py-1 text-xs bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-full hover:bg-primary-100 hover:text-white dark:hover:bg-primary-900 dark:hover:text-primary-300 transition-colors" data-search="summer collection">
                summer collection
            </button>
            <button class="popular-search-tag px-3 py-1 text-xs bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-full hover:bg-primary-100 hover:text-white dark:hover:bg-primary-900 dark:hover:text-primary-300 transition-colors" data-search="denim">
                denim
            </button>
            <button class="popular-search-tag px-3 py-1 text-xs bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-full hover:bg-primary-100 hover:text-white dark:hover:bg-primary-900 dark:hover:text-primary-300 transition-colors" data-search="casual wear">
                casual wear
            </button>
            <button class="popular-search-tag px-3 py-1 text-xs bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-full hover:bg-primary-100 hover:text-white dark:hover:bg-primary-900 dark:hover:text-primary-300 transition-colors" data-search="sale">
                sale
            </button>
        </div>
    </div>

    <!-- Search Button -->
    <button id="searchProducts" class="w-full te-btn te-btn-default">
        Search Products
    </button>

    <!-- Search Results Count -->
    <div class="mt-4 text-center">
        <span class="text-sm text-gray-500 dark:text-gray-400" id="searchResults">
            Ready to search
        </span>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const productSearch = document.getElementById('productSearch');
        const skuSearch = document.getElementById('skuSearch');
        const clearSearchBtn = document.getElementById('clearSearch');
        const clearSearchInput = document.getElementById('clearSearchInput');
        const searchBtn = document.getElementById('searchProducts');
        const recentItems = document.querySelectorAll('.recent-search-item');
        const popularTags = document.querySelectorAll('.popular-search-tag');
        const clearRecentBtn = document.getElementById('clearRecent');
        const searchResults = document.getElementById('searchResults');
        const searchSuggestions = document.getElementById('searchSuggestions');
        const suggestionsContainer = document.getElementById('suggestionsContainer');

        // Sample product suggestions
        const suggestions = [
            'T-shirt cotton basic',
            'T-shirt graphic design',
            'Jeans slim fit',
            'Jeans straight leg',
            'Sneakers running',
            'Sneakers casual',
            'Shirt button down',
            'Shirt polo',
            'Jacket denim',
            'Jacket leather'
        ];

        // Show/hide clear button for main search
        productSearch.addEventListener('input', function() {
            if (this.value.length > 0) {
                clearSearchInput.classList.remove('hidden');
                showSuggestions(this.value);
            } else {
                clearSearchInput.classList.add('hidden');
                hideSuggestions();
            }
            updateSearchResults();
        });

        // Search suggestions
        function showSuggestions(query) {
            if (query.length < 2) {
                hideSuggestions();
                return;
            }

            const filtered = suggestions.filter(item =>
                item.toLowerCase().includes(query.toLowerCase())
            ).slice(0, 5);

            if (filtered.length > 0) {
                suggestionsContainer.innerHTML = '';
                filtered.forEach(suggestion => {
                    const div = document.createElement('div');
                    div.className = 'px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 cursor-pointer transition-colors';
                    div.textContent = suggestion;
                    div.addEventListener('click', function() {
                        productSearch.value = suggestion;
                        hideSuggestions();
                        updateSearchResults();
                        addToRecentSearches(suggestion);
                    });
                    suggestionsContainer.appendChild(div);
                });
                searchSuggestions.classList.remove('hidden');
            } else {
                hideSuggestions();
            }
        }

        function hideSuggestions() {
            searchSuggestions.classList.add('hidden');
        }

        // Hide suggestions when clicking outside
        document.addEventListener('click', function(e) {
            if (!productSearch.contains(e.target) && !searchSuggestions.contains(e.target)) {
                hideSuggestions();
            }
        });

        // Clear search input
        clearSearchInput.addEventListener('click', function() {
            productSearch.value = '';
            this.classList.add('hidden');
            hideSuggestions();
            updateSearchResults();
        });

        // Recent searches
        recentItems.forEach(item => {
            item.addEventListener('click', function() {
                productSearch.value = this.dataset.search;
                clearSearchInput.classList.remove('hidden');
                updateSearchResults();
            });
        });

        // Popular search tags
        popularTags.forEach(tag => {
            tag.addEventListener('click', function() {
                productSearch.value = this.dataset.search;
                clearSearchInput.classList.remove('hidden');
                updateSearchResults();
                addToRecentSearches(this.dataset.search);
            });
        });

        // Add to recent searches
        function addToRecentSearches(searchTerm) {
            // This would typically save to localStorage or send to server
            console.log('Added to recent searches:', searchTerm);
        }

        // Update search results count
        function updateSearchResults() {
            const query = productSearch.value.trim();
            const skuQuery = skuSearch.value.trim();

            if (query || skuQuery) {
                const resultCount = Math.floor(Math.random() * 50) + 10;
                searchResults.textContent = `Found ${resultCount} products`;
            } else {
                searchResults.textContent = 'Ready to search';
            }
        }

        // SKU search
        skuSearch.addEventListener('input', updateSearchResults);

        // Clear recent searches
        clearRecentBtn.addEventListener('click', function() {
            recentItems.forEach(item => item.style.display = 'none');
            document.getElementById('recentSearches').style.display = 'none';
        });

        // Clear all
        clearSearchBtn.addEventListener('click', function() {
            productSearch.value = '';
            skuSearch.value = '';
            clearSearchInput.classList.add('hidden');
            hideSuggestions();
            updateSearchResults();
        });

        // Search button
        searchBtn.addEventListener('click', function() {
            const query = productSearch.value.trim();
            const sku = skuSearch.value.trim();

            if (query || sku) {
                console.log('Searching for:', {
                    query,
                    sku
                });
                alert(`Searching for: ${query || sku}`);
                if (query) addToRecentSearches(query);
            } else {
                alert('Please enter a search term or SKU');
            }
        });

        // Enter key search
        productSearch.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchBtn.click();
            }
        });

        skuSearch.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchBtn.click();
            }
        });
    });
</script>