<!-- Category Navigation Widget -->
<div class="category-widget bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 max-w-sm">

    <!-- Widget Header -->
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Categories</h3>
    </div>

    <!-- Category List -->
    <div class="space-y-1">

        <!-- Main Category: Clothing -->
        <div class="category-group">
            <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-toggle="clothing">
                <div class="flex items-center gap-3">
                    <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Clothing</label>
                </div>
                <div class="flex items-center gap-2">
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">45</span>
                    <svg class="w-4 h-4 text-gray-400 transition-transform duration-200 expand-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </div>
            </div>

            <!-- Subcategories -->
            <div class="subcategories pl-6 space-y-1 max-h-0 overflow-hidden transition-all duration-300" id="sub-clothing">
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="t-shirts">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">T-Shirts</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">12</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="jeans">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Jeans</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">18</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="shirts">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Shirts</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">15</span>
                </div>
            </div>
        </div>

        <!-- Main Category: Accessories -->
        <div class="category-group">
            <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-toggle="accessories">
                <div class="flex items-center gap-3">
                    <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Accessories</label>
                </div>
                <div class="flex items-center gap-2">
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">23</span>
                    <svg class="w-4 h-4 text-gray-400 transition-transform duration-200 expand-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </div>
            </div>

            <!-- Subcategories -->
            <div class="subcategories pl-6 space-y-1 max-h-0 overflow-hidden transition-all duration-300" id="sub-accessories">
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="bags">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Bags</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">8</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="belts">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Belts</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">9</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="hats">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Hats</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">6</span>
                </div>
            </div>
        </div>

        <!-- Main Category: Shoes -->
        <div class="category-group">
            <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-toggle="shoes">
                <div class="flex items-center gap-3">
                    <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Shoes</label>
                </div>
                <div class="flex items-center gap-2">
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">31</span>
                    <svg class="w-4 h-4 text-gray-400 transition-transform duration-200 expand-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </div>
            </div>

            <!-- Subcategories -->
            <div class="subcategories pl-6 space-y-1 max-h-0 overflow-hidden transition-all duration-300" id="sub-shoes">
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="sneakers">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Sneakers</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">14</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="boots">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Boots</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">11</span>
                </div>
                <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="sandals">
                    <div class="flex items-center gap-3">
                        <label class="text-sm text-gray-700 dark:text-gray-300 cursor-pointer">Sandals</label>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">6</span>
                </div>
            </div>
        </div>

        <!-- Single Categories -->
        <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="electronics">
            <div class="flex items-center gap-3">
                <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Electronics</label>
            </div>
            <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">29</span>
        </div>

        <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="home-living">
            <div class="flex items-center gap-3">
                <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Home & Living</label>
            </div>
            <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">17</span>
        </div>

        <div class="flex items-center justify-between p-2 hover:bg-gray-50 dark:hover:bg-gray-700 rounded-md cursor-pointer" data-category="sports">
            <div class="flex items-center gap-3">
                <label class="text-sm font-medium text-gray-900 dark:text-white cursor-pointer">Sports</label>
            </div>
            <span class="text-xs text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-2 py-1 rounded-full">22</span>
        </div>

    </div>

</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggles = document.querySelectorAll('[data-toggle]');
        const categoryItems = document.querySelectorAll('[data-category]');

        // Toggle subcategories
        toggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                const targetId = 'sub-' + this.dataset.toggle;
                const submenu = document.getElementById(targetId);
                const icon = this.querySelector('.expand-icon');

                if (submenu.style.maxHeight === '0px' || submenu.style.maxHeight === '') {
                    submenu.style.maxHeight = submenu.scrollHeight + 'px';
                    icon.style.transform = 'rotate(90deg)';
                } else {
                    submenu.style.maxHeight = '0px';
                    icon.style.transform = 'rotate(0deg)';
                }
            });
        });

        // Handle category clicks - navigate to category page
        categoryItems.forEach(item => {
            item.addEventListener('click', function() {
                const category = this.dataset.category;
                const categoryName = this.querySelector('label').textContent;

                // You can modify this URL structure to match your routing
                const categoryUrl = `products.php?category=${category}`;

                console.log(`Navigating to category: ${categoryName} (${category})`);

                // Navigate to category page
                window.location.href = categoryUrl;

                // Or if you want to open in new window:
                // window.open(categoryUrl, '_blank');
            });
        });

        // Handle parent category clicks (main categories)
        toggles.forEach(toggle => {
            // Add click handler for the label part (not the expand icon)
            const label = toggle.querySelector('label');
            if (label) {
                label.addEventListener('click', function(e) {
                    e.stopPropagation(); // Prevent expanding/collapsing

                    const category = toggle.dataset.toggle;
                    const categoryName = this.textContent;
                    const categoryUrl = `products.php?category=${category}`;

                    console.log(`Navigating to main category: ${categoryName} (${category})`);
                    window.location.href = categoryUrl;
                });
            }
        });
    });
</script>