<div class="space-y-4">
    <!-- Main Image -->
    <div class="relative bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
        <div class="aspect-w-1 aspect-h-1 w-full">
            <img id="mainImage"
                src="assets/images/product-6.jpg"
                alt="Mercer 7 Inch Chino Shorts - Main View"
                class="w-full h-96 md:h-[500px] object-cover">
        </div>

        <!-- Image Navigation Arrows -->
        <button id="prevImage" class="absolute left-4 top-1/2 transform -translate-y-1/2 bg-white/80 dark:bg-gray-800/80 p-2 rounded-full shadow-lg hover:bg-white dark:hover:bg-gray-800 transition-colors">
            <svg class="w-5 h-5 text-gray-700 dark:text-gray-300" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m15 18-6-6 6-6" />
            </svg>
        </button>

        <button id="nextImage" class="absolute right-4 top-1/2 transform -translate-y-1/2 bg-white/80 dark:bg-gray-800/80 p-2 rounded-full shadow-lg hover:bg-white dark:hover:bg-gray-800 transition-colors">
            <svg class="w-5 h-5 text-gray-700 dark:text-gray-300" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="m9 18 6-6-6-6" />
            </svg>
        </button>

        <!-- Sale Badge -->
        <div class="absolute top-4 left-4">
            <span class="bg-red-500 text-white px-3 py-1 rounded-full text-sm font-semibold">20% OFF</span>
        </div>

        <!-- Wishlist Button -->
        <button id="wishlistBtn" class="absolute top-4 right-4 bg-white/80 dark:bg-gray-800/80 p-2 rounded-full shadow-lg hover:bg-white dark:hover:bg-gray-800 transition-colors">
            <svg class="w-5 h-5 text-gray-700 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
            </svg>
        </button>

    </div>

    <!-- Thumbnail Images -->
    <div class="flex space-x-3 overflow-x-auto pb-2">
        <button class="thumbnail-btn flex-shrink-0 relative" data-image="assets/images/product-6-1.jpg">
            <img src="assets/images/product-6-1.jpg"
                alt="Thumbnail 1"
                class="w-20 h-20 object-cover rounded-md border-2 border-primary-500">
        </button>
        <button class="thumbnail-btn flex-shrink-0 relative" data-image="assets/images/product-6-2.jpg">
            <img src="assets/images/product-6-2.jpg"
                alt="Thumbnail 2"
                class="w-20 h-20 object-cover rounded-md border-2 border-transparent hover:border-primary-300">
        </button>
        <button class="thumbnail-btn flex-shrink-0 relative" data-image="assets/images/product-6-3.jpg">
            <img src="assets/images/product-6-3.jpg"
                alt="Thumbnail 3"
                class="w-20 h-20 object-cover rounded-md border-2 border-transparent hover:border-primary-300">
        </button>
        <button class="thumbnail-btn flex-shrink-0 relative" data-image="assets/images/product-6-4.jpg">
            <img src="assets/images/product-6-4.jpg"
                alt="Thumbnail 4"
                class="w-20 h-20 object-cover rounded-md border-2 border-transparent hover:border-primary-300">
        </button>
    </div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Image slider functionality
        const mainImage = document.getElementById('mainImage');
        const thumbnails = document.querySelectorAll('.thumbnail-btn');
        const prevBtn = document.getElementById('prevImage');
        const nextBtn = document.getElementById('nextImage');
        let currentImageIndex = 0;

        const images = [
            'assets/images/product-6-1.jpg',
            'assets/images/product-6-2.jpg',
            'assets/images/product-6-3.jpg',
            'assets/images/product-6-4.jpg'
        ];

        // Thumbnail clicks
        thumbnails.forEach((thumb, index) => {
            thumb.addEventListener('click', function() {
                currentImageIndex = index;
                updateMainImage();
                updateThumbnailSelection();
            });
        });

        // Previous/Next buttons
        prevBtn.addEventListener('click', function() {
            currentImageIndex = (currentImageIndex - 1 + images.length) % images.length;
            updateMainImage();
            updateThumbnailSelection();
        });

        nextBtn.addEventListener('click', function() {
            currentImageIndex = (currentImageIndex + 1) % images.length;
            updateMainImage();
            updateThumbnailSelection();
        });

        function updateMainImage() {
            mainImage.src = images[currentImageIndex];
        }

        function updateThumbnailSelection() {
            thumbnails.forEach((thumb, index) => {
                const img = thumb.querySelector('img');
                if (index === currentImageIndex) {
                    img.classList.remove('border-transparent', 'border-gray-300');
                    img.classList.add('border-primary-500');
                } else {
                    img.classList.remove('border-primary-500');
                    img.classList.add('border-transparent');
                }
            });
        }

        // Wishlist toggle
        const wishlistBtn = document.getElementById('wishlistBtn');
        let isWishlisted = false;

        wishlistBtn.addEventListener('click', function() {
            isWishlisted = !isWishlisted;
            const svg = this.querySelector('svg');

            if (isWishlisted) {
                svg.classList.remove('text-gray-700', 'dark:text-gray-300');
                svg.classList.add('text-primary-400');
                svg.setAttribute('fill', 'currentColor');
            } else {
                svg.classList.remove('text-primary-400');
                svg.classList.add('text-gray-700', 'dark:text-gray-300');
                svg.setAttribute('fill', 'none');
            }
        });

        updateThumbnailSelection();
    });
</script>