<div class="product-item w-full bg-white dark:bg-gray-800 rounded-md lg:rounded-xl shadow flex flex-col">

    <?php if (!empty($product['image'])): ?>
        <a href="single.php"
            class="product-thumbnail relative block overflow-hidden rounded-t-md lg:rounded-t-xl <?php echo (!empty($product['hover'])) ? 'group' : ''; ?> aspect-[4/5]">

            <img src="<?php echo $product['image']; ?>"
                alt="<?php echo $product['title']; ?>"
                class="w-full h-full object-cover transition-all duration-500 ease-in-out transform group-hover:scale-105 group-hover:opacity-0">

            <?php if (!empty($product['hover'])): ?>
                <img src="<?php echo $product['hover']; ?>"
                    alt="<?php echo $product['title']; ?> hover image"
                    class="absolute inset-0 w-full h-full object-cover transition-all duration-500 ease-in-out transform scale-105 opacity-0 group-hover:scale-100 group-hover:opacity-100">
            <?php endif; ?>

        </a>
    <?php else: ?>
        <div class="product-thumbnail-placeholder bg-gray-200 dark:bg-gray-700 w-full aspect-[4/5] rounded-t-md lg:rounded-t-xl flex items-center justify-center text-gray-400 dark:text-gray-400 text-xs text-center">
            <div class="text-center">
                <svg class="w-8 h-8 m-auto" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor"
                    stroke-width="1" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <path d="M16 5h6"></path>
                    <path d="M19 2v6"></path>
                    <path d="M21 11.5V19a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h7.5"></path>
                    <path d="m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21"></path>
                    <circle cx="9" cy="9" r="2"></circle>
                </svg>
                <div class="mt-2">Image Not Set</div>
            </div>
        </div>
    <?php endif; ?>

    <div class="p-2 lg:p-4 flex flex-col flex-1">

        <div class="product-body mb-2">
            <h3 class="product-title font-semibold text-sm lg:text-base mb-2">
                <a href="single.php" class="line-clamp-2">
                    <?php echo $product['title']; ?>
                </a>
            </h3>

            <div class="product-price flex items-center gap-1 mb-3">
                <?php if (!empty($product['old_price'])): ?>
                    <p class="text-gray-500 dark:text-gray-300 line-through text-sm flex items-center gap-1">
                        <svg
                            class="inline-block w-3 h-3 lg:w-4 lg:h-4 text-gray-800 dark:text-white"
                            width="13" height="15" viewBox="0 0 13 15" fill="currentColor"
                            xmlns="http://www.w3.org/2000/svg">

                            <path d="M7.37833 14.7315L12.153 13.917L12.7727 12.3003L7.99858 13.1148L7.37833 14.7315Z"></path>
                            <path d="M9.09164 8.45597L12.3802 7.89488L13 6.27819L9.14046 6.9369L9.31351 1.58047L7.7836 2.80667L7.6416 7.19279L6.19205 7.4403L6.40998 0.731445L4.88006 1.95765L4.69468 7.6952L1.52292 8.23656L0.903169 9.85325L4.64587 9.21476L4.58522 11.0933L0.664042 11.7623L0.0437927 13.3785L4.3244 12.6478C4.51817 12.6148 4.6932 12.5132 4.81794 12.3619L5.90559 11.0435C6.02097 10.9039 6.08654 10.7299 6.09246 10.5489L6.14373 8.95838L7.59328 8.71087L7.49714 11.6879L12.3142 10.866L12.9339 9.24927L9.04431 9.91291L9.09164 8.45498V8.45597Z"></path>
                        </svg>
                        <?php echo $product['old_price']; ?>
                    </p>
                <?php endif; ?>
                <p class="text-sm lg:text-base font-semibold text-secondary-600 flex items-center gap-1">
                    <svg
                        class="inline-block w-3 h-3 lg:w-4 lg:h-4 text-gray-800 dark:text-white"
                        width="13" height="15" viewBox="0 0 13 15" fill="currentColor"
                        xmlns="http://www.w3.org/2000/svg">

                        <path d="M7.37833 14.7315L12.153 13.917L12.7727 12.3003L7.99858 13.1148L7.37833 14.7315Z"></path>
                        <path d="M9.09164 8.45597L12.3802 7.89488L13 6.27819L9.14046 6.9369L9.31351 1.58047L7.7836 2.80667L7.6416 7.19279L6.19205 7.4403L6.40998 0.731445L4.88006 1.95765L4.69468 7.6952L1.52292 8.23656L0.903169 9.85325L4.64587 9.21476L4.58522 11.0933L0.664042 11.7623L0.0437927 13.3785L4.3244 12.6478C4.51817 12.6148 4.6932 12.5132 4.81794 12.3619L5.90559 11.0435C6.02097 10.9039 6.08654 10.7299 6.09246 10.5489L6.14373 8.95838L7.59328 8.71087L7.49714 11.6879L12.3142 10.866L12.9339 9.24927L9.04431 9.91291L9.09164 8.45498V8.45597Z"></path>
                    </svg>
                    <?php echo $product['price']; ?>
                </p>
            </div>

            <?php if (!empty($product['colors'])): ?>
                <div class="product-colors flex items-center gap-1 mb-3">
                    <?php foreach ($product['colors'] as $index => $color): ?>
                        <button
                            class="color-option <?php echo ($index === 0) ? 'color-option-active' : 'color-option-default'; ?>"
                            style="background-color: <?php echo htmlspecialchars($color); ?>;"
                            data-color="<?php echo htmlspecialchars($color); ?>">
                        </button>
                    <?php endforeach; ?>
                    <?php if (count($product['colors']) > 2): ?>
                        <span class="text-sm text-gray-500 dark:text-gray-300">+<?php echo count($product['colors']) - 2; ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($product['sizes'])): ?>
                <div class="product-sizes flex items-center gap-1 mb-3">
                    <?php foreach ($product['sizes'] as $index => $size): ?>
                        <button
                            class="size-option <?php echo ($index === 0) ? 'size-option-active' : 'size-option-default'; ?>"
                            data-size="<?php echo htmlspecialchars($size); ?>">
                            <?php echo htmlspecialchars($size); ?>
                        </button>
                    <?php endforeach; ?>
                    <?php if (count($product['sizes']) > 3): ?>
                        <span class="text-sm text-gray-500 dark:text-gray-300">+<?php echo count($product['sizes']) - 3; ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </div>

        <div class="product-footer mt-auto flex gap-2 items-stretch justify-between">

            <button class="product-add-to-cart flex-1 te-btn te-btn-primary flex items-center justify-center gap-2">

                <!-- Cart Icon -->
                <svg class="icon-cart w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M2.048 18.566A2 2 0 0 0 4 21h16a2 2 0 0 0 1.952-2.434l-2-9A2 2 0 0 0 18 8H6a2 2 0 0 0-1.952 1.566z" />
                    <path d="M8 11V6a4 4 0 0 1 8 0v5" />
                </svg>

                <!-- Check Icon (hidden by default) -->
                <svg class="icon-check w-5 h-5 hidden" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M20 6 9 17l-5-5" />
                </svg>

                <span class="hidden lg:block">Add to Cart</span>
            </button>

            <button class="product-add-to-wishlist flex items-center justify-center p-2 rounded-lg border border-gray-300 hover:bg-gray-100 dark:border-gray-700 dark:hover:bg-gray-700 transition-all duration-300 ease-in-out">
                <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M2 9.5a5.5 5.5 0 0 1 9.591-3.676.56.56 0 0 0 .818 0A5.49 5.49 0 0 1 22 9.5c0 2.29-1.5 4-3 5.5l-5.492 5.313a2 2 0 0 1-3 .019L5 15c-1.5-1.5-3-3.2-3-5.5" />
                </svg>
            </button>

        </div>

    </div>

</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {

        // Find all product containers
        const productItems = document.querySelectorAll('.product-item');

        productItems.forEach(item => {
            // Get elements specific to this product
            const colorOptions = item.querySelectorAll('.color-option');
            const sizeOptions = item.querySelectorAll('.size-option');
            const addToCartBtn = item.querySelector('.product-add-to-cart');
            const wishlistBtn = item.querySelector('.product-add-to-wishlist');

            let isWishlisted = false;

            // Color selection
            colorOptions.forEach((color, index) => {
                color.addEventListener('click', function() {
                    colorOptions.forEach(c => {
                        c.classList.remove('border-primary-500');
                        c.classList.add('border-gray-300', 'hover:border-primary-300');
                    });
                    this.classList.remove('border-gray-300', 'hover:border-primary-300');
                    this.classList.add('border-primary-500');
                });
            });

            // Size selection
            sizeOptions.forEach(size => {
                size.addEventListener('click', function() {
                    sizeOptions.forEach(s => {
                        s.classList.remove('bg-primary-600', 'border-primary-600', 'text-white');
                        s.classList.add('bg-white', 'dark:bg-gray-700', 'border-gray-300', 'dark:border-gray-600', 'text-gray-700', 'dark:text-gray-300');
                    });
                    this.classList.remove('bg-white', 'dark:bg-gray-700', 'border-gray-300', 'dark:border-gray-600', 'text-gray-700', 'dark:text-gray-300');
                    this.classList.add('bg-primary-600', 'border-primary-600', 'text-white');
                });
            });

            // Add to cart functionality
            addToCartBtn.addEventListener('click', function() {
                const selectedColor = item.querySelector('.color-option.border-primary-500')?.dataset.color;
                const selectedSize = item.querySelector('.size-option.bg-primary-600')?.dataset.size;
                const productTitle = item.querySelector('.product-title a').textContent.trim();

                console.log('Added to cart:', {
                    product: productTitle,
                    color: selectedColor,
                    size: selectedSize,
                    quantity: 1
                });

                const cartIcon = this.querySelector('svg:not(.icon-check)');
                const checkIcon = this.querySelector('.icon-check');
                const textSpan = this.querySelector('span');

                // Switch icons
                cartIcon.classList.add('hidden');
                checkIcon.classList.remove('hidden');

                // Change text + style
                textSpan.textContent = 'Added!';
                this.classList.add('bg-green-600', 'hover:bg-green-700');

                // Reset after 2s
                setTimeout(() => {
                    cartIcon.classList.remove('hidden');
                    checkIcon.classList.add('hidden');
                    textSpan.textContent = 'Add to Cart';
                    this.classList.remove('bg-green-600', 'hover:bg-green-700');
                }, 2000);
            });



            // Wishlist functionality
            wishlistBtn.addEventListener('click', function() {
                isWishlisted = !isWishlisted;
                const svg = this.querySelector('svg');

                if (isWishlisted) {
                    svg.classList.remove('text-gray-700', 'dark:text-gray-300');
                    svg.classList.add('text-primary-400');
                    svg.setAttribute('fill', 'currentColor');
                } else {
                    svg.classList.remove('text-primary-400');
                    svg.classList.add('text-gray-700', 'dark:text-gray-300');
                    svg.setAttribute('fill', 'none');
                }
            });


        });
    });
</script>