<div class="flex items-center">
    <button id="darkModeToggle" class="te-navbar-icon-button" aria-label="Toggle Dark Mode">

        <!-- Sun Icon -->
        <div class="sun absolute inset-2 w-6 h-6 text-amber-500 opacity-100 rotate-0 dark:opacity-0 dark:rotate-180">
            <svg fill="currentColor" viewBox="0 0 24 24" class="-translate-x-0.25 w-full h-full">
                <path d="M12 2.25a.75.75 0 01.75.75v2.25a.75.75 0 01-1.5 0V3a.75.75 0 01.75-.75zM7.5 12a4.5 4.5 0 119 0 4.5 4.5 0 01-9 0zM18.894 6.166a.75.75 0 00-1.06-1.06l-1.591 1.59a.75.75 0 101.06 1.061l1.591-1.59zM21.75 12a.75.75 0 01-.75.75h-2.25a.75.75 0 010-1.5H21a.75.75 0 01.75.75zM17.834 18.894a.75.75 0 001.06-1.06l-1.59-1.591a.75.75 0 10-1.061 1.06l1.59 1.591zM12 18a.75.75 0 01.75.75V21a.75.75 0 01-1.5 0v-2.25A.75.75 0 0112 18zM7.758 17.303a.75.75 0 00-1.061-1.06l-1.591 1.59a.75.75 0 001.06 1.061l1.591-1.59zM6 12a.75.75 0 01-.75.75H3a.75.75 0 010-1.5h2.25A.75.75 0 016 12zM6.697 7.757a.75.75 0 001.06-1.06l-1.59-1.591a.75.75 0 00-1.061 1.06l1.59 1.591z"></path>
            </svg>
        </div>

        <!-- Moon Icon -->
        <div class="moon absolute inset-2 w-6 h-6 text-slate-300 opacity-0 dark:opacity-100 dark:rotate-0 scale-75">
            <svg fill="currentColor" viewBox="0 0 24 24" class="w-full h-full">
                <path fill-rule="evenodd" d="M9.528 1.718a.75.75 0 01.162.819A8.97 8.97 0 009 6a9 9 0 009 9 8.97 8.97 0 003.463-.69.75.75 0 01.981.98 10.503 10.503 0 01-9.694 6.46c-5.799 0-10.5-4.701-10.5-10.5 0-4.368 2.667-8.112 6.46-9.694a.75.75 0 01.818.162z" clip-rule="evenodd"></path>
            </svg>
        </div>

    </button>

    <span id="dark-mode-description" class="sr-only">
        Toggle between light and dark themes </span>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggle = document.getElementById('darkModeToggle');
        const html = document.documentElement;

        // Function to temporarily disable transitions
        function disableTransitions() {
            html.classList.add('no-transition');
            // Re-enable transitions after theme change is complete
            setTimeout(() => {
                html.classList.remove('no-transition');
            }, 50);
        }

        // Mark as ready to prevent any remaining flash
        html.classList.add('light');

        // Check current state
        const savedTheme = localStorage.getItem('theme');
        const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
        const isDark = savedTheme === 'dark' || (!savedTheme && prefersDark);

        // Ensure correct class is applied
        if (isDark) {
            disableTransitions();
            html.classList.remove('light');
            html.classList.add('dark');
        }

        // Toggle functionality
        toggle.addEventListener('click', function() {
            const willBeDark = !html.classList.contains('dark');

            // Disable transitions before theme change
            disableTransitions();

            if (willBeDark) {
                html.classList.remove('light');
                html.classList.add('dark');
                localStorage.setItem('theme', 'dark');
            } else {
                html.classList.remove('dark');
                html.classList.add('light');
                localStorage.setItem('theme', 'light');
            }
        });

        // System preference change
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (!localStorage.getItem('theme')) {
                disableTransitions();

                if (e.matches) {
                    html.classList.remove('light');
                    html.classList.add('dark');
                } else {
                    html.classList.remove('dark');
                    html.classList.add('light');
                }
            }
        });
    });
</script>