<?php include 'header.php'; ?>

<!-- Breadcrumb -->
<?php include 'template-parts/header/header-breadcrumb.php'; ?>

<!-- Product Details Container -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">

    <!-- Left Side - Image Slider -->
    <?php include 'template-parts/product/product-gallery.php'; ?>

    <!-- Right Side - Product Details -->
    <div class="space-y-6">

        <!-- Product Title and Rating -->
        <div>
            <h1 class="product-title text-3xl font-bold text-gray-900 dark:text-white mb-2">Mercer 7 Inch Chino Shorts</h1>

            <div class="flex items-center space-x-4">
                <div class="flex items-center">
                    <div class="product-rating flex space-x-1">
                        <svg class="w-4 h-4 text-yellow-400 fill-current" viewBox="0 0 24 24">
                            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                        </svg>
                        <svg class="w-4 h-4 text-yellow-400 fill-current" viewBox="0 0 24 24">
                            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                        </svg>
                        <svg class="w-4 h-4 text-yellow-400 fill-current" viewBox="0 0 24 24">
                            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                        </svg>
                        <svg class="w-4 h-4 text-yellow-400 fill-current" viewBox="0 0 24 24">
                            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                        </svg>
                        <svg class="w-4 h-4 text-gray-300 fill-current" viewBox="0 0 24 24">
                            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
                        </svg>
                    </div>
                    <span class="text-sm text-gray-600 dark:text-gray-400 ml-2">4.2 (89 reviews)</span>
                </div>
                <span class="product-stock text-sm text-green-600 dark:text-green-400">In Stock</span>
            </div>
        </div>

        <!-- Price -->
        <div class="product-price flex items-baseline space-x-2">
            <span class="text-3xl font-bold text-gray-900 dark:text-white">
                <svg class="inline-block w-4 h-4 lg:w-5 lg:h-5 text-gray-800 dark:text-white" width="16" height="17" viewBox="0 0 13 15" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.37833 14.7315L12.153 13.917L12.7727 12.3003L7.99858 13.1148L7.37833 14.7315Z"></path>
                    <path d="M9.09164 8.45597L12.3802 7.89488L13 6.27819L9.14046 6.9369L9.31351 1.58047L7.7836 2.80667L7.6416 7.19279L6.19205 7.4403L6.40998 0.731445L4.88006 1.95765L4.69468 7.6952L1.52292 8.23656L0.903169 9.85325L4.64587 9.21476L4.58522 11.0933L0.664042 11.7623L0.0437927 13.3785L4.3244 12.6478C4.51817 12.6148 4.6932 12.5132 4.81794 12.3619L5.90559 11.0435C6.02097 10.9039 6.08654 10.7299 6.09246 10.5489L6.14373 8.95838L7.59328 8.71087L7.49714 11.6879L12.3142 10.866L12.9339 9.24927L9.04431 9.91291L9.09164 8.45498V8.45597Z"></path>
                </svg>
                <span class="text-secondary-600">200.00</span>
            </span>
            <span class="text-lg text-gray-500 dark:text-gray-400 line-through">
                <svg class="inline-block w-3 h-3 lg:w-4 lg:h-4 text-gray-800 dark:text-white" width="13" height="15" viewBox="0 0 13 15" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7.37833 14.7315L12.153 13.917L12.7727 12.3003L7.99858 13.1148L7.37833 14.7315Z"></path>
                    <path d="M9.09164 8.45597L12.3802 7.89488L13 6.27819L9.14046 6.9369L9.31351 1.58047L7.7836 2.80667L7.6416 7.19279L6.19205 7.4403L6.40998 0.731445L4.88006 1.95765L4.69468 7.6952L1.52292 8.23656L0.903169 9.85325L4.64587 9.21476L4.58522 11.0933L0.664042 11.7623L0.0437927 13.3785L4.3244 12.6478C4.51817 12.6148 4.6932 12.5132 4.81794 12.3619L5.90559 11.0435C6.02097 10.9039 6.08654 10.7299 6.09246 10.5489L6.14373 8.95838L7.59328 8.71087L7.49714 11.6879L12.3142 10.866L12.9339 9.24927L9.04431 9.91291L9.09164 8.45498V8.45597Z"></path>
                </svg>
                <span>300.00</span>
            </span>
        </div>

        <!-- Product Description -->
        <div class="product-desc">
            <p class="text-gray-700 dark:text-gray-300 text-base leading-relaxed">
                Experience ultimate comfort with our Mercer 7 Inch Chino Shorts. Made from 100% organic cotton with a soft, breathable fabric that's perfect for everyday wear. Features a classic fit and durable construction that maintains its shape wash after wash.
            </p>
        </div>

        <!-- Color Selection -->
        <div class="product-colors">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">Color</h3>
            <div class="flex space-x-3">
                <button class="color-option border-primary-500" style="background-color: blue;" data-color="blue"></button>
                <button class="color-option border-gray-300 hover:border-primary-300" style="background-color: red;" data-color="red"></button>
                <button class="color-option border-gray-300 hover:border-primary-300" style="background-color: green;" data-color="green"></button>
                <button class="color-option border-gray-300 hover:border-primary-300" style="background-color: black;" data-color="black"></button>
                <button class="color-option border-gray-300 hover:border-primary-300" style="background-color: white;" data-color="white"></button>
            </div>
        </div>

        <!-- Size Selection -->
        <div class="product-sizes">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">Size</h3>
            <div class="grid grid-cols-5 gap-2">
                <button class="size-option size-option-default" data-size="XS">XS</button>
                <button class="size-option size-option-default" data-size="S">S</button>
                <button class="size-option size-option-active" data-size="M">M</button>
                <button class="size-option size-option-default" data-size="L">L</button>
                <button class="size-option size-option-default" data-size="XL">XL</button>
            </div>
            <a href="#" class="text-sm text-primary-600 dark:text-primary-200 hover:text-primary-700 mt-2 inline-block">
                Size Guide
            </a>
        </div>

        <!-- Quantity -->
        <div class="product-quantity">
            <h3 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">Quantity</h3>
            <div class="flex items-center space-x-3">
                <div class="flex items-center border border-gray-300 dark:border-gray-600 rounded-md">
                    <button id="decreaseQty" class="px-3 py-2 text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path>
                        </svg>
                    </button>
                    <input id="quantity" type="number" value="1" min="1" max="10" class="w-16 px-2 py-2 text-center text-gray-900 dark:text-white bg-white dark:bg-gray-700 border-0 focus:outline-none">
                    <button id="increaseQty" class="px-3 py-2 text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                    </button>
                </div>
                <span class="text-sm text-gray-600 dark:text-gray-400">Only 5 left in stock</span>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="space-y-3">

            <button id="addToCart" class="w-full py-1 product-add-to-cart flex-1 te-btn te-btn-primary flex items-center justify-center gap-2">
                <!-- Cart Icon -->
                <svg class="icon-cart w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M2.048 18.566A2 2 0 0 0 4 21h16a2 2 0 0 0 1.952-2.434l-2-9A2 2 0 0 0 18 8H6a2 2 0 0 0-1.952 1.566z" />
                    <path d="M8 11V6a4 4 0 0 1 8 0v5" />
                </svg>

                <!-- Check Icon (hidden by default) -->
                <svg class="icon-check w-5 h-5 hidden" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M20 6 9 17l-5-5" />
                </svg>

                <span>Add to Cart</span>
            </button>

            <button id="buyNow" class="w-full py-1 te-btn te-btn-default">
                Buy Now
            </button>
        </div>

    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {

        // Color selection
        const colorOptions = document.querySelectorAll('.color-option');
        colorOptions.forEach(color => {
            color.addEventListener('click', function() {
                colorOptions.forEach(c => {
                    c.classList.remove('border-primary-500');
                    c.classList.add('border-gray-300', 'hover:border-primary-300');
                });
                this.classList.remove('border-gray-300', 'hover:border-primary-300');
                this.classList.add('border-primary-500');
            });
        });

        // Size selection
        const sizeOptions = document.querySelectorAll('.size-option');
        sizeOptions.forEach(size => {
            size.addEventListener('click', function() {
                sizeOptions.forEach(s => {
                    s.classList.remove('bg-primary-600', 'border-primary-600', 'text-white');
                    s.classList.add('bg-white', 'dark:bg-gray-700', 'border-gray-300', 'dark:border-gray-600', 'text-gray-700', 'dark:text-gray-300');
                });
                this.classList.remove('bg-white', 'dark:bg-gray-700', 'border-gray-300', 'dark:border-gray-600', 'text-gray-700', 'dark:text-gray-300');
                this.classList.add('bg-primary-600', 'border-primary-600', 'text-white');
            });
        });

        // Quantity controls
        const quantityInput = document.getElementById('quantity');
        const decreaseBtn = document.getElementById('decreaseQty');
        const increaseBtn = document.getElementById('increaseQty');

        decreaseBtn.addEventListener('click', function() {
            const currentValue = parseInt(quantityInput.value);
            if (currentValue > 1) {
                quantityInput.value = currentValue - 1;
            }
        });

        increaseBtn.addEventListener('click', function() {
            const currentValue = parseInt(quantityInput.value);
            const maxValue = parseInt(quantityInput.max);
            if (currentValue < maxValue) {
                quantityInput.value = currentValue + 1;
            }
        });

        // Add to cart functionality
        const addToCartBtn = document.getElementById('addToCart');
        const buyNowBtn = document.getElementById('buyNow');

        addToCartBtn.addEventListener('click', function() {
            const selectedColor = document.querySelector('.color-option.border-primary-500')?.dataset.color || 'blue';
            const selectedSize = document.querySelector('.size-option.bg-primary-600')?.dataset.size || 'M';
            const quantity = quantityInput.value;

            console.log('Added to cart:', {
                product: 'Mercer 7 Inch Chino Shorts',
                color: selectedColor,
                size: selectedSize,
                quantity: quantity,
                price: 24.99
            });

            const cartIcon = this.querySelector('.icon-cart');
            const checkIcon = this.querySelector('.icon-check');
            const textSpan = this.querySelector('span');

            // Swap icons
            cartIcon.classList.add('hidden');
            checkIcon.classList.remove('hidden');

            // Change text + style
            textSpan.textContent = 'Added!';
            this.classList.remove('bg-primary-600', 'hover:bg-primary-700');
            this.classList.add('bg-green-600', 'hover:bg-green-700');

            // Reset after 2s
            setTimeout(() => {
                cartIcon.classList.remove('hidden');
                checkIcon.classList.add('hidden');
                textSpan.textContent = 'Add to Cart';
                this.classList.remove('bg-green-600', 'hover:bg-green-700');
                this.classList.add('bg-primary-600', 'hover:bg-primary-700');
            }, 2000);
        });


        buyNowBtn.addEventListener('click', function() {
            const selectedColor = document.querySelector('.color-option.border-primary-500')?.dataset.color || 'blue';
            const selectedSize = document.querySelector('.size-option.bg-primary-600')?.dataset.size || 'M';
            const quantity = quantityInput.value;

            console.log('Buy now:', {
                product: 'Mercer 7 Inch Chino Shorts',
                color: selectedColor,
                size: selectedSize,
                quantity: quantity,
                price: 24.99
            });

            alert('Redirecting to checkout...');
        });


    });
</script>

<?php include 'footer.php'; ?>