// middleware.ts
import { NextResponse } from "next/server";
import type { NextRequest } from "next/server";

export function middleware(request: NextRequest) {
    const { pathname } = request.nextUrl;

    // لو الرابط يبدأ بـ /ar → نشيل الـ prefix ونضيف lang=ar
    if (pathname.startsWith("/ar")) {
        const newUrl = request.nextUrl.clone();
        newUrl.pathname = pathname.replace(/^\/ar/, "") || "/";
        newUrl.searchParams.set("lang", "ar");
        return NextResponse.rewrite(newUrl);
    }

    // لو الرابط يبدأ بـ /en → نشيل الـ prefix ونضيف lang=en
    if (pathname.startsWith("/en")) {
        const newUrl = request.nextUrl.clone();
        newUrl.pathname = pathname.replace(/^\/en/, "") || "/";
        newUrl.searchParams.set("lang", "en");
        return NextResponse.rewrite(newUrl);
    }

    return NextResponse.next();
}
