'use client';

interface SectionHeaderProps {
  title: string;
  subtitle?: string;
  level?: 'h1' | 'h2'; // Only h1 or h2 allowed
  size?: 'large' | 'default'; // Size for h1 and p (subtitle)
  textAlign?: 'start' | 'center' | 'end'; // Text alignment option
  className?: string; // Additional custom classes
  smallTitle?: string; // Option to apply small title text, displayed above the main title
  marginBottom?: string; // Option to customize margin-bottom
}

export default function SectionHeader({
  title,
  subtitle,
  level = 'h2',
  size = 'default',
  textAlign = 'center',
  className = '',
  smallTitle = '', // smallTitle text to be displayed above the main title
  marginBottom = '6', // Default margin-bottom value
}: SectionHeaderProps) {
  // Dynamically select the heading tag based on the level prop
  const HeadingTag = level;

  // Classes for heading size based on the 'size' prop or smallTitle
  const headingClasses = size === 'large'
    ? 'text-3xl md:text-4xl'
    : 'text-3xl'; // Default or large title

  // Classes for paragraph size based on the 'size' prop
  const paragraphClasses = size === 'large' ? 'text-lg' : 'text-base';

  // Classes for text alignment
  const textAlignClasses = textAlign === 'start' ? 'text-start' : textAlign === 'end' ? 'text-end' : 'text-center';

  // Calculate max width dynamically based on alignment
  const paragraphWidthClasses = textAlign === 'center' ? 'max-w-2xl mx-auto' : 'max-w-full';

  return (
    <div className={`heading-section mb-${marginBottom} space-y-2 ${textAlignClasses} ${className}`}>
      {/* Conditionally render smallTitle */}
      {smallTitle && <small className="block text-sm font-semibold text-primary-500 dark:text-primary-300">{smallTitle}</small>}
      <HeadingTag
        className={`${headingClasses} font-bold text-gray-900 dark:text-gray-100`}
        aria-level={level === 'h1' ? 1 : 2}
      >
        {title}
      </HeadingTag>
      {subtitle && (
        <p className={`${paragraphClasses} text-gray-600 dark:text-gray-300 ${paragraphWidthClasses}`}>
          {subtitle}
        </p>
      )}
    </div>
  );
}
