"use client";

import SectionHeader from "@/components/common/SectionHeader";
import { useLanguage } from "@/contexts/LanguageContext";

export default function Home() {
  const { language } = useLanguage();

  return (
    <section className="mt-16">
      <div className="te-home">
        {/* Section Header */}
        <SectionHeader
          title={language === "ar" ? "مرحباً بكم في موقعنا" : "Welcome to Our Website"}
          subtitle={
            language === "ar"
              ? "نحن هنا لتقديم أفضل الحلول والخدمات، واستعراض أعمالنا التي تبرز الإبداع والاحترافية في كل مشروع."
              : "We are here to provide the best solutions and services, showcasing our work that highlights creativity and professionalism in every project."
          }
        />
      </div>
    </section>
  );
}
