"use client";

import { useEffect, useState } from "react";
import { useLanguage } from "@/contexts/LanguageContext";
import ContactInfo from '@/components/customizer/ContactInfo';
import wordpressAPI from "@/lib/wordpress";

export default function ContactPage() {
    const { language } = useLanguage();
    const [page, setPage] = useState<any | null>(null);

    // ✅ Translations
    const [translations, setTranslations] = useState<any | null>(null);
    const [loadingTranslations, setLoadingTranslations] = useState(true);

    // ✅ Fetch page content
    useEffect(() => {
        const fetchData = async () => {
            const data = await wordpressAPI.getPageBySlug("contact", language);
            setPage(data);
        };
        fetchData();
    }, [language]);

    // ✅ Fetch translations
    useEffect(() => {
        const loadTranslations = async () => {
            try {
                setLoadingTranslations(true);
                const data = await wordpressAPI.getTranslations();
                setTranslations(data);
            } catch (error) {
                console.error("Error loading translations:", error);
            } finally {
                setLoadingTranslations(false);
            }
        };
        loadTranslations();
    }, []);

    if (!page) return null;

    return (
        <section className="contact-page text-gray-900 dark:text-white py-12">
            <div className="container space-y-12">
                {/* 🔹 Info + Social vs Empty Column */}
                <div className="grid grid-cols-1 md:grid-cols-2 gap-8">

                    {/* Left column → Info + Social */}
                    <div className="space-y-8">

                        <div>
                            {/* ✅ Contact Info Title */}
                            <h2 className="text-xl font-semibold mb-4">
                                {loadingTranslations
                                    ? "..."
                                    : language === "ar"
                                        ? translations?.contact_info_title_ar
                                        : translations?.contact_info_title_en}
                            </h2>
                            <ContactInfo showInfo={true} showSocial={false} showMap={false} />
                        </div>

                        <div>
                            {/* ✅ Social Title */}
                            <h2 className="text-xl font-semibold mb-4">
                                {loadingTranslations
                                    ? "..."
                                    : language === "ar"
                                        ? translations?.contact_social_title_ar
                                        : translations?.contact_social_title_en}
                            </h2>
                            <ContactInfo showInfo={false} showSocial={true} showMap={false} />
                        </div>
                    </div>

                    {/* Right column → Form */}
                    <div className="space-y-6">
                        <h2 className="text-xl font-semibold mb-4">
                            {loadingTranslations
                                ? "..."
                                : language === "ar"
                                    ? translations?.contact_form_title_ar
                                    : translations?.contact_form_title_en}
                        </h2>
                        {/* ⬇️ هنا بعدين هتضيف الفورم */}
                    </div>
                </div>

                {/* 🔹 Map full width under grid */}
                <div>
                    <ContactInfo showInfo={false} showSocial={false} showMap={true} />
                </div>
            </div>
        </section>
    );
}
