const { generatePaletteFromHex } = require('./colors');

module.exports = {
    darkMode: 'class',
    content: [
        "./app/**/*.{js,ts,jsx,tsx,mdx}",
        "./components/**/*.{js,ts,jsx,tsx,mdx}",
        "./pages/**/*.{js,ts,jsx,tsx,mdx}",
    ],
    theme: {
        container: {
            center: true,
            padding: {
                DEFAULT: '1rem',
                sm: '1rem',
                lg: '1rem',
                xl: '1rem',
                '2xl': '1rem',
            },
            screens: {
                lg: '1024px',
                xl: '1280px',
            },
        },
        extend: {
            fontFamily: {
                ltr: ['var(--font-inter)', 'ui-sans-serif', 'system-ui', 'sans-serif'],
                rtl: ['var(--font-somarsans)', 'ui-sans-serif', 'system-ui', 'sans-serif'],
            },
            colors: {
                primary: generatePaletteFromHex('#0068ff'),
                secondary: generatePaletteFromHex('#5C00FF'),
                accent: generatePaletteFromHex('#ff8600'),
                gray: {
                    50: '#f9fafb',
                    100: '#f3f4f6',
                    200: '#e5e7eb',
                    300: '#d1d5db',
                    400: '#9ca3af',
                    500: '#6b7280',
                    600: '#4b5563',
                    700: '#374151',
                    800: '#1f2937',
                    900: '#111827',
                },
            },
            typography: {
                DEFAULT: {
                    css: {
                        maxWidth: 'none',
                        color: '#374151',
                        a: {
                            color: '#2563eb',
                            '&:hover': {
                                color: '#6b7280',
                            },
                        },
                        img: {
                            borderRadius: '0.75rem',
                        },
                    },
                },
            },
        },
    },
    plugins: [
        require('@tailwindcss/typography'),
        require('@tailwindcss/forms'),
    ],
}
