// Load WordPress URL from environment variable, with a fallback to a default URL if not set
const wpUrl = new URL(process.env.NEXT_PUBLIC_WORDPRESS_URL || "http://elagami.com/last");

// Ensure uploads always match the right subdirectory
const uploadsPath = `${wpUrl.pathname.replace(/\/$/, "")}/wp-content/uploads/**`;

module.exports = {
  reactStrictMode: true,

  // Image Optimization Configuration
  images: {
    domains: [wpUrl.hostname], // Define the allowed domain for remote images
    remotePatterns: [
      {
        // Protocol (http/https) is derived from the WordPress URL
        protocol: wpUrl.protocol.replace(":", "") || "https",
        hostname: wpUrl.hostname,
        port: wpUrl.port || undefined, // Allow undefined for default ports
        pathname: uploadsPath || "/**", // Glob pattern for image paths in WordPress uploads
      },
    ],
  },
};
