// middleware.ts
import { NextResponse } from "next/server";
import type { NextRequest } from "next/server";

export function middleware(request: NextRequest) {
    const { pathname } = request.nextUrl;

    try {
        console.log("Incoming Path:", pathname);  // Log the incoming path

        // If the URL starts with /ar, remove the prefix and add lang=ar
        if (pathname.startsWith("/ar")) {
            console.log("Rewriting path to /ar", pathname);  // Log the path being rewritten
            const newUrl = request.nextUrl.clone();
            newUrl.pathname = pathname.replace(/^\/ar/, "") || "/";
            newUrl.searchParams.set("lang", "ar");
            return NextResponse.rewrite(newUrl);
        }

        // If the URL starts with /en, remove the prefix and add lang=en
        if (pathname.startsWith("/en")) {
            console.log("Rewriting path to /en", pathname);  // Log the path being rewritten
            const newUrl = request.nextUrl.clone();
            newUrl.pathname = pathname.replace(/^\/en/, "") || "/";
            newUrl.searchParams.set("lang", "en");
            return NextResponse.rewrite(newUrl);
        }

        return NextResponse.next();
    } catch (error) {
        console.error("Error in middleware:", error);  // Log any errors that occur
        return NextResponse.error();  // Return a 500 error response if there's an issue
    }
}
