'use client';

import { useState, useRef, useEffect } from 'react';
import { useLanguage } from '@/contexts/LanguageContext';

export default function SearchButton() {
  const [open, setOpen] = useState(false);
  const [query, setQuery] = useState('');
  const [results, setResults] = useState<any[]>([]);
  const { language } = useLanguage();
  const inputRef = useRef<HTMLInputElement | null>(null);

  // ✅ ركّز تلقائي على input أول ما تفتح السيرش
  useEffect(() => {
    if (open && inputRef.current) {
      inputRef.current.focus();
    }
  }, [open]);

  // ✅ دالة تصليح الروابط
  const formatSearchUrl = (item: any) => {
    let slug = item.url.replace(process.env.NEXT_PUBLIC_WORDPRESS_URL!, '');
    slug = slug.replace(/^\/(ar|en)(\/|$)/, '/'); // شيل prefix اللغة
    if (item.subtype === 'post') return `/posts${slug}`;
    if (item.subtype === 'page') return slug;
    if (item.subtype === 'project') return `/project${slug}`;
    return slug;
  };

  return (
    <div className="relative">
      <button
        onClick={() => setOpen(!open)}
        className="w-10 h-10 flex items-center justify-center text-gray-900 dark:text-white
    rounded-md 
    border border-gray-300 dark:border-gray-600 
    transition-transform duration-300 
    focus:outline-none focus:ring-0"
        aria-label="Search"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="20"
          height="20"
          viewBox="0 0 24 24"
          fill="none"
          stroke="currentColor"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
          className="lucide lucide-search-icon w-5 h-5"
        >
          <path d="m21 21-4.34-4.34" />
          <circle cx="11" cy="11" r="8" />
        </svg>
      </button>

      {open && (
        <div className="absolute end-0 mt-2 w-72 bg-white dark:bg-gray-900 shadow-lg dark:shadow-gray-800 rounded-lg p-3 z-50">
          <div className="relative">
            <input
              id="search-input"
              name="search"
              ref={inputRef}
              type="text"
              autoComplete="search"
              placeholder={language === 'ar' ? 'ابحث...' : 'Search...'}
              value={query}
              onChange={(e) => setQuery(e.target.value)}
              onKeyDown={async (e) => {
                if (e.key === 'Enter') {
                  e.preventDefault();
                  if (query.length > 2) {
                    window.location.href = `/search?query=${encodeURIComponent(query)}`;
                  }
                }
              }}
              className="w-full border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 rounded-md px-3 py-2 pr-8 focus:outline-none focus:ring-2 focus:ring-primary-500"
            />

            {/* زر الإغلاق مربوط بالـ input فقط */}
            <button
              onClick={() => setOpen(false)}
              className="absolute top-1/2 end-2 -translate-y-1/2 text-gray-500 hover:text-red-500 dark:text-gray-400 dark:hover:text-red-400"
              aria-label="Close search"
            >
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="18"
                height="18"
                viewBox="0 0 24 24"
                fill="none"
                stroke="currentColor"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
                className="w-4 h-4"
              >
                <path d="M18 6 6 18" />
                <path d="M6 6 18 18" />
              </svg>
            </button>
          </div>
        </div>
      )}
    </div>
  );
}
