'use client';

import { useLanguage } from '@/contexts/LanguageContext';
import { useRouter, usePathname } from 'next/navigation';
import { useState, useEffect } from 'react';

export default function LanguageSwitcher() {
    const { language, setLanguage, defaultLang } = useLanguage();
    const router = useRouter();
    const pathname = usePathname();

    // ✅ حالة تحميل (ممكن تسيبها false لو الـ context جاهز على طول)
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        // simulate hydration/ready
        setLoading(false);
    }, []);

    const switchLang = () => {
        const newLang = language === 'en' ? 'ar' : 'en';
        setLanguage(newLang);

        let newPath = pathname;

        // إزالة أي prefix سابق
        if (newPath.startsWith('/ar')) newPath = newPath.replace(/^\/ar/, '');
        if (newPath.startsWith('/en')) newPath = newPath.replace(/^\/en/, '');

        // إضافة prefix فقط لو اللغة الجديدة مش هي الديفولت
        if (newLang !== defaultLang) {
            newPath = `/${newLang}${newPath}`;
        }

        router.push(newPath || '/');
    };

    return (
        <div className="relative">
            {loading ? (
                // ✅ skeleton بنفس حجم الزرار
                <div className="h-5 w-16 bg-gray-200 dark:bg-gray-700 rounded animate-pulse" />
            ) : (
                <button
                    onClick={switchLang}
                    className="text-sm text-gray-700 dark:text-gray-200 hover:text-primary-600 dark:hover:text-primary-400 font-semibold transition-colors"
                >
                    {language === 'en' ? 'العربية' : 'English'}
                </button>
            )}
        </div>
    );
}
