'use client';

import { useLanguage } from '@/contexts/LanguageContext';

export default function HtmlWrapper({ children }: { children: React.ReactNode }) {
    const { language, isRTL } = useLanguage();

    return (
        <body
            lang={language}
            dir={isRTL ? 'rtl' : 'ltr'}
            className={`bg-gray-50 dark:bg-gray-900 min-h-screen flex flex-col ${isRTL ? 'font-rtl' : 'font-ltr'}`}
        >
            {children}
        </body>
    );
}
