'use client';

import { useState } from 'react';
import LanguageSwitcher from '@/components/header/LanguageSwitcher';
import Logo from '@/components/header/Logo';
import SearchButton from '@/components/header/SearchButton';
import DarkModeToggle from '@/components/ui/DarkModeToggle';
import Menu from '@/components/header/Menu';

export default function Header() {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <header className="site-header relative bg-white dark:bg-gray-800 shadow-sm dark:shadow-gray-800">
      <nav className="container py-3">
        <div className="flex justify-between items-center">

          {/* ✅ Logo */}
          <Logo />

          {/* ✅ Desktop Menu */}
          <div className="flex gap-6">
            <Menu />
            <div className="hidden md:flex">
              <LanguageSwitcher />
            </div>
          </div>

          <div className="flex gap-1">
            <SearchButton />
            <DarkModeToggle />
            {/* ✅ Mobile Menu Button */}
            <button
              onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              className="md:hidden w-10 h-10 flex items-center justify-center text-gray-900 dark:text-white
    rounded-md 
    border border-gray-300 dark:border-gray-600 
    transition-transform duration-300 
    focus:outline-none focus:ring-0"
              aria-label="Toggle menu"
            >
              <svg
                className="w-5 h-5"
                width="20"
                height="20"
                fill="none"
                stroke="currentColor"
                viewBox="0 0 24 24"
              >
                {mobileMenuOpen ? (
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M6 18L18 6M6 6l12 12"
                  />
                ) : (
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M4 6h16M4 12h16M4 18h16"
                  />
                )}
              </svg>
            </button>
          </div>

        </div>

        {/* Mobile Menu */}
        {mobileMenuOpen && (
          <div
            className="absolute top-full left-0 w-full bg-white/90 dark:bg-gray-900/90 backdrop-blur-sm shadow-md z-50 md:hidden"
          >
            {/* ✅ مرر دالة إغلاق */}
            <div className="container py-4">
              <Menu mobile onLinkClick={() => setMobileMenuOpen(false)} />
              <div className="pt-2 mt-2 border-t border-gray-200 dark:border-gray-700">
                <LanguageSwitcher />
              </div>
            </div>
          </div>
        )}

      </nav>
    </header>
  );
}
