<?php
$breadcrumb_title = $breadcrumb_title ?? '';
$breadcrumb_desc  = $breadcrumb_desc ?? '';
$breadcrumb_current  = $breadcrumb_current ?? '';
$breadcrumb_bg    = $breadcrumb_bg ?? 'from-gray-100 to-white';
$breadcrumb_img    = $breadcrumb_img ?? 'default-bg.svg';
$breadcrumb_pb    = $breadcrumb_pb ?? 'pb-12';
?>

<div class="relative bg-gradient-to-b <?php echo htmlspecialchars($breadcrumb_bg, ENT_QUOTES, 'UTF-8'); ?>
 overflow-hidden">

    <!-- SVG Image Background -->
    <img
        src="images/<?php echo htmlspecialchars($breadcrumb_img, ENT_QUOTES, 'UTF-8'); ?>"
        alt=""
        class="absolute bottom-0 left-1/2 -translate-x-1/2 w-full max-w-none pointer-events-none select-none">

    <div class="container pt-32 <?php echo htmlspecialchars($breadcrumb_pb, ENT_QUOTES, 'UTF-8'); ?>">

        <div class="text-center max-w-[600px] mx-auto">

            <?php if ($breadcrumb_title): ?>
                <h1 class="text-2xl lg:text-3xl font-bold text-gray-800 !leading-snug tracking-tight mb-4">
                    <?php echo htmlspecialchars($breadcrumb_title, ENT_QUOTES, 'UTF-8'); ?>
                </h1>
            <?php endif; ?>

            <?php if ($breadcrumb_desc): ?>
                <p class="text-gray-600 leading-relaxed mb-6">
                    <?php echo htmlspecialchars($breadcrumb_desc); ?>
                </p>
            <?php endif; ?>

            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="flex justify-center">
                <ol class="flex items-center gap-2 text-sm text-gray-600">

                    <li>
                        <a href="index.php"
                            class="hover:text-primary-500 transition-colors">
                            الرئيسية
                        </a>
                    </li>

                    <li aria-hidden="true" class="flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="5" height="9" viewBox="0 0 5 9" fill="none">
                            <path d="M4.5 8.5L0.5 4.5L4.5 0.5"
                                stroke="#9CA3AF"
                                stroke-linecap="round"
                                stroke-linejoin="round" />
                        </svg>
                    </li>

                    <li aria-current="page" class="text-gray-800 font-semibold">
                        <?php echo htmlspecialchars($breadcrumb_current); ?>
                    </li>

                </ol>
            </nav>

        </div>
    </div>
</div>