<div class="fund-card block rounded-xl border border-gray-100 overflow-hidden bg-gradient-to-br from-[#f9fbfb] to-[#ffffff] hover:shadow-lg transition-shadow" data-name="<?php echo htmlspecialchars($fund['name_ar'] ?? ''); ?>" data-fund-type="<?php echo htmlspecialchars($fund['type'] ?? ''); ?>" data-risk="<?php echo htmlspecialchars($fund['risk'] ?? ''); ?>" data-badge="<?php echo htmlspecialchars($fund['badge'] ?? ''); ?>">
    <a href="fund-details.php?id=<?php echo $fund['id']; ?>" class="block">

        <!-- Card Header -->
        <div class="h-[170px] relative flex items-center justify-center site-card">

            <!-- Favorite Icon -->
            <button class="absolute top-3 end-3 text-gray-500 hover:text-red-500 transition-colors" aria-label="Favorite">
                <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" width="18" height="16" viewBox="0 0 18 16" fill="none">
                    <path d="M0.800049 5.33854C0.800065 4.42297 1.07012 3.52894 1.57455 2.77453C2.07898 2.02012 2.79406 1.44083 3.62533 1.11315C4.4566 0.785481 5.36496 0.724846 6.23044 0.939258C7.09592 1.15367 7.87781 1.63304 8.47282 2.31406C8.51473 2.36014 8.5654 2.39689 8.62169 2.42201C8.67797 2.44712 8.73867 2.46009 8.80002 2.46009C8.86138 2.46009 8.92208 2.44712 8.97836 2.42201C9.03465 2.39689 9.08531 2.36014 9.12722 2.31406C9.72037 1.62862 10.5024 1.14522 11.3693 0.928198C12.2362 0.711181 13.1468 0.770841 13.9799 1.09924C14.813 1.42763 15.5291 2.00919 16.0329 2.7665C16.5367 3.52381 16.8042 4.42096 16.8 5.33854C16.8 7.22266 15.6 8.62959 14.4 9.86373L10.0064 14.2351C9.85736 14.4111 9.67356 14.5526 9.46726 14.65C9.26095 14.7474 9.03686 14.7985 8.80986 14.8C8.58285 14.8015 8.35814 14.7533 8.15066 14.6586C7.94317 14.5639 7.75765 14.4248 7.60643 14.2507L3.20004 9.86373C2.00005 8.62959 0.800049 7.23089 0.800049 5.33854Z" stroke="#6B7280" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </button>

            <!-- Badge -->
            <div class="absolute top-3 start-3">
                <?php if (!empty($fund['badge'])): ?>
                    <?php if ($fund['badge'] === 'متاح'): ?>
                        <span class="bg-secondary-500 text-white text-xs px-2 py-1 rounded-full">متاح</span>
                    <?php elseif ($fund['badge'] === 'مكتمل'): ?>
                        <span class="bg-red-500 text-white text-xs px-2 py-1 rounded-full">مكتمل</span>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <!-- Fund Logo -->
            <?php if (!empty($fund['logo']) && file_exists($fund['logo'])): ?>
                <img src="<?php echo $fund['logo']; ?>" alt="<?php echo $fund['name_ar']; ?>" class="w-[140px] h-[70px] object-contain mix-blend-darken">
            <?php else: ?>
                <img src="images/companies/default.webp" alt="default" class="w-[80px] h-[40px] object-contain mix-blend-darken">
            <?php endif; ?>

        </div>

        <!-- Card Body -->
        <div class="p-4">
            <!-- Fund Name -->
            <div class="text-center mb-4">
                <h3 class="text-base font-semibold text-gray-800 mb-2 truncate"><?php echo htmlspecialchars($fund['name_ar'] ?? ''); ?></h3>
                <p class="text-base text-gray-600"><?php echo htmlspecialchars($fund['name_en'] ?? ''); ?></p>
            </div>

            <!-- Stats Grid -->
            <div class="flex items-center justify-between text-center py-4 my-4 border-y border-gray-100">
                <div>
                    <p class="text-sm font-bold text-secondary-600">
                        <?php echo htmlspecialchars($fund['return_rate'] ?? '0%'); ?>
                    </p>
                    <p class="text-xs text-gray-500">العائد السنوي</p>
                </div>
                <div>
                    <p class="text-sm font-bold text-gray-800"><?php echo htmlspecialchars($fund['price'] ?? '0'); ?></p>
                    <p class="text-xs text-gray-500">سعر الوحدة</p>
                </div>
                <div>
                    <p class="text-sm font-bold text-gray-800"><?php echo htmlspecialchars($fund['fees'] ?? '0%'); ?></p>
                    <p class="text-xs text-gray-500">رسوم الإدارة</p>
                </div>
            </div>

            <!-- Bottom: Fund Type & Risk -->
            <div class="flex items-center justify-between">

                <!-- Risk Level -->
                <?php if (!empty($fund['risk'])): ?>
                    <div class="flex items-center gap-2">
                        <div class="flex gap-0.5">
                            <?php
                            $riskLevel = $fund['risk_level'] ?? 2;
                            for ($i = 0; $i < 3; $i++):
                            ?>
                                <div class="w-1 h-3.5 rounded-sm <?php echo $i < $riskLevel ? 'bg-orange-500' : 'bg-gray-200'; ?>"></div>
                            <?php endfor; ?>
                        </div>
                        <span class="text-xs text-gray-600"><?php echo htmlspecialchars($fund['risk']); ?></span>
                    </div>
                <?php endif; ?>

                <!-- Fund Type Badge -->
                <?php if (!empty($fund['type'])):
                    $typeColors = [
                        'صناديق أوحدة' => 'bg-secondary-100 text-secondary-700',
                        'صناديق متنوعة' => 'bg-purple-100 text-purple-700',
                        'صناديق مغلقة' => 'bg-blue-100 text-blue-700',
                        'صناديق متوازنة' => 'bg-amber-100 text-amber-700',
                        'صناديق مفتوحة' => 'bg-green-100 text-green-700',
                        'صناديق اكتتاب' => 'bg-orange-100 text-orange-700',
                        'صناديق عالية' => 'bg-red-100 text-red-700',
                    ];
                    $colorClass = $typeColors[$fund['type']] ?? 'bg-gray-100 text-gray-700';
                ?>
                    <span class="<?php echo $colorClass; ?> text-xs px-3 py-1.5 rounded-full font-medium">
                        <?php echo htmlspecialchars($fund['type']); ?>
                    </span>
                <?php endif; ?>

            </div>
        </div>

    </a>
</div>