<div class="company-card block rounded-xl border border-gray-100 overflow-hidden bg-gradient-to-br from-[#f9fbfb] to-[#ffffff] hover:shadow-lg transition-shadow" data-name="<?php echo htmlspecialchars($company['name']); ?>">
    <a href="company-details.php?id=<?php echo $company['id']; ?>" class="block">
    <!-- Card Header -->
    <div class="h-[170px] relative flex items-center justify-center site-card">
        <!-- Favorite Icon -->
        <button class="absolute top-3 end-3 text-gray-500 hover:text-red-500 transition-colors" aria-label="Favorite">
            <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" width="18" height="16" viewBox="0 0 18 16" fill="none">
                <path d="M0.800049 5.33854C0.800065 4.42297 1.07012 3.52894 1.57455 2.77453C2.07898 2.02012 2.79406 1.44083 3.62533 1.11315C4.4566 0.785481 5.36496 0.724846 6.23044 0.939258C7.09592 1.15367 7.87781 1.63304 8.47282 2.31406C8.51473 2.36014 8.5654 2.39689 8.62169 2.42201C8.67797 2.44712 8.73867 2.46009 8.80002 2.46009C8.86138 2.46009 8.92208 2.44712 8.97836 2.42201C9.03465 2.39689 9.08531 2.36014 9.12722 2.31406C9.72037 1.62862 10.5024 1.14522 11.3693 0.928198C12.2362 0.711181 13.1468 0.770841 13.9799 1.09924C14.813 1.42763 15.5291 2.00919 16.0329 2.7665C16.5367 3.52381 16.8042 4.42096 16.8 5.33854C16.8 7.22266 15.6 8.62959 14.4 9.86373L10.0064 14.2351C9.85736 14.4111 9.67356 14.5526 9.46726 14.65C9.26095 14.7474 9.03686 14.7985 8.80986 14.8C8.58285 14.8015 8.35814 14.7533 8.15066 14.6586C7.94317 14.5639 7.75765 14.4248 7.60643 14.2507L3.20004 9.86373C2.00005 8.62959 0.800049 7.23089 0.800049 5.33854Z" stroke="#6B7280" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
        </button>

        <!-- Verified Badge -->
        <?php if ($company['verified']): ?>
            <div class="absolute top-3 start-3">
                <span class="bg-secondary-500 text-white text-xs px-2 py-1 rounded-full flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 9 9" fill="none">
                        <path d="M4.5 8.5C6.70914 8.5 8.5 6.70914 8.5 4.5C8.5 2.29086 6.70914 0.5 4.5 0.5C2.29086 0.5 0.5 2.29086 0.5 4.5C0.5 6.70914 2.29086 8.5 4.5 8.5Z" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M3.29993 4.50007L4.09993 5.30007L5.69993 3.70007" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <span>موثق</span>
                </span>
            </div>
        <?php endif; ?>

        <!-- Company Logo -->
        <?php if (!empty($company['image']) && file_exists($company['image'])): ?>
            <img src="<?php echo $company['image']; ?>" alt="<?php echo $company['name']; ?>" class="w-[140px] h-[70px] object-contain mix-blend-darken">
        <?php else: ?>
            <img src="images/companies/default.webp" alt="default" class="w-[80px] h-[40px] object-contain mix-blend-darken">
        <?php endif; ?>
    </div>

    <!-- Card Body -->
    <div class="p-4">
        <!-- Company Info -->
        <div class="text-start mb-4">
            <h3 class="text-base font-semibold text-gray-800 mb-2 truncate"><?php echo $company['name']; ?></h3>
            <p class="text-base text-gray-600"><?php echo $company['sector']; ?></p>
        </div>

        <!-- Price Box -->
        <div class="bg-gray-100 rounded-lg p-3 mb-4">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600">سعر السهم</span>
                <div class="flex items-center gap-1">
                    <span class="text-xl font-bold text-gray-800 leading-none"><?php echo $company['price']; ?></span>
                    <span class="icon-riyal-symbol text-gray-800" aria-hidden="true"></span>
                </div>
            </div>
        </div>

        <!-- Change -->
        <div class="flex items-center justify-between mb-4">
            <span class="text-sm text-gray-600">التغير</span>
            <div class="flex items-center gap-1">
                <span class="text-sm <?php echo $company['changeType'] === 'up' ? 'text-green-600' : 'text-red-600'; ?>"><?php echo $company['change']; ?></span>
                <svg class="w-4 h-4 <?php echo $company['changeType'] === 'up' ? 'text-green-600' : 'text-red-600 rotate-180'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
                </svg>
            </div>
        </div>

        <!-- Footer -->
        <div class="border-t border-gray-100 pt-4 flex items-center justify-center">
            <span class="bg-secondary-50 text-secondary-700 text-xs px-3 py-1 rounded-full"><?php echo $company['ads']; ?></span>
        </div>
    </div>
    </a>
</div>