/** @type {import('tailwindcss').Config} */
const typography = require('@tailwindcss/typography');

module.exports = {
    content: [
        "./**/*.{php,html,js,jsx,ts,tsx,vue}",

        // Exclusions — keep these out of the scan
        "!./**/node_modules/**",
        "!./**/vendor/**",
        "!./**/.git/**",
        "!./**/.cache/**",
        "!./**/cache/**",
        "!./**/storage/**",
    ],
    safelist: [
        // Fund type badge colors
        'bg-secondary-100', 'text-secondary-700',
        'bg-purple-100', 'text-purple-700',
        'bg-blue-100', 'text-blue-700',
        'bg-amber-100', 'text-amber-700',
        'bg-green-100', 'text-green-700',
        'bg-orange-100', 'text-orange-700',
        'bg-red-100', 'text-red-700',
        'bg-gray-100', 'text-gray-700',
        // Risk level colors
        'bg-orange-500', 'bg-secondary-500', 'bg-gray-200',
    ],
    theme: {
        extend: {
            colors: {
                // Primary Colors (Blue)
                primary: {
                    50: '#eef6ff',
                    100: '#d6e8ff',
                    200: '#b5d6ff',
                    300: '#83bcff',
                    400: '#4899ff',
                    500: '#0071e3',
                    600: '#005bc0',
                    700: '#004599',
                    800: '#003977',
                    900: '#002d5e',
                },
                // Secondary Colors (Green)
                secondary: {
                    50: '#ecfdf5',
                    100: '#d1fae5',
                    200: '#a7f3d0',
                    300: '#6ee7b7',
                    400: '#34d399',
                    500: '#2bb67a',
                    600: '#239463',
                    700: '#1b704c',
                    800: '#166534',
                    900: '#14532d',
                },
                // Gray Colors
                gray: {
                    50: '#f9fbfb',
                    100: '#f3f4f6',
                    200: '#e5e7eb',
                    300: '#d1d5db',
                    400: '#9ca3af',
                    500: '#6b7280',
                    600: '#4b5563',
                    700: '#374151',
                    800: '#1f2937',
                    900: '#111827',
                },
            },
            fontFamily: {
                'rtl': ['somarsans', 'sans-serif'],
            },
            container: {
                center: true,
                padding: {
                    DEFAULT: '1rem',
                    sm: '1rem',
                    lg: '1rem',
                    xl: '1rem',
                    '2xl': '1rem',
                },
                screens: {
                    lg: '100%',
                    xl: '1280px',
                },
            },
            backgroundImage: {
                'hero-gradient': 'linear-gradient(to bottom, #ffffff, #d6e8ff)',
                'card-gradient': 'linear-gradient(-50deg, #f9fbfb 2.47%, #ffffff 96.92%)',
                'primary-gradient': 'linear-gradient(-90deg, #0071e3 0%, #005bc0 100%)',
                'secondary-gradient': 'linear-gradient(-90deg, #2bb67a 0%, #239463 100%)',
                'footer-gradient': 'linear-gradient(to left, #273344, #111827)',
            },
            boxShadow: {
                'card': '0px -11px 20px 0px rgba(61, 143, 255, 0.07)',
            },
            borderRadius: {
                'xl': '16px',
                '2xl': '20px',
                '3xl': '24px',
            },
        },
    },
    plugins: [
        typography,
        require('@tailwindcss/forms')({
            strategy: 'base',
        }),
    ],
}