<?php
include 'header.php';
include 'includes/data.php';
?>

<!-- Hero Section -->
<section class="relative bg-gradient-to-b from-primary-100 to-white overflow-hidden">

    <!-- SVG Image Background -->
    <img
        src="images/bg-overlay.svg"
        alt=""
        class="absolute bottom-0 left-1/2 -translate-x-1/2 w-full max-w-none pointer-events-none select-none">

    <div class="relative px-4 pt-32">
        <!-- Hero Content -->
        <div class="text-center max-w-[600px] mx-auto mb-12">
            <h1 class="text-4xl lg:text-5xl font-bold text-gray-700 !leading-snug tracking-tight mb-6">
                سوقك <span class="text-primary-600">الآمن</span> لتداول حصص الشركات غير المدرجة
            </h1>
            <p class="text-lg text-gray-600 leading-relaxed mb-8">
                منصة سعودية لشراء وبيع حصص الشركات غير المدرجة وصناديق الاستثمار بشفافية وإجراءات موثوقة.
            </p>
            <div class="flex items-center justify-center gap-2">
                <a href="#" class="bg-gradient-to-l from-primary-500 to-primary-600 text-white px-6 py-3 rounded-lg text-sm font-semibold border border-primary-600 hover:opacity-90 transition-opacity flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="12" viewBox="0 0 14 12" fill="none">
                        <path d="M2.08108 2.85714C2.08108 1.27857 3.35101 0 4.91892 0C6.48682 0 7.75676 1.27857 7.75676 2.85714C7.75676 4.43571 6.48682 5.71429 4.91892 5.71429C3.35101 5.71429 2.08108 4.43571 2.08108 2.85714ZM0 11.2929C0 8.94762 1.88716 7.04762 4.21655 7.04762H5.62128C7.95068 7.04762 9.83784 8.94762 9.83784 11.2929C9.83784 11.6833 9.52331 12 9.13547 12H0.702365C0.314527 12 0 11.6833 0 11.2929ZM11.7297 2.09524C12.0443 2.09524 12.2973 2.35 12.2973 2.66667V3.80952H13.4324C13.747 3.80952 14 4.06429 14 4.38095C14 4.69762 13.747 4.95238 13.4324 4.95238H12.2973V6.09524C12.2973 6.4119 12.0443 6.66667 11.7297 6.66667C11.4152 6.66667 11.1622 6.4119 11.1622 6.09524V4.95238H10.027C9.7125 4.95238 9.45946 4.69762 9.45946 4.38095C9.45946 4.06429 9.7125 3.80952 10.027 3.80952H11.1622V2.66667C11.1622 2.35 11.4152 2.09524 11.7297 2.09524Z" fill="white" />
                    </svg>
                    <span>ابدأ الآن</span>
                </a>
                <a href="#" class="text-gray-700 px-6 py-3 rounded-lg text-sm font-semibold border border-gray-700 hover:bg-gray-100 transition-colors flex items-center gap-2">
                    <span>تصفح الإعلانات</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                        <path d="M12.7998 12.8L9.90643 9.90666" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M6.13329 11.4667C9.0788 11.4667 11.4666 9.07885 11.4666 6.13334C11.4666 3.18782 9.0788 0.800003 6.13329 0.800003C3.18779 0.800003 0.799988 3.18782 0.799988 6.13334C0.799988 9.07885 3.18779 11.4667 6.13329 11.4667Z" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </a>
            </div>
        </div>

        <!-- Dashboard Preview -->
        <div class="relative max-w-[1047px] mx-auto">
            <div class="relative">
                <!-- Main Dashboard Card -->
                <div class="bg-white rounded-t-2xl shadow-card overflow-hidden mx-auto max-w-[846px]">
                    <img src="images/dashboard-preview.webp" alt="Dashboard Preview" class="w-full h-auto">
                </div>

                <!-- Floating Cards -->
                <div class="absolute -top-10 -left-[0px] bg-white/95 rounded-3xl shadow-card p-3 hidden lg:block">
                    <img src="images/hero-left.webp" alt="Company Logo" class="w-[140px] h-[108px] object-contain mix-blend-multiply">
                </div>

                <div class="absolute bottom-10 -right-2 bg-white/95 rounded-3xl shadow-card p-3 hidden lg:block">
                    <img src="images/hero-right-bottom.webp" alt="Company Logo" class="w-[140px] h-[108px] object-contain mix-blend-multiply">
                </div>

                <div class="absolute bottom-0 -left-10 bg-white/95 rounded-t-2xl shadow-card p-3 hidden lg:block">
                    <img src="images/hero-left-bottom.webp" alt="Chart" class="w-[220px] h-[197px] object-contain mix-blend-multiply">
                </div>

            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="mt-16">
    <div class="container">
        <div class="bg-gradient-to-l from-gray-50 via-white to-gray-50 rounded-2xl py-10">
            <div class="grid grid-cols-2 lg:grid-cols-4 gap-8 lg:gap-0 lg:divide-x lg:divide-x-reverse divide-gray-200">
                <!-- Stat 1 -->
                <div class="flex items-center justify-start lg:justify-center gap-4 lg:px-8">
                    <div class="w-[60px] h-[60px] bg-primary-100 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-primary-700" xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                            <path d="M22.0992 0.136305C22.6502 0.383121 23 0.934826 23 1.54461V21.677C23 22.2868 22.6502 22.8385 22.0992 23.0853C21.5481 23.3321 20.9108 23.2402 20.4556 22.8385L18.2227 20.8688C16.1335 19.025 13.4933 17.9506 10.7285 17.8199V22.4514C10.7285 23.3079 10.0433 24 9.19521 24H7.66187C6.81375 24 6.12854 23.3079 6.12854 22.4514V17.8054C2.74562 17.8054 0 15.0324 0 11.6108C0 8.18927 2.74563 5.41623 6.13333 5.41623H10.1823C13.1435 5.40655 15.9994 4.31765 18.2275 2.35281L20.4604 0.383121C20.9108 -0.01856 21.5577 -0.110511 22.104 0.136305H22.0992ZM10.7333 14.7081V14.7178C14.1019 14.8485 17.3363 16.0971 19.9333 18.27V4.94679C17.3363 7.11974 14.1019 8.36834 10.7333 8.499V14.7081Z" fill="#004599" />
                        </svg>
                    </div>
                    <div class="text-start">
                        <p class="text-xl lg:text-2xl font-semibold text-primary-700 tracking-tight">1,250</p>
                        <p class="text-base lg:text-lg font-medium text-gray-800">إعلان منشور</p>
                    </div>
                </div>

                <!-- Stat 2 -->
                <div class="flex items-center justify-start lg:justify-center gap-4 lg:px-8">
                    <div class="w-[60px] h-[60px] bg-green-100 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-[#009900]" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path d="M12 24C5.37188 24 0 18.6281 0 12C0 5.37188 5.37188 0 12 0C18.6281 0 24 5.37188 24 12C24 18.6281 18.6281 24 12 24ZM17.5312 6.82969C17.0297 6.46406 16.3266 6.57656 15.9609 7.07812L10.3641 14.775L7.92188 12.3328C7.48125 11.8922 6.76875 11.8922 6.33281 12.3328C5.89688 12.7734 5.89219 13.4859 6.33281 13.9219L9.70781 17.2969C9.94219 17.5312 10.2609 17.6484 10.5891 17.625C10.9172 17.6016 11.2172 17.4328 11.4094 17.1656L17.7797 8.4C18.1453 7.89844 18.0328 7.19531 17.5312 6.82969Z" fill="#009900" />
                        </svg>
                    </div>
                    <div class="text-start">
                        <p class="text-xl lg:text-2xl font-semibold text-[#009900] tracking-tight">856</p>
                        <p class="text-base lg:text-lg font-medium text-gray-800">صفقة مكتملة</p>
                    </div>
                </div>

                <!-- Stat 3 -->
                <div class="flex items-center justify-start lg:justify-center gap-4 lg:px-8">
                    <div class="w-[60px] h-[60px] bg-cyan-100 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-[#008599]" xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                            <path d="M14.95 5.25H8.05L6.26271 1.75781C6.17646 1.58906 6.13333 1.40156 6.13333 1.21406C6.13333 0.54375 6.68917 0 7.37437 0H15.6256C16.3108 0 16.8667 0.54375 16.8667 1.21406C16.8667 1.40156 16.8235 1.58906 16.7373 1.75781L14.95 5.25ZM7.36 7.5H15.64L17.9735 9.40313C21.16 12 23 15.8438 23 19.8984C23 22.1625 21.1217 24 18.8073 24H4.18792C1.87833 24 0 22.1625 0 19.8984C0 15.8438 1.84 12 5.02646 9.40313L7.36 7.5ZM11.6917 10.5C11.1646 10.5 10.7333 10.9219 10.7333 11.4375V11.625C9.35333 11.6391 8.24167 12.7359 8.24167 14.0859C8.24167 15.2906 9.12812 16.3172 10.3452 16.5141L12.3433 16.8422C12.6308 16.8891 12.8417 17.1328 12.8417 17.4188C12.8417 17.7422 12.5733 18.0047 12.2427 18.0047L9.58333 18C9.05625 18 8.625 18.4219 8.625 18.9375C8.625 19.4531 9.05625 19.875 9.58333 19.875H10.7333V20.0625C10.7333 20.5781 11.1646 21 11.6917 21C12.2188 21 12.65 20.5781 12.65 20.0625V19.8422C13.8479 19.65 14.7583 18.6375 14.7583 17.4141C14.7583 16.2094 13.8719 15.1828 12.6548 14.9859L10.6567 14.6578C10.3692 14.6109 10.1583 14.3672 10.1583 14.0812C10.1583 13.7578 10.4267 13.4953 10.7573 13.4953H13.0333C13.5604 13.4953 13.9917 13.0734 13.9917 12.5578C13.9917 12.0422 13.5604 11.6203 13.0333 11.6203H12.65V11.4328C12.65 10.9172 12.2188 10.4953 11.6917 10.4953V10.5Z" fill="#008599" />
                        </svg>
                    </div>
                    <div class="text-start">
                        <p class="text-xl lg:text-2xl font-semibold text-[#008599] tracking-tight">3,420</p>
                        <p class="text-base lg:text-lg font-medium text-gray-800">مستثمر مسجل</p>
                    </div>
                </div>

                <!-- Stat 4 -->
                <div class="flex items-center justify-start lg:justify-center gap-4 lg:px-8">
                    <div class="w-[60px] h-[60px] bg-orange-100 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5 text-[#994700]" xmlns="http://www.w3.org/2000/svg" width="18" height="24" viewBox="0 0 18 24" fill="none">
                            <path d="M3 0C1.34531 0 0 1.34531 0 3V21C0 22.6547 1.34531 24 3 24H15C16.6547 24 18 22.6547 18 21V3C18 1.34531 16.6547 0 15 0H3ZM8.25 16.5H9.75C10.5797 16.5 11.25 17.1703 11.25 18V21.75H6.75V18C6.75 17.1703 7.42031 16.5 8.25 16.5ZM4.5 5.25C4.5 4.8375 4.8375 4.5 5.25 4.5H6.75C7.1625 4.5 7.5 4.8375 7.5 5.25V6.75C7.5 7.1625 7.1625 7.5 6.75 7.5H5.25C4.8375 7.5 4.5 7.1625 4.5 6.75V5.25ZM11.25 4.5H12.75C13.1625 4.5 13.5 4.8375 13.5 5.25V6.75C13.5 7.1625 13.1625 7.5 12.75 7.5H11.25C10.8375 7.5 10.5 7.1625 10.5 6.75V5.25C10.5 4.8375 10.8375 4.5 11.25 4.5ZM4.5 11.25C4.5 10.8375 4.8375 10.5 5.25 10.5H6.75C7.1625 10.5 7.5 10.8375 7.5 11.25V12.75C7.5 13.1625 7.1625 13.5 6.75 13.5H5.25C4.8375 13.5 4.5 13.1625 4.5 12.75V11.25ZM11.25 10.5H12.75C13.1625 10.5 13.5 10.8375 13.5 11.25V12.75C13.5 13.1625 13.1625 13.5 12.75 13.5H11.25C10.8375 13.5 10.5 13.1625 10.5 12.75V11.25C10.5 10.8375 10.8375 10.5 11.25 10.5Z" fill="#994700" />
                        </svg>
                    </div>
                    <div class="text-start">
                        <p class="text-xl lg:text-2xl font-semibold text-[#994700] tracking-tight">125</p>
                        <p class="text-base lg:text-lg font-medium text-gray-800">شركة وصندوق</p>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="pt-8 pb-8 lg:pt-16 lg:pb-8">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-8">
            <h2 class="text-[32px] font-bold text-gray-800 tracking-tight mb-3">آلية البيع والشراء</h2>
            <p class="text-base text-gray-700">خطوات بسيطة لإتمام صفقاتك بأمان وشفافية</p>
        </div>

        <!-- Steps -->
        <div class="bg-gradient-to-l from-gray-50 via-white to-gray-50 rounded-2xl py-16 px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
                <!-- Step 1 -->
                <div class="text-center">
                    <div class="relative inline-block mb-6">
                        <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center">
                            <svg class="w-7 h-6 text-primary-500" xmlns="http://www.w3.org/2000/svg" width="28" height="24" viewBox="0 0 28 24" fill="none">
                                <path d="M4.16216 5.71429C4.16216 2.55714 6.70203 0 9.83784 0C12.9736 0 15.5135 2.55714 15.5135 5.71429C15.5135 8.87143 12.9736 11.4286 9.83784 11.4286C6.70203 11.4286 4.16216 8.87143 4.16216 5.71429ZM0 22.5857C0 17.8952 3.77432 14.0952 8.43311 14.0952H11.2426C15.9014 14.0952 19.6757 17.8952 19.6757 22.5857C19.6757 23.3667 19.0466 24 18.2709 24H1.40473C0.629054 24 0 23.3667 0 22.5857ZM23.4595 4.19048C24.0885 4.19048 24.5946 4.7 24.5946 5.33333V7.61905H26.8649C27.4939 7.61905 28 8.12857 28 8.7619C28 9.39524 27.4939 9.90476 26.8649 9.90476H24.5946V12.1905C24.5946 12.8238 24.0885 13.3333 23.4595 13.3333C22.8304 13.3333 22.3243 12.8238 22.3243 12.1905V9.90476H20.0541C19.425 9.90476 18.9189 9.39524 18.9189 8.7619C18.9189 8.12857 19.425 7.61905 20.0541 7.61905H22.3243V5.33333C22.3243 4.7 22.8304 4.19048 23.4595 4.19048Z" fill="#0071E3" />
                            </svg>
                        </div>
                        <div class="absolute -top-2 -right-2 w-8 h-8 bg-primary-500 rounded-full flex items-center justify-center text-white text-sm font-bold border-4 border-white">1</div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">إنشاء حساب</h3>
                    <p class="text-base text-gray-600 leading-relaxed">سجل حسابك كفرد أو شركة أو صندوق وأكمل عملية التوثيق</p>
                </div>

                <!-- Step 2 -->
                <div class="text-center">
                    <div class="relative inline-block mb-6">
                        <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-600" xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                                <path d="M22.0992 0.136305C22.6502 0.383121 23 0.934826 23 1.54461V21.677C23 22.2868 22.6502 22.8385 22.0992 23.0853C21.5481 23.3321 20.9108 23.2402 20.4556 22.8385L18.2227 20.8688C16.1335 19.025 13.4933 17.9506 10.7285 17.8199V22.4514C10.7285 23.3079 10.0433 24 9.19521 24H7.66187C6.81375 24 6.12854 23.3079 6.12854 22.4514V17.8054C2.74562 17.8054 0 15.0324 0 11.6108C0 8.18927 2.74563 5.41623 6.13333 5.41623H10.1823C13.1435 5.40655 15.9994 4.31765 18.2275 2.35281L20.4604 0.383121C20.9108 -0.01856 21.5577 -0.110511 22.104 0.136305H22.0992ZM10.7333 14.7081V14.7178C14.1019 14.8485 17.3363 16.0971 19.9333 18.27V4.94679C17.3363 7.11974 14.1019 8.36834 10.7333 8.499V14.7081Z" fill="#005BC0" />
                            </svg>
                        </div>
                        <div class="absolute -top-2 -right-2 w-8 h-8 bg-primary-500 rounded-full flex items-center justify-center text-white text-sm font-bold border-4 border-white">2</div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">إنشاء إعلان</h3>
                    <p class="text-base text-gray-600 leading-relaxed">أنشئ إعلان بيع أو شراء أسهم مع تحديد التفاصيل والسعر</p>
                </div>

                <!-- Step 3 -->
                <div class="text-center">
                    <div class="relative inline-block mb-6">
                        <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-500" xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none">
                                <path d="M11.671 2.34706L6.61024 8.06471C6.41059 8.28971 6.41927 8.63824 6.63194 8.85441C7.95573 10.2 10.1042 10.2 11.428 8.85441L12.8082 7.45147C12.9905 7.26618 13.2205 7.16471 13.4549 7.14706C13.75 7.12059 14.0538 7.22206 14.2795 7.45147L21.9444 15.1765L25 12.7059V0L20.1389 2.82353L19.1059 2.12206C18.4201 1.65882 17.6172 1.41176 16.7925 1.41176H13.737C13.6892 1.41176 13.6372 1.41176 13.5894 1.41618C12.8559 1.45588 12.1658 1.79118 11.671 2.34706ZM5.06076 6.64853L9.69618 1.41176H7.97743C6.87066 1.41176 5.81163 1.85735 5.03038 2.65147L0 8.47059V24L6.25 18L6.78819 18.4544C7.78646 19.3015 9.04514 19.7647 10.3429 19.7647H11.0243L10.7205 19.4559C10.3125 19.0412 10.3125 18.3706 10.7205 17.9603C11.1285 17.55 11.7882 17.5456 12.1918 17.9603L13.9714 19.7691H14.362C15.191 19.7691 16.0026 19.5794 16.7405 19.2265L15.5816 18.0441C15.1736 17.6294 15.1736 16.9588 15.5816 16.5485C15.9896 16.1382 16.6493 16.1338 17.0529 16.5485L18.4418 17.9603L19.2014 17.1882C19.5877 16.7956 19.7005 16.2265 19.5312 15.7279L13.546 9.69265L12.8993 10.35C10.7595 12.525 7.29601 12.525 5.15625 10.35C4.15799 9.33529 4.11892 7.70735 5.06076 6.64412V6.64853Z" fill="#0071E3" />
                            </svg>
                        </div>
                        <div class="absolute -top-2 -right-2 w-8 h-8 bg-primary-500 rounded-full flex items-center justify-center text-white text-sm font-bold border-4 border-white">3</div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">تلقي العروض</h3>
                    <p class="text-base text-gray-600 leading-relaxed">استقبل العروض من المستثمرين وتفاوض على أفضل سعر</p>
                </div>

                <!-- Step 4 -->
                <div class="text-center">
                    <div class="relative inline-block mb-6">
                        <div class="w-20 h-20 bg-secondary-500 rounded-full flex items-center justify-center">
                            <svg class="w-6 h-6 text-white" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path d="M12 24C5.37188 24 0 18.6281 0 12C0 5.37188 5.37188 0 12 0C18.6281 0 24 5.37188 24 12C24 18.6281 18.6281 24 12 24ZM17.5312 6.82969C17.0297 6.46406 16.3266 6.57656 15.9609 7.07812L10.3641 14.775L7.92188 12.3328C7.48125 11.8922 6.76875 11.8922 6.33281 12.3328C5.89688 12.7734 5.89219 13.4859 6.33281 13.9219L9.70781 17.2969C9.94219 17.5312 10.2609 17.6484 10.5891 17.625C10.9172 17.6016 11.2172 17.4328 11.4094 17.1656L17.7797 8.4C18.1453 7.89844 18.0328 7.19531 17.5312 6.82969Z" fill="white" />
                            </svg>
                        </div>
                        <div class="absolute -top-2 -right-2 w-8 h-8 bg-secondary-500 rounded-full flex items-center justify-center text-white text-sm font-bold border-4 border-white">4</div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2">إتمام الصفقة</h3>
                    <p class="text-base text-gray-600 leading-relaxed">أكمل الصفقة بأمان عبر المنصة مع توثيق العقد رسمياً</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Latest Ads Section -->
<section class="py-8 lg:py-10">
    <div class="container">
        <!-- Section Header -->
        <div class="flex items-center justify-between mb-8 gap-4">
            <div class="text-start">
                <h2 class="text-2xl lg:text-3xl font-bold text-gray-800 tracking-tight mb-2">أحدث الإعلانات</h2>
                <p class="text-base text-gray-700">تصفح أحدث إعلانات البيع والشراء من مستثمرين موثوقين</p>
            </div>
            <a href="#" class="text-gray-700 px-2 py-2 lg:px-6 lg:py-3 rounded-lg text-sm font-semibold border border-gray-700 hover:bg-gray-100 transition-colors flex items-center gap-2" aria-label="View All Ads">
                <span class="hidden lg:block">عرض كل الإعلانات</span>
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                    <path d="M5.79999 10.8L0.799988 5.80005L5.79999 0.800049" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    <path d="M10.8 5.80005H0.799988" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </a>
        </div>

        <!-- Ads Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php
            $ads = get_ads(8);
            foreach ($ads as $ad):
                include 'templates/ad-card.php';
            endforeach;
            ?>
        </div>
    </div>
</section>

<!-- Registered Companies Section -->
<section class="pt-8 pb-16 lg:pt-10 lg:pb-20">
    <div class="container">
        <!-- Section Header -->
        <div class="flex items-center justify-between mb-8 gap-4">
            <div class="text-start">
                <h2 class="text-2xl lg:text-3xl font-bold text-gray-800 tracking-tight mb-2">الشركات المسجلة</h2>
                <p class="text-base text-gray-700">تصفح الشركات الموثقة والمتاحة للتداول</p>
            </div>
            <a href="#" class="text-gray-700 px-2 py-2 lg:px-6 lg:py-3 rounded-lg text-sm font-semibold border border-gray-700 hover:bg-gray-100 transition-colors flex items-center gap-2" aria-label="View All Companies">
                <span class="hidden lg:block">عرض جميع الشركات</span>
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                    <path d="M5.79999 10.8L0.799988 5.80005L5.79999 0.800049" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    <path d="M10.8 5.80005H0.799988" stroke="#374151" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
            </a>
        </div>

        <!-- Companies Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php
            $companies = get_companies(4);
            foreach ($companies as $company):
                include 'templates/company-card.php';
            endforeach;
            ?>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="py-16 lg:py-20 bg-gradient-to-br from-primary-100 to-white">
    <div class="container">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">

            <!-- Content -->
            <div class="text-start">
                <span class="text-primary-600 font-medium">من نحن</span>
                <h2 class="text-4xl lg:text-5xl font-bold text-gray-700 !leading-snug tracking-tight mb-6 mt-4">
                    منصة مناقلة لتداول حصص الشركات غير المدرجة
                </h2>
                <p class="text-base text-gray-600 leading-relaxed mb-8">
                    منصة مناقلة هي سوق ثانوي متكامل يهدف إلى تسهيل تداول حصص الشركات غير المدرجة وصناديق الاستثمار في المملكة العربية السعودية. نوفر بيئة آمنة وشفافة تتيح للمستثمرين الوصول لفرص استثمارية متنوعة.
                </p>

                <!-- Features List -->
                <ul class="space-y-3 mb-8">
                    <li class="flex items-center justify-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8 16C3.58125 16 0 12.4187 0 8C0 3.58125 3.58125 0 8 0C12.4187 0 16 3.58125 16 8C16 12.4187 12.4187 16 8 16ZM8 1.5C4.40938 1.5 1.5 4.40938 1.5 8C1.5 11.5906 4.40938 14.5 8 14.5C11.5906 14.5 14.5 11.5906 14.5 8C14.5 4.40938 11.5906 1.5 8 1.5ZM10.2094 5.30937C10.4531 4.975 10.9219 4.9 11.2563 5.14375C11.5906 5.3875 11.6656 5.85625 11.4219 6.19063L7.60625 11.4406C7.47812 11.6188 7.27812 11.7312 7.05937 11.7469C6.84062 11.7625 6.625 11.6844 6.47188 11.5312L4.725 9.78438C4.43125 9.49063 4.43125 9.01562 4.725 8.725C5.01875 8.43438 5.49375 8.43125 5.78438 8.725L6.90938 9.85L10.2094 5.3125V5.30937Z" fill="#239463" />
                        </svg>
                        <span class="text-gray-700">رفع مستوى السيولة في سوق الحصص غير المدرجة</span>
                    </li>
                    <li class="flex items-center justify-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8 16C3.58125 16 0 12.4187 0 8C0 3.58125 3.58125 0 8 0C12.4187 0 16 3.58125 16 8C16 12.4187 12.4187 16 8 16ZM8 1.5C4.40938 1.5 1.5 4.40938 1.5 8C1.5 11.5906 4.40938 14.5 8 14.5C11.5906 14.5 14.5 11.5906 14.5 8C14.5 4.40938 11.5906 1.5 8 1.5ZM10.2094 5.30937C10.4531 4.975 10.9219 4.9 11.2563 5.14375C11.5906 5.3875 11.6656 5.85625 11.4219 6.19063L7.60625 11.4406C7.47812 11.6188 7.27812 11.7312 7.05937 11.7469C6.84062 11.7625 6.625 11.6844 6.47188 11.5312L4.725 9.78438C4.43125 9.49063 4.43125 9.01562 4.725 8.725C5.01875 8.43438 5.49375 8.43125 5.78438 8.725L6.90938 9.85L10.2094 5.3125V5.30937Z" fill="#239463" />
                        </svg>
                        <span class="text-gray-700">توفير قناة استثمار موثوقة ومنظمة</span>
                    </li>
                    <li class="flex items-center justify-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8 16C3.58125 16 0 12.4187 0 8C0 3.58125 3.58125 0 8 0C12.4187 0 16 3.58125 16 8C16 12.4187 12.4187 16 8 16ZM8 1.5C4.40938 1.5 1.5 4.40938 1.5 8C1.5 11.5906 4.40938 14.5 8 14.5C11.5906 14.5 14.5 11.5906 14.5 8C14.5 4.40938 11.5906 1.5 8 1.5ZM10.2094 5.30937C10.4531 4.975 10.9219 4.9 11.2563 5.14375C11.5906 5.3875 11.6656 5.85625 11.4219 6.19063L7.60625 11.4406C7.47812 11.6188 7.27812 11.7312 7.05937 11.7469C6.84062 11.7625 6.625 11.6844 6.47188 11.5312L4.725 9.78438C4.43125 9.49063 4.43125 9.01562 4.725 8.725C5.01875 8.43438 5.49375 8.43125 5.78438 8.725L6.90938 9.85L10.2094 5.3125V5.30937Z" fill="#239463" />
                        </svg>
                        <span class="text-gray-700">تسهيل إجراءات نقل الملكية بأمان</span>
                    </li>
                    <li class="flex items-center justify-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                            <path d="M8 16C3.58125 16 0 12.4187 0 8C0 3.58125 3.58125 0 8 0C12.4187 0 16 3.58125 16 8C16 12.4187 12.4187 16 8 16ZM8 1.5C4.40938 1.5 1.5 4.40938 1.5 8C1.5 11.5906 4.40938 14.5 8 14.5C11.5906 14.5 14.5 11.5906 14.5 8C14.5 4.40938 11.5906 1.5 8 1.5ZM10.2094 5.30937C10.4531 4.975 10.9219 4.9 11.2563 5.14375C11.5906 5.3875 11.6656 5.85625 11.4219 6.19063L7.60625 11.4406C7.47812 11.6188 7.27812 11.7312 7.05937 11.7469C6.84062 11.7625 6.625 11.6844 6.47188 11.5312L4.725 9.78438C4.43125 9.49063 4.43125 9.01562 4.725 8.725C5.01875 8.43438 5.49375 8.43125 5.78438 8.725L6.90938 9.85L10.2094 5.3125V5.30937Z" fill="#239463" />
                        </svg>
                        <span class="text-gray-700">تعزيز الشفافية عبر توفير بيانات واضحة</span>
                    </li>
                </ul>

                <a href="#" class="inline-flex items-center gap-2 bg-gradient-to-l from-primary-500 text-sm to-primary-600 text-white px-6 py-3 rounded-lg font-semibold border border-primary-600 hover:opacity-90 transition-opacity">
                    <span>تعرف اكثر عن مناقلة</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                        <path d="M5.80005 10.8L0.800049 5.80005L5.80005 0.800049" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M10.8 5.80005H0.800049" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </a>
            </div>

            <!-- Illustration -->
            <div>
                <div class="relative justify-center lg:justify-end flex">
                    <img src="images/Illustration.svg" alt="About Illustration" class="w-full max-w-[500px]">
                </div>
            </div>

        </div>
    </div>
</section>

<?php include 'footer.php'; ?>