<?php
/**
 * Data Helper Functions
 * Load data from JSON files for use across the site
 */

/**
 * Get all ads
 * @param int|null $limit Optional limit
 * @return array
 */
function get_ads($limit = null) {
    $json = file_get_contents(__DIR__ . '/../data/ads.json');
    $ads = json_decode($json, true) ?? [];

    if ($limit && $limit > 0) {
        return array_slice($ads, 0, $limit);
    }

    return $ads;
}

/**
 * Get single ad by ID
 * @param int $id
 * @return array|null
 */
function get_ad($id) {
    $ads = get_ads();
    foreach ($ads as $ad) {
        if ($ad['id'] == $id) {
            return $ad;
        }
    }
    return null;
}

/**
 * Get all companies
 * @param int|null $limit Optional limit
 * @return array
 */
function get_companies($limit = null) {
    $json = file_get_contents(__DIR__ . '/../data/companies.json');
    $companies = json_decode($json, true) ?? [];

    if ($limit && $limit > 0) {
        return array_slice($companies, 0, $limit);
    }

    return $companies;
}

/**
 * Get single company by ID
 * @param int $id
 * @return array|null
 */
function get_company($id) {
    $companies = get_companies();
    foreach ($companies as $company) {
        if ($company['id'] == $id) {
            return $company;
        }
    }
    return null;
}

/**
 * Filter ads by type (buy/sell)
 * @param string $type 'buy' or 'sell'
 * @param int|null $limit Optional limit
 * @return array
 */
function get_ads_by_type($type, $limit = null) {
    $ads = get_ads();
    $filtered = array_filter($ads, function($ad) use ($type) {
        return $ad['type'] === $type;
    });

    if ($limit && $limit > 0) {
        return array_slice(array_values($filtered), 0, $limit);
    }

    return array_values($filtered);
}

/**
 * Get verified companies only
 * @param int|null $limit Optional limit
 * @return array
 */
function get_verified_companies($limit = null) {
    $companies = get_companies();
    $filtered = array_filter($companies, function($company) {
        return $company['verified'] === true;
    });

    if ($limit && $limit > 0) {
        return array_slice(array_values($filtered), 0, $limit);
    }

    return array_values($filtered);
}

/**
 * Get all funds
 * @param int|null $limit Optional limit
 * @return array
 */
function get_funds($limit = null) {
    $json = file_get_contents(__DIR__ . '/../data/funds.json');
    $funds = json_decode($json, true) ?? [];

    if ($limit && $limit > 0) {
        return array_slice($funds, 0, $limit);
    }

    return $funds;
}

/**
 * Get single fund by ID
 * @param int $id
 * @return array|null
 */
function get_fund($id) {
    $funds = get_funds();
    foreach ($funds as $fund) {
        if ($fund['id'] == $id) {
            return $fund;
        }
    }
    return null;
}
