<?php
$current_page = basename($_SERVER['PHP_SELF'], '.php');
$is_home_page = in_array($current_page, ['index', 'companies', 'ads', 'funds'], true);

// Set page type for data attribute
$page_type = $is_home_page ? 'home' : $current_page;

// Header positioning classes
$header_position = $is_home_page ? 'absolute end-0 start-0' : 'sticky w-full';

// Helper function to get active link classes
function get_nav_classes($page_name, $current_page) {
    $is_active = ($page_name === $current_page);
    return $is_active
        ? 'bg-white text-gray-800 text-sm font-semibold px-3 py-2 rounded-md hover:bg-gray-50 transition-colors'
        : 'text-gray-800 text-sm font-semibold hover:text-primary-500 transition-colors';
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مناقلة - سوقك الآمن لتداول حصص الشركات غير المدرجة</title>
    <link href="assets/font/somarsans/font.css" rel="stylesheet">
    <link href="assets/font/riyal-symbol/font.css" rel="stylesheet">
    <link href="assets/css/input.min.css" rel="stylesheet">

</head>

<body class="min-h-screen flex flex-col font-rtl bg-gray-50 text-gray-600">
    <!-- Header Navigation -->
    <header id="main-header" class="<?php echo $header_position; ?> top-0 z-50 py-4 transition-all duration-300" data-page="<?php echo $page_type; ?>">
        <nav class="flex items-center justify-between container">
            <!-- Logo (Right in RTL) -->
            <div class="flex items-center">
                <a href="index.php" class="flex items-center" aria-label="Go to homepage">
                    <svg class="h-8" width="118" height="33" viewBox="0 0 118 33" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M117.77 0L100.682 16.5024L118 33H102.653L85 16.5024L102.653 0H117.77Z" fill="url(#paint0_linear_4035_1162)" />
                        <path d="M67.4177 12.0483C68.5669 12.0483 69.6091 12.3211 70.5441 12.8665C71.4986 13.3924 72.2388 14.1326 72.7647 15.0871C73.3102 16.0221 73.5829 17.0643 73.5829 18.2136V20.6095C73.5829 21.7199 73.3102 22.7523 72.7647 23.7067C72.2193 24.6418 71.4888 25.3917 70.5733 25.9566C69.6578 26.502 68.6546 26.7747 67.5638 26.7747C66.6093 26.7747 65.7035 26.6092 64.8464 26.278C63.9893 25.9469 63.2393 25.4794 62.5965 24.8755C62.1874 25.4988 61.6518 25.9956 60.9895 26.3657C60.3272 26.7163 59.587 26.8916 58.7688 26.8916H57.4832L56.256 26.4241V24.5249L57.4832 24.0574H58.7688C59.4116 24.0574 59.9278 23.8528 60.3174 23.4438C60.7265 23.0347 60.931 22.5088 60.931 21.8659V18.2136C60.931 17.0643 61.194 16.0221 61.7199 15.0871C62.2654 14.1326 63.0056 13.3924 63.9406 12.8665C64.8951 12.3211 65.947 12.0483 67.0962 12.0483H67.4177ZM70.7486 18.2136C70.7486 17.2201 70.437 16.4117 69.8136 15.7884C69.1903 15.165 68.3916 14.8534 67.4177 14.8534H67.0962C66.1223 14.8534 65.3236 15.165 64.7003 15.7884C64.0769 16.4117 63.7653 17.2201 63.7653 18.2136V22.1581C64.1938 22.723 64.7392 23.1711 65.4015 23.5022C66.0638 23.8139 66.7846 23.9697 67.5638 23.9697C68.4208 23.9697 69.1611 23.6386 69.7844 22.9763C70.4272 22.314 70.7486 21.5251 70.7486 20.6095V18.2136Z" fill="#374151" />
                        <path d="M52.8803 10.7335C52.3934 10.7335 51.9746 10.5679 51.6239 10.2367C51.2928 9.88612 51.1272 9.46732 51.1272 8.98033C51.1272 8.51283 51.2928 8.10376 51.6239 7.75313C51.9746 7.4025 52.3934 7.22719 52.8803 7.22719C53.3478 7.22719 53.7472 7.4025 54.0783 7.75313C54.4289 8.10376 54.6043 8.51283 54.6043 8.98033C54.6043 9.46732 54.4289 9.88612 54.0783 10.2367C53.7472 10.5679 53.3478 10.7335 52.8803 10.7335ZM57.8184 24.0574V26.8916H56.4743C55.8315 26.8916 55.2179 26.7455 54.6335 26.4533C54.0686 26.1611 53.5621 25.7618 53.1141 25.2553C52.257 26.3462 51.0298 26.8916 49.4325 26.8916H48.3222L47.095 26.4241V24.5249L48.3222 24.0574H49.4617C50.2409 24.0574 50.8058 23.8431 51.1564 23.4145C51.5265 22.986 51.7213 22.4114 51.7408 21.6906L51.7116 13.071H54.5458V21.6322C54.5458 22.3529 54.7309 22.9373 55.101 23.3853C55.4906 23.8333 56.075 24.0574 56.8541 24.0574H57.8184Z" fill="#374151" />
                        <path d="M45.6124 22.6841C45.6124 23.1321 45.7391 23.473 45.9923 23.7068C46.2455 23.9405 46.5572 24.0574 46.9273 24.0574H48.6512V26.8916H46.0507C45.1352 26.8916 44.356 26.58 43.7132 25.9566C43.0899 25.3333 42.7782 24.5638 42.7782 23.6483V6.55518H45.6124V22.6841Z" fill="#374151" />
                        <path d="M30.0457 9.47707C29.5782 9.47707 29.1691 9.31149 28.8185 8.98034C28.4679 8.62971 28.2925 8.21091 28.2925 7.72392C28.2925 7.25642 28.4679 6.85709 28.8185 6.52594C29.1691 6.17531 29.5782 6 30.0457 6C30.5327 6 30.9417 6.17531 31.2729 6.52594C31.6235 6.85709 31.7988 7.25642 31.7988 7.72392C31.7988 8.21091 31.6235 8.62971 31.2729 8.98034C30.9417 9.31149 30.5327 9.47707 30.0457 9.47707ZM35.3051 9.47707C34.8181 9.47707 34.3993 9.31149 34.0487 8.98034C33.7175 8.62971 33.552 8.21091 33.552 7.72392C33.552 7.25642 33.7175 6.85709 34.0487 6.52594C34.3993 6.17531 34.8181 6 35.3051 6C35.7726 6 36.172 6.17531 36.5031 6.52594C36.8537 6.85709 37.029 7.25642 37.029 7.72392C37.029 8.21091 36.8537 8.62971 36.5031 8.98034C36.172 9.31149 35.7726 9.47707 35.3051 9.47707ZM32.8799 12.0776C34.0097 12.0776 35.0421 12.3503 35.9772 12.8957C36.9316 13.4411 37.6816 14.1813 38.227 15.1163C38.7724 16.0514 39.0452 17.0935 39.0452 18.2428V21.1062C39.0452 22.1581 38.7822 23.1224 38.2562 23.9989C37.7498 24.8755 37.0583 25.5768 36.1817 26.1027C35.3051 26.6092 34.3409 26.8624 33.289 26.8624H24.6402L23.413 26.4241V24.4957L24.6402 24.0574H27.8835C27.4355 23.6288 27.0751 23.1224 26.8024 22.538C26.5491 21.9536 26.4225 21.3303 26.4225 20.668V18.2428C26.4225 17.0935 26.6952 16.0514 27.2407 15.1163C27.7861 14.1813 28.5263 13.4411 29.4613 12.8957C30.3963 12.3503 31.4385 12.0776 32.5877 12.0776H32.8799ZM36.2401 18.2428C36.2401 17.2883 35.9187 16.4896 35.2759 15.8468C34.6331 15.204 33.8344 14.8826 32.8799 14.8826H32.5877C31.6333 14.8826 30.8346 15.204 30.1918 15.8468C29.549 16.4702 29.2276 17.2688 29.2276 18.2428V20.668C29.2276 21.603 29.5392 22.4016 30.1626 23.0639C30.8054 23.7262 31.5553 24.0574 32.4124 24.0574H33.026C33.9026 24.0574 34.6526 23.7457 35.2759 23.1224C35.9187 22.499 36.2401 21.7393 36.2401 20.8433V18.2428Z" fill="#374151" />
                        <path d="M24.8023 24.0574V26.8916H23.429C22.7862 26.8916 22.1726 26.7455 21.5882 26.4533C21.0233 26.1612 20.5266 25.7618 20.098 25.2554C19.202 26.3462 17.965 26.8916 16.3872 26.8916H15.423V26.8624L14.225 26.4241V24.5249L15.423 24.1158V24.0574H16.4164C17.1956 24.0574 17.7702 23.8334 18.1403 23.3853C18.5104 22.9373 18.6955 22.3529 18.6955 21.6322V6.55518H21.5297V20.6095C21.5297 20.9212 21.52 21.1647 21.5005 21.34V21.6322C21.5005 22.3529 21.6856 22.9373 22.0557 23.3853C22.4453 23.8334 23.0296 24.0574 23.8088 24.0574H24.8023Z" fill="#374151" />
                        <path d="M4.06145 9.47707C3.57446 9.47707 3.15566 9.31149 2.80503 8.98034C2.47388 8.62971 2.30831 8.21091 2.30831 7.72392C2.30831 7.25642 2.47388 6.85709 2.80503 6.52594C3.15566 6.17531 3.57446 6 4.06145 6C4.52895 6 4.92828 6.17531 5.25943 6.52594C5.61006 6.85709 5.78537 7.25642 5.78537 7.72392C5.78537 8.21091 5.61006 8.62971 5.25943 8.98034C4.92828 9.31149 4.52895 9.47707 4.06145 9.47707ZM9.29166 9.47707C8.82415 9.47707 8.41509 9.31149 8.06446 8.98034C7.71383 8.62971 7.53851 8.21091 7.53851 7.72392C7.53851 7.25642 7.71383 6.85709 8.06446 6.52594C8.41509 6.17531 8.82415 6 9.29166 6C9.77864 6 10.1877 6.17531 10.5189 6.52594C10.8695 6.85709 11.0448 7.25642 11.0448 7.72392C11.0448 8.21091 10.8695 8.62971 10.5189 8.98034C10.1877 9.31149 9.77864 9.47707 9.29166 9.47707ZM15.6322 24.0574V26.8916H14.8141C13.957 26.8916 13.168 26.7066 12.4473 26.3365C11.7266 25.9469 11.1325 25.4209 10.665 24.7586C9.53515 26.1027 7.9768 26.7747 5.9899 26.7747C4.89906 26.7747 3.89587 26.502 2.98034 25.9566C2.06481 25.3917 1.33434 24.6418 0.788914 23.7067C0.262971 22.7523 0 21.7198 0 20.6095V18.2136C0 17.0643 0.262971 16.0221 0.788914 15.0871C1.33434 14.1326 2.07455 13.3924 3.00956 12.8665C3.94457 12.3211 4.99646 12.0483 6.16522 12.0483H12.6226V21.8659C12.6226 22.5088 12.8272 23.0347 13.2362 23.4438C13.6453 23.8528 14.1712 24.0574 14.8141 24.0574H15.6322ZM9.8176 14.8534H6.16522C5.19125 14.8534 4.3926 15.165 3.76926 15.7884C3.14592 16.4117 2.83425 17.2201 2.83425 18.2136V20.6095C2.83425 21.5251 3.14592 22.314 3.76926 22.9763C4.3926 23.6386 5.13281 23.9697 5.9899 23.9697C6.76908 23.9697 7.48982 23.8139 8.15211 23.5022C8.83389 23.1711 9.38905 22.723 9.8176 22.1581V14.8534Z" fill="#374151" />
                        <defs>
                            <linearGradient id="paint0_linear_4035_1162" x1="85" y1="18.5" x2="118" y2="5.96047e-08" gradientUnits="userSpaceOnUse">
                                <stop stop-color="#3D8FFF" />
                                <stop offset="1" stop-color="#0071E3" />
                            </linearGradient>
                        </defs>
                    </svg>
                </a>
            </div>

            <!-- Center: Navigation Links -->
            <div class="hidden lg:flex items-center gap-8">
                <a href="index.php" class="<?php echo get_nav_classes('index', $current_page); ?>">الرئيسية</a>
                <a href="companies.php" class="<?php echo get_nav_classes('companies', $current_page); ?>">الشركات</a>
                <a href="funds.php" class="<?php echo get_nav_classes('funds', $current_page); ?>">الصناديق</a>
                <a href="ads.php" class="<?php echo get_nav_classes('ads', $current_page); ?>">الإعلانات</a>
                <a href="blog.php" class="<?php echo get_nav_classes('blog', $current_page); ?>">المدونة</a>
                <a href="about.php" class="<?php echo get_nav_classes('about', $current_page); ?>">من نحن</a>
                <a href="contact.php" class="<?php echo get_nav_classes('contact', $current_page); ?>">تواصل معنا</a>
                <button id="search-btn" class="flex items-center gap-2 text-gray-800 hover:text-primary-500 transition-colors" aria-label="بحث">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                        <path d="M16.8 16.8L12.9422 12.9422" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M7.9111 15.0222C11.8385 15.0222 15.0222 11.8385 15.0222 7.91111C15.0222 3.98376 11.8385 0.800003 7.9111 0.800003C3.98374 0.800003 0.799988 3.98376 0.799988 7.91111C0.799988 11.8385 3.98374 15.0222 7.9111 15.0222Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </button>
            </div>

            <!-- Search Dropdown -->
            <div id="search-dropdown" class="container rounded-lg hidden absolute top-full end-0 start-0 bg-white shadow-sm border-t border-gray-100 py-6 px-6 z-50">
                <form action="/search" method="GET" class="relative">
                    <input
                        type="text"
                        name="q"
                        id="search-input"
                        placeholder="ابحث عن شركة، صندوق، أو إعلان..."
                        class="w-full px-5 py-4 pr-14 text-base border border-gray-200 rounded-lg focus:outline-none focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition-all"
                        autocomplete="off">
                    <button type="submit" class="absolute end-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-primary-500 transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 18 18" fill="none">
                            <path d="M16.8 16.8L12.9422 12.9422" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M7.9111 15.0222C11.8385 15.0222 15.0222 11.8385 15.0222 7.91111C15.0222 3.98376 11.8385 0.800003 7.9111 0.800003C3.98374 0.800003 0.799988 3.98376 0.799988 7.91111C0.799988 11.8385 3.98374 15.0222 7.9111 15.0222Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </button>
                    <button type="button" id="search-close" class="absolute start-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </form>
            </div>

            <!-- Auth Buttons (Left in RTL) -->
            <div class="hidden lg:flex items-center gap-4">
                <a href="login.php" class="text-gray-800 text-sm font-semibold hover:text-primary-500 transition-colors">
                    تسجيل الدخول
                </a>
                <a href="register.php" class="bg-gradient-to-l from-secondary-500 to-secondary-600 text-white text-sm px-6 py-3 rounded-lg font-semibold border border-secondary-600 hover:opacity-90 transition-opacity">
                    إنشاء حساب
                </a>
            </div>

            <!-- Mobile Menu Button -->
            <button id="mobile-menu-btn" class="lg:hidden text-gray-800" aria-label="القائمة">
                <svg id="menu-icon-open" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
                <svg id="menu-icon-close" class="w-6 h-6 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </nav>

    </header>

    <!-- Mobile Menu Panel (outside header to avoid transform containing block issues) -->
    <div id="mobile-menu" class="lg:hidden hidden fixed inset-0 top-[72px] bg-white z-40">
        <div class="flex flex-col h-full p-6 justify-between">
            <!-- Top links -->
            <div class="flex flex-col">
                <a href="index.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">الرئيسية</a>
                <a href="companies.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">الشركات</a>
                <a href="funds.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">الصناديق</a>
                <a href="ads.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">الإعلانات</a>
                <a href="blog.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">المدونة</a>
                <a href="about.php" class="text-gray-800 font-semibold py-3 border-b border-gray-100">من نحن</a>
                <a href="contact.php" class="text-gray-800 font-semibold py-3">تواصل معنا</a>
            </div>

            <!-- Bottom buttons -->
            <div class="flex flex-col gap-3 text-center">
                <a href="login.php" class="text-gray-800 text-sm font-semibold py-3 border border-gray-200 rounded-lg">
                    تسجيل الدخول
                </a>
                <a href="register.php" class="bg-gradient-to-l from-secondary-500 to-secondary-600 text-white text-sm px-6 py-3 rounded-lg font-semibold border border-secondary-600 hover:opacity-90 transition-opacity">
                    إنشاء حساب
                </a>
            </div>
        </div>
    </div>

    <div id="content" class="flex-1 site-content">

        <div id="primary" class="w-full">

            <main id="main" role="main">