<?php
include 'header.php';
include 'includes/data.php';

$breadcrumb_title = 'الصناديق الاستثمارية';
$breadcrumb_desc  = 'اكتشف صناديق استثمار مرخصة تناسب أهدافك المالية';
$breadcrumb_current  = 'الصناديق';
$breadcrumb_bg    = 'bg-[#EEE5FF]';
$breadcrumb_img    = 'funds-bg.svg';

include 'templates/partials/archive-breadcrumb.php';
?>

<div class="py-16">
    <div class="container">
        <div class="space-y-8">

            <!-- Search & Filter Section -->
            <div>
                <div class="bg-white rounded-2xl p-5 border border-gray-100 shadow-sm">

                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-4">

                        <!-- Search Input -->
                        <div class="lg:col-span-5 order-1">
                            <div class="relative">
                                <input
                                    type="text"
                                    id="search-funds"
                                    placeholder="ابحث عن صندوق..."
                                    class="w-full px-5 py-4 ps-12">
                                <svg class="absolute start-4 top-1/2 -translate-y-1/2 text-gray-400" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M14.4 14.4L10.8533 10.8533" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M6.4 12C9.4928 12 12 9.4928 12 6.4C12 3.3072 9.4928 0.8 6.4 0.8C3.3072 0.8 0.8 3.3072 0.8 6.4C0.8 9.4928 3.3072 12 6.4 12Z" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                        </div>

                        <!-- Fund Type -->
                        <div class="lg:col-span-2 order-2">
                            <select id="type-filter" class="w-full">
                                <option value="">نوع الصندوق</option>
                                <option value="صناديق أوحدة">صناديق أوحدة</option>
                                <option value="صناديق متنوعة">صناديق متنوعة</option>
                                <option value="صناديق مغلقة">صناديق مغلقة</option>
                                <option value="صناديق متوازنة">صناديق متوازنة</option>
                                <option value="صناديق مفتوحة">صناديق مفتوحة</option>
                                <option value="صناديق اكتتاب">صناديق اكتتاب</option>
                                <option value="صناديق عالية">صناديق عالية</option>
                            </select>
                        </div>

                        <!-- Risk Level -->
                        <div class="lg:col-span-2 order-3">
                            <select id="risk-filter" class="w-full">
                                <option value="">مستوى المخاطرة</option>
                                <option value="مخاطرة منخفضة">مخاطرة منخفضة</option>
                                <option value="مخاطرة متوسطة">مخاطرة متوسطة</option>
                                <option value="مخاطرة عالية">مخاطرة عالية</option>
                            </select>
                        </div>

                        <!-- Availability -->
                        <div class="lg:col-span-2 order-4">
                            <select id="status-filter" class="w-full">
                                <option value="">الحالة</option>
                                <option value="متاح">متاح</option>
                                <option value="مكتمل">مكتمل</option>
                            </select>
                        </div>

                        <!-- Reset Button -->
                        <div class="lg:col-span-1 order-5">
                            <button
                                id="reset-filters"
                                type="button"
                                class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 px-5 py-4 border border-gray-200 rounded-lg text-sm font-semibold transition-colors flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8" />
                                    <path d="M3 3v5h5" />
                                </svg>
                            </button>
                        </div>

                    </div>
                </div>

                <!-- Results Count -->
                <div class="mt-4 text-sm text-gray-600 text-start">
                    <span id="results-count">عرض النتائج 1 إلى 8 من 8 إجمالاً صناديق</span>
                </div>
            </div>

            <!-- Funds Grid Section -->
            <div>
                <div id="funds-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php
                    $funds = get_funds();
                    foreach ($funds as $fund):
                        include 'templates/funds-card.php';
                    endforeach; ?>
                </div>
            </div>

            <?php
            // Pagination
            include 'templates/partials/pagination.php'; ?>

        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
