<?php
include 'header.php';
include 'includes/data.php';

// Get fund ID from URL
$fund_id = isset($_GET['id']) ? (int)$_GET['id'] : 1;
$fund = get_fund($fund_id);

// If fund not found, redirect to funds page
if (!$fund) {
    header('Location: funds.php');
    exit;
}

$breadcrumb_current = $fund['name_ar'];
include 'templates/partials/default-breadcrumb.php';

// Fund type colors
$typeColors = [
    'صناديق أوحدة' => 'bg-secondary-100 text-secondary-700',
    'صناديق متنوعة' => 'bg-purple-100 text-purple-700',
    'صناديق مغلقة' => 'bg-blue-100 text-blue-700',
    'صناديق متوازنة' => 'bg-amber-100 text-amber-700',
    'صناديق مفتوحة' => 'bg-green-100 text-green-700',
    'صناديق اكتتاب' => 'bg-orange-100 text-orange-700',
    'صناديق عالية' => 'bg-red-100 text-red-700',
];
$colorClass = $typeColors[$fund['type']] ?? 'bg-gray-100 text-gray-700';
?>

<div class="pt-4 pb-16">
    <div class="container">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">

            <!-- Main Content - Right Side in RTL (8 cols) -->
            <div class="lg:col-span-8 space-y-6">

                <!-- Fund Header -->
                <div class="flex items-start justify-between">

                    <!-- Fund Info -->
                    <div class="flex items-center gap-4">
                        <!-- Fund Logo -->
                        <div class="w-24 h-24 bg-gray-50 rounded-2xl flex items-center justify-center border border-gray-100 site-card">
                            <?php if (!empty($fund['logo']) && file_exists($fund['logo'])): ?>
                                <img src="<?php echo $fund['logo']; ?>" alt="<?php echo htmlspecialchars($fund['name_ar']); ?>" class="w-20 h-20 object-contain mix-blend-darken">
                            <?php endif; ?>
                        </div>

                        <div class="text-start">
                            <!-- Badges -->
                            <div class="flex items-center justify-start gap-2 mb-2">
                                <?php if (!empty($fund['badge'])): ?>
                                    <?php if ($fund['badge'] === 'متاح'): ?>
                                        <span class="bg-secondary-500 text-white text-xs px-3 py-1 rounded-full">متاح</span>
                                    <?php elseif ($fund['badge'] === 'مكتمل'): ?>
                                        <span class="bg-red-500 text-white text-xs px-3 py-1 rounded-full">مكتمل</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <span class="<?php echo $colorClass; ?> text-xs px-3 py-1 rounded-full font-medium">
                                    <?php echo htmlspecialchars($fund['type']); ?>
                                </span>
                            </div>
                            <h1 class="text-2xl font-bold text-gray-900 mb-1"><?php echo htmlspecialchars($fund['name_ar']); ?></h1>
                            <p class="text-sm text-gray-600"><?php echo htmlspecialchars($fund['name_en']); ?></p>
                        </div>

                    </div>

                    <!-- Action Buttons -->
                    <div class="flex items-center gap-2">
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                            </svg>
                        </button>
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" />
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">

                    <div class="bg-white rounded-xl p-4 text-center border border-gray-100">
                        <p class="text-sm text-gray-600 mb-2">سعر الوحدة</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="text-2xl font-bold text-gray-900"><?php echo htmlspecialchars($fund['price']); ?></span>
                            <span class="icon-riyal-symbol text-lg text-gray-900"></span>
                        </div>
                    </div>

                    <div class="bg-secondary-50 rounded-xl p-4 text-center border border-secondary-100">
                        <p class="text-sm text-gray-600 mb-2">العائد السنوي</p>
                        <p class="text-2xl font-bold <?php echo $fund['returnType'] === 'up' ? 'text-secondary-600' : 'text-red-600'; ?>">
                            <?php echo htmlspecialchars($fund['return_rate']); ?>
                        </p>
                    </div>

                    <div class="bg-primary-50 rounded-xl p-4 text-center border border-primary-100">
                        <p class="text-sm text-gray-600 mb-2">رسوم الإدارة</p>
                        <p class="text-2xl font-bold text-primary-600"><?php echo htmlspecialchars($fund['fees']); ?></p>
                    </div>

                    <div class="bg-[#FDFBF7] rounded-xl p-4 text-center border border-[#F7EFDE]">
                        <p class="text-sm text-gray-600 mb-2">مستوى المخاطرة</p>
                        <div class="flex items-center justify-center gap-2">
                            <div class="flex gap-0.5">
                                <?php
                                $riskLevel = $fund['risk_level'] ?? 2;
                                for ($i = 0; $i < 3; $i++):
                                ?>
                                    <div class="w-2 h-5 rounded-sm <?php echo $i < $riskLevel ? 'bg-orange-500' : 'bg-gray-200'; ?>"></div>
                                <?php endfor; ?>
                            </div>
                            <span class="text-sm font-bold text-[#8B5D00]"><?php echo htmlspecialchars($fund['risk']); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Fund Description -->
                <div class="bg-white rounded-2xl border border-gray-100 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                        <h2 class="text-base font-bold text-gray-900">عن الصندوق</h2>
                    </div>
                    <p class="text-sm text-gray-700 leading-relaxed mb-4">
                        صندوق استثماري مرخص من هيئة السوق المالية السعودية، يهدف إلى تحقيق نمو رأسمالي على المدى الطويل من خلال الاستثمار في محفظة متنوعة من الأسهم المحلية والإقليمية المتوافقة مع الشريعة الإسلامية.
                    </p>
                    <p class="text-sm text-gray-700 leading-relaxed mb-4">
                        يدار الصندوق من قبل فريق استثماري متخصص يتمتع بخبرة واسعة في الأسواق المالية، ويتبع استراتيجية استثمارية متحفظة تركز على الشركات ذات الأساسيات القوية والنمو المستدام.
                    </p>
                </div>

                <!-- Investment Strategy -->
                <div class="bg-white rounded-2xl border border-gray-100 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                        <h2 class="text-base font-bold text-gray-900">استراتيجية الاستثمار</h2>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="bg-gray-50 rounded-xl p-4">
                            <h3 class="text-sm font-bold text-gray-900 mb-2">توزيع الأصول</h3>
                            <ul class="space-y-2 text-sm text-gray-600">
                                <li class="flex items-center justify-between">
                                    <span>أسهم محلية</span>
                                    <span class="font-bold text-gray-900">60%</span>
                                </li>
                                <li class="flex items-center justify-between">
                                    <span>أسهم إقليمية</span>
                                    <span class="font-bold text-gray-900">25%</span>
                                </li>
                                <li class="flex items-center justify-between">
                                    <span>صكوك</span>
                                    <span class="font-bold text-gray-900">10%</span>
                                </li>
                                <li class="flex items-center justify-between">
                                    <span>نقد</span>
                                    <span class="font-bold text-gray-900">5%</span>
                                </li>
                            </ul>
                        </div>
                        <div class="bg-gray-50 rounded-xl p-4">
                            <h3 class="text-sm font-bold text-gray-900 mb-2">أهداف الصندوق</h3>
                            <ul class="space-y-2 text-sm text-gray-600">
                                <li class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span>نمو رأس المال طويل الأجل</span>
                                </li>
                                <li class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span>تنويع المحفظة الاستثمارية</span>
                                </li>
                                <li class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span>توزيعات أرباح دورية</span>
                                </li>
                                <li class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    <span>متوافق مع الشريعة</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Performance Chart Placeholder -->
                <div class="bg-white rounded-2xl border border-gray-100 p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 12l3-3 3 3 4-4M8 21l4-4 4 4M3 4h18M4 4h16v12a1 1 0 01-1 1H5a1 1 0 01-1-1V4z" />
                            </svg>
                            <h2 class="text-base font-bold text-gray-900">أداء الصندوق</h2>
                        </div>
                        <div class="flex items-center gap-2">
                            <button class="px-3 py-1 text-xs bg-primary-500 text-white rounded-lg">سنة</button>
                            <button class="px-3 py-1 text-xs bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200">6 أشهر</button>
                            <button class="px-3 py-1 text-xs bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200">شهر</button>
                        </div>
                    </div>
                    <div class="h-48 bg-gradient-to-br from-gray-50 to-gray-100 rounded-xl flex items-center justify-center">
                        <p class="text-gray-400 text-sm">رسم بياني للأداء</p>
                    </div>
                </div>

            </div>

            <!-- Sidebar - Left Side in RTL (4 cols) -->
            <div class="lg:col-span-4 space-y-6">

                <!-- Fund Manager -->
                <div class="bg-[#E7EFEF] rounded-2xl p-6 text-center">
                    <img src="images/avatar.jpg" alt="مدير الصندوق" class="w-20 h-20 rounded-full object-cover mx-auto mb-4 border-4 border-white shadow-sm">
                    <h3 class="text-base font-bold text-gray-900 mb-1">خالد العمري</h3>
                    <p class="text-sm text-gray-500 mb-2">مدير الصندوق</p>
                    <p class="text-xs text-gray-600">خبرة +15 سنة في إدارة الأصول</p>
                </div>

                <!-- Subscribe Card -->
                <div class="bg-white rounded-2xl border border-gray-100 p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="text-sm font-bold text-gray-900">الاشتراك في الصندوق</span>
                    </div>

                    <!-- Investment Amount -->
                    <p class="text-sm font-semibold text-gray-900 mb-3">مبلغ الاستثمار</p>
                    <div class="relative mb-4">
                        <input type="number" id="investment-amount" value="10000" min="1000" class="w-full px-4 py-3 pe-16 border border-gray-200 rounded-lg text-lg font-bold text-gray-900 focus:ring-2 focus:ring-primary-500 focus:border-primary-500">
                        <span class="absolute end-4 top-1/2 -translate-y-1/2 text-sm text-gray-500">ريال</span>
                    </div>

                    <p class="text-xs text-gray-500 mb-4">الحد الأدنى للاشتراك: 1,000 ريال</p>

                    <!-- Calculations -->
                    <div class="border-t border-gray-100 pt-4 space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">عدد الوحدات المتوقعة</span>
                            <div class="flex items-center gap-1">
                                <span class="font-bold text-gray-900" id="units-count">631.91</span>
                            </div>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">سعر الوحدة</span>
                            <div class="flex items-center gap-1">
                                <span class="font-bold text-gray-900"><?php echo htmlspecialchars($fund['price']); ?></span>
                                <span class="icon-riyal-symbol text-sm text-gray-900"></span>
                            </div>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">رسوم الاشتراك</span>
                            <span class="font-bold text-gray-900"><?php echo htmlspecialchars($fund['fees']); ?></span>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <?php if ($fund['badge'] === 'متاح' || empty($fund['badge'])): ?>
                        <button class="w-full bg-primary-500 hover:bg-primary-600 text-white py-4 rounded-xl text-sm font-bold transition-colors flex items-center justify-center gap-2 mt-6">
                            اشترك الآن
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                            </svg>
                        </button>
                    <?php else: ?>
                        <button class="w-full bg-gray-300 text-gray-500 py-4 rounded-xl text-sm font-bold cursor-not-allowed mt-6" disabled>
                            الاشتراك مغلق
                        </button>
                    <?php endif; ?>

                    <!-- Trust Badge -->
                    <p class="text-xs text-center text-gray-500 mt-3 flex items-center justify-center gap-1">
                        صندوق مرخص من هيئة السوق المالية
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </p>
                </div>

                <!-- Fund Info Card -->
                <div class="bg-white rounded-2xl border border-gray-100 p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="text-sm font-bold text-gray-900">معلومات الصندوق</span>
                    </div>

                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm font-bold text-gray-900">البنك الأهلي</span>
                            <span class="text-sm text-gray-500">مدير الصندوق</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm font-bold text-gray-900">2018</span>
                            <span class="text-sm text-gray-500">تاريخ التأسيس</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm font-bold text-gray-900">500 مليون ريال</span>
                            <span class="text-sm text-gray-500">حجم الصندوق</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm font-bold text-gray-900">ربع سنوي</span>
                            <span class="text-sm text-gray-500">توزيع الأرباح</span>
                        </div>
                        <div class="flex items-center justify-between py-2">
                            <span class="text-sm font-bold text-gray-900">1,000 ريال</span>
                            <span class="text-sm text-gray-500">الحد الأدنى</span>
                        </div>
                    </div>
                </div>

                <!-- Documents -->
                <div class="bg-white rounded-2xl border border-gray-100 p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                        <span class="text-sm font-bold text-gray-900">وثائق الصندوق</span>
                    </div>

                    <div class="space-y-3">
                        <a href="#" class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                </svg>
                                <span class="text-sm text-gray-700">نشرة الإصدار</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                            </svg>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                </svg>
                                <span class="text-sm text-gray-700">الشروط والأحكام</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                            </svg>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition-colors">
                            <div class="flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                </svg>
                                <span class="text-sm text-gray-700">التقرير السنوي</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                            </svg>
                        </a>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const amountInput = document.getElementById('investment-amount');
        const unitsCount = document.getElementById('units-count');
        const unitPrice = <?php echo floatval($fund['price']); ?>;

        function updateUnits() {
            const amount = parseFloat(amountInput.value) || 0;
            const units = amount / unitPrice;
            unitsCount.textContent = units.toFixed(2);
        }

        amountInput.addEventListener('input', updateUnits);
        updateUnits();
    });
</script>

<?php include 'footer.php'; ?>