<?php
include 'header.php';
include 'includes/data.php';

// Get company ID from URL
$company_id = isset($_GET['id']) ? (int)$_GET['id'] : 1;
$company = get_company($company_id);

// If company not found, redirect to companies page
if (!$company) {
    header('Location: companies.php');
    exit;
}

$breadcrumb_current = $company['name'];
include 'templates/partials/default-breadcrumb.php';
?>

<div class="pt-4 pb-16">
    <div class="container">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">

            <!-- Main Content - Right Side in RTL (8 cols) -->
            <div class="lg:col-span-8 space-y-6">

                <!-- Company Header -->
                <div class="flex items-start justify-between">


                    <!-- Company Info -->
                    <div class="flex items-center gap-4">
                        <!-- Company Logo -->
                        <div class="w-24 h-24 rounded-2xl flex items-center justify-center site-card">
                            <?php if (!empty($company['image']) && file_exists($company['image'])): ?>
                                <img src="<?php echo $company['image']; ?>" alt="<?php echo $company['name']; ?>" class="w-20 h-20 object-contain mix-blend-darken">
                            <?php endif; ?>
                        </div>
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900 mb-2"><?php echo $company['name']; ?></h1>
                            <p class="text-sm text-gray-600 mb-2"><?php echo $company['sector']; ?></p>
                            <?php if ($company['verified']): ?>
                                <span class="inline-flex items-center gap-1 text-xs text-secondary-600">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    موثقة
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex items-center gap-2">
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                            </svg>
                        </button>
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" />
                            </svg>
                        </button>
                    </div>

                </div>

                <!-- Stats Cards -->
                <div class="grid grid-cols-2 lg:grid-cols-4 gap-4">

                    <div class="bg-white rounded-xl p-4 text-center border border-gray-100">
                        <p class="text-sm text-gray-600 mb-2">سعر السهم</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="text-2xl font-bold text-gray-900"><?php echo $company['price']; ?></span>
                            <span class="icon-riyal-symbol text-lg text-gray-900"></span>
                        </div>
                    </div>

                    <div class="bg-primary-50 rounded-xl p-4 text-center border border-primary-100">
                        <p class="text-sm text-gray-600 mb-2">عدد الأسهم</p>
                        <p class="text-2xl font-bold text-primary-600">500k</p>
                    </div>

                    <div class="bg-secondary-50 rounded-xl p-4 text-center border border-secondary-100">
                        <p class="text-sm text-gray-600 mb-2">آخر سعر تداول</p>
                        <p class="text-2xl font-bold text-secondary-600 mb-1">155</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="text-sm <?php echo $company['changeType'] === 'up' ? 'text-green-600' : 'text-red-600'; ?>"><?php echo $company['change']; ?></span>
                            <svg class="w-4 h-4 <?php echo $company['changeType'] === 'up' ? 'text-green-600' : 'text-red-600 rotate-180'; ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
                            </svg>
                        </div>
                    </div>

                    <div class="bg-[#FDFBF7] rounded-xl p-4 text-center border border-[#F7EFDE]">
                        <p class="text-sm text-gray-600 mb-2">القيمة السوقية</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="text-2xl font-bold text-[#8B5D00]">75M</span>
                            <span class="icon-riyal-symbol text-lg text-[#8B5D00]"></span>
                        </div>
                    </div>

                </div>

                <!-- Company Description -->
                <div class="bg-white rounded-2xl border border-gray-100 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                        <h2 class="text-base font-bold text-gray-900">عن الشركة</h2>
                    </div>
                    <p class="text-sm text-gray-700 leading-relaxed mb-4">
                        شركة الوطنية للتقنية هي شركة سعودية رائدة في مجال تقنية المعلومات وحلول الأعمال الرقمية. تأسست الشركة عام 2015 برؤية واضحة لتقديم حلول تقنية مبتكرة تخدم القطاعين العام والخاص في المملكة العربية السعودية.
                    </p>
                    <p class="text-sm text-gray-700 leading-relaxed mb-4">
                        تقدم الشركة مجموعة واسعة من الخدمات تشمل تطوير البرمجيات، حلول الحوسبة السحابية، الأمن السيبراني، وتحليل البيانات. حققت الشركة نمواً ملحوظاً خلال السنوات الماضية مع توسع قاعدة عملائها لتشمل كبرى الشركات والجهات الحكومية.
                    </p>
                </div>

                <!-- News Section -->
                <div>
                    <h2 class="text-xl font-bold text-gray-900 mb-6">الأخبار</h2>

                    <div class="space-y-4">
                        <!-- News Item 1 -->
                        <div class="bg-white rounded-2xl border border-gray-100 p-4 flex items-start gap-4">
                            <img src="images/news-1.jpg" alt="خبر" class="w-24 h-24 rounded-xl object-cover flex-shrink-0">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 text-xs text-gray-500 mb-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                    10 ديسمبر 2025
                                </div>
                                <h3 class="font-bold text-gray-900 mb-2">الوطنية للتقنية توقع عقداً بـ 20 مليون ريال</h3>
                                <p class="text-sm text-gray-600 line-clamp-2">أعلنت شركة الوطنية للتقنية عن توقيع عقد جديد مع إحدى الجهات الحكومية بقيمة 20 مليون ريال لتقديم حلول الأمن السيبراني المتقدمة...</p>
                            </div>
                        </div>

                        <!-- News Item 2 -->
                        <div class="bg-white rounded-2xl border border-gray-100 p-4 flex items-start gap-4">
                            <img src="images/news-2.jpg" alt="خبر" class="w-24 h-24 rounded-xl object-cover flex-shrink-0">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 text-xs text-gray-500 mb-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                    1 نوفمبر 2025
                                </div>
                                <h3 class="font-bold text-gray-900 mb-2">نتائج الربع الثالث تظهر نمواً بنسبة 35%</h3>
                                <p class="text-sm text-gray-600 line-clamp-2">حققت الشركة نمواً في الإيرادات بنسبة 35% خلال الربع الثالث من العام الحالي مقارنة بنفس الفترة من العام الماضي مع زيادة في الأرباح...</p>
                            </div>
                        </div>

                        <!-- News Item 3 -->
                        <div class="bg-white rounded-2xl border border-gray-100 p-4 flex items-start gap-4">
                            <img src="images/news-3.jpg" alt="خبر" class="w-24 h-24 rounded-xl object-cover flex-shrink-0">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 text-xs text-gray-500 mb-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                    10 ديسمبر 2024
                                </div>
                                <h3 class="font-bold text-gray-900 mb-2">شراكة استراتيجية مع Microsoft Azure</h3>
                                <p class="text-sm text-gray-600 line-clamp-2">أعلنت الشركة عن شراكة استراتيجية مع Microsoft Azure لتقديم حلول سحابية متطورة للسوق السعودي...</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Sidebar - Left Side in RTL (4 cols) -->
            <div class="lg:col-span-4 space-y-6">

                <!-- CEO Card -->
                <div class="bg-[#E7EFEF] rounded-2xl p-6 text-center">
                    <img src="images/avatar.jpg" alt="الرئيس التنفيذي" class="w-24 h-24 rounded-full object-cover mx-auto mb-4 border-4 border-white shadow-sm">
                    <h3 class="text-base font-bold text-gray-900 mb-1">عبدالله محمد الأحمد</h3>
                    <p class="text-sm text-gray-500">الرئيس التنفيذي</p>
                </div>

                <!-- Company Info Card -->
                <div class="bg-primary-50 rounded-2xl border border-primary-100 p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                        <span class="text-sm font-bold text-gray-900">معلومات أساسية</span>
                    </div>

                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-500">تاريخ التوثيق</span>
                            <span class="text-sm font-bold text-gray-900">2015</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-500">سنة التأسيس</span>
                            <span class="text-sm font-bold text-gray-900">1/2/2012</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-500">رقم السجل التجاري</span>
                            <span class="text-sm font-bold text-gray-900">1010xxxxxx</span>
                        </div>
                        <div class="flex items-center justify-between py-2 border-b border-gray-100">
                            <span class="text-sm text-gray-500">المقر الرئيسي</span>
                            <span class="text-sm font-bold text-gray-900">الرياض</span>
                        </div>
                        <div class="flex items-center justify-between py-2">
                            <span class="text-sm text-gray-500">عدد الموظفين</span>
                            <span class="text-sm font-bold text-gray-900">+200</span>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>

<?php include 'footer.php'; ?>