<?php
include 'header.php';
include 'includes/data.php';

$breadcrumb_title = 'الشركات المسجلة';
$breadcrumb_desc  = 'تصفح الشركات المُوَثَّقة من جهات رسمية والمُستَوفية لجميع المعايير القانونية';
$breadcrumb_current  = 'الشركات';
$breadcrumb_bg    = 'bg-[#EAFAF4]';
$breadcrumb_img    = 'companies-bg.svg';

include 'templates/partials/archive-breadcrumb.php';
?>

<div class="pt-12 pb-16">
    <div class="container">
        <div class="space-y-8">

            <!-- Search & Filter Section -->
            <div>
                <div class="bg-white rounded-2xl p-5 border border-gray-100 shadow-sm">

                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-4">

                        <!-- Search Input -->
                        <div class="lg:col-span-5 order-1">
                            <div class="relative">
                                <input
                                    type="text"
                                    id="search-companies"
                                    placeholder="ابحث عن شركة..."
                                    class="w-full px-5 py-4 ps-12">
                                <svg class="absolute start-4 top-1/2 -translate-y-1/2 text-gray-400" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M14.4 14.4L10.8533 10.8533" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M6.4 12C9.4928 12 12 9.4928 12 6.4C12 3.3072 9.4928 0.8 6.4 0.8C3.3072 0.8 0.8 3.3072 0.8 6.4C0.8 9.4928 3.3072 12 6.4 12Z" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                        </div>

                        <!-- Sector Type -->
                        <div class="lg:col-span-2 order-2">
                            <select id="sector-filter" class="w-full">
                                <option value="">نوع القطاع</option>
                                <option value="قطاع الصحة">قطاع الصحة</option>
                                <option value="قطاع العقارات">قطاع العقارات</option>
                                <option value="قطاع الأغذية">قطاع الأغذية</option>
                                <option value="قطاع التقنية">قطاع التقنية</option>
                            </select>
                        </div>

                        <!-- Price Range -->
                        <div class="lg:col-span-2 order-3">
                            <select id="price-filter" class="w-full">
                                <option value="">نطاق السعر</option>
                                <option value="0-100">0 - 100 ريال</option>
                                <option value="100-200">100 - 200 ريال</option>
                                <option value="200-500">200 - 500 ريال</option>
                                <option value="500+">أكثر من 500 ريال</option>
                            </select>
                        </div>

                        <!-- Sort By -->
                        <div class="lg:col-span-2 order-4">
                            <select id="sort-filter" class="w-full">
                                <option value="">ترتيب حسب</option>
                                <option value="price-asc">السعر: من الأقل للأعلى</option>
                                <option value="price-desc">السعر: من الأعلى للأقل</option>
                                <option value="ads-desc">الأكثر إعلانات</option>
                            </select>
                        </div>

                        <!-- Reset Button -->
                        <div class="lg:col-span-1 order-5">
                            <button
                                id="reset-filters"
                                type="button"
                                class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 px-5 py-4 border border-gray-200 rounded-lg text-sm font-semibold transition-colors flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8" />
                                    <path d="M3 3v5h5" />
                                </svg>
                            </button>
                        </div>

                    </div>
                </div>

                <!-- Results Count -->
                <div class="mt-4 text-sm text-gray-600 text-start">
                    <span id="results-count">عرض النتائج 1 إلى 4 من 4 إجمالاً شركة</span>
                </div>
            </div>

            <!-- Companies Grid Section -->
            <div>
                <div id="companies-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php
                    $companies = get_companies();
                    foreach ($companies as $company):
                        include 'templates/company-card.php';
                    endforeach;
                    ?>
                </div>
            </div>

            <?php
            // Pagination
            include 'templates/partials/pagination.php'; ?>

        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
