function getImageColor(img, callback) {
    const canvas = document.createElement('canvas');
    const ctx = canvas.getContext('2d');

    const tempImg = new Image();
    tempImg.crossOrigin = 'Anonymous';

    tempImg.onload = function() {
        canvas.width = 50;
        canvas.height = 50;
        ctx.drawImage(tempImg, 0, 0, 50, 50);

        try {
            const imageData = ctx.getImageData(0, 0, 50, 50);
            const data = imageData.data;

            const colorCount = {};
            let dominantColor = {
                r: 255,
                g: 255,
                b: 255
            };
            let maxCount = 0;

            for (let i = 0; i < data.length; i += 8) {
                const r = data[i];
                const g = data[i + 1];
                const b = data[i + 2];
                const a = data[i + 3];

                if (a < 125 || (r > 240 && g > 240 && b > 240)) continue;

                const roundedR = Math.round(r / 10) * 10;
                const roundedG = Math.round(g / 10) * 10;
                const roundedB = Math.round(b / 10) * 10;

                const key = `${roundedR},${roundedG},${roundedB}`;
                colorCount[key] = (colorCount[key] || 0) + 1;

                if (colorCount[key] > maxCount) {
                    maxCount = colorCount[key];
                    dominantColor = {
                        r: roundedR,
                        g: roundedG,
                        b: roundedB
                    };
                }
            }

            callback(dominantColor);

        } catch (e) {
            callback({
                r: 107,
                g: 31,
                b: 49
            });
        }
    };

    tempImg.onerror = function() {
        callback({
            r: 107,
            g: 31,
            b: 49
        });
    };

    tempImg.src = img.src;
}

document.querySelectorAll('.site-card').forEach(function(card) {
    const img = card.querySelector('img');
    if (!img) return;

    getImageColor(img, function(color) {
        card.style.backgroundColor = `rgba(${color.r}, ${color.g}, ${color.b}, 0.055)`;
    });
});