<?php
include 'header.php';
include 'includes/data.php';

$breadcrumb_title = 'إعلانات البيع والشراء';
$breadcrumb_desc  = 'تصفح أحدث إعلانات بيع وشراء الأسهم في الشركات غير المدرجة';
$breadcrumb_current  = 'الإعلانات';
$breadcrumb_bg    = 'bg-[#E5F1FF]';
$breadcrumb_img    = 'default-bg.svg';
$breadcrumb_pb    = 'pb-20';

include 'templates/partials/archive-breadcrumb.php';
?>

<div class="py-16">
    <div class="container">
        <div class="space-y-12">

            <div class="filter-tabs">
                <!-- Filter Tabs -->
                <div class="flex flex-row items-center justify-center gap-2 -mt-24 relative z-[1] bg-white rounded-2xl p-3 max-w-[802px] mx-auto shadow-sm border border-gray-100">

                    <button
                        class="filter-tab w-full flex-1 active bg-primary-500 text-white py-4 rounded-lg text-sm font-semibold hover:opacity-90 transition-all"
                        data-filter="all">
                        جميع الإعلانات
                    </button>

                    <button
                        class="filter-tab w-full flex-1 bg-gray-50 text-gray-800 py-4 rounded-lg text-sm font-semibold hover:bg-gray-100 hover:text-gray-600 transition-colors"
                        data-filter="sell">
                        إعلانات البيع
                    </button>

                    <button
                        class="filter-tab w-full flex-1 bg-gray-50 text-gray-800 py-4 rounded-lg text-sm font-semibold hover:bg-gray-100 hover:text-gray-600 transition-colors"
                        data-filter="buy">
                        إعلانات الشراء
                    </button>

                </div>
            </div>

            <!-- Search & Filter Section -->
            <div>
                <div class="bg-white rounded-2xl p-5 border border-gray-100 shadow-sm">

                    <div class="grid grid-cols-1 lg:grid-cols-12 gap-4">

                        <!-- Search Input -->
                        <div class="lg:col-span-5 order-1">
                            <div class="relative">
                                <input
                                    type="text"
                                    id="search-ads"
                                    placeholder="ابحث عن إعلان..."
                                    class="w-full px-5 py-4 ps-12">
                                <svg class="absolute start-4 top-1/2 -translate-y-1/2 text-gray-400" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                    <path d="M14.4 14.4L10.8533 10.8533" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M6.4 12C9.4928 12 12 9.4928 12 6.4C12 3.3072 9.4928 0.8 6.4 0.8C3.3072 0.8 0.8 3.3072 0.8 6.4C0.8 9.4928 3.3072 12 6.4 12Z" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                        </div>

                        <!-- Sector Type -->
                        <div class="lg:col-span-2 order-2">
                            <select id="sector-filter" class="w-full">
                                <option value="">نوع القطاع</option>
                                <option value="قطاع الصحة">قطاع الصحة</option>
                                <option value="قطاع العقارات">قطاع العقارات</option>
                                <option value="قطاع الأغذية">قطاع الأغذية</option>
                                <option value="قطاع التقنية">قطاع التقنية</option>
                                <option value="شركة">شركة</option>
                                <option value="صندوق استثماري">صندوق استثماري</option>
                            </select>
                        </div>

                        <!-- Price Range -->
                        <div class="lg:col-span-2 order-3">
                            <select id="price-filter" class="w-full">
                                <option value="">نطاق السعر</option>
                                <option value="0-100">0 - 100 ريال</option>
                                <option value="100-200">100 - 200 ريال</option>
                                <option value="200-500">200 - 500 ريال</option>
                                <option value="500+">أكثر من 500 ريال</option>
                            </select>
                        </div>

                        <!-- Sort By -->
                        <div class="lg:col-span-2 order-4">
                            <select id="sort-filter" class="w-full">
                                <option value="">ترتيب حسب</option>
                                <option value="newest">الأحدث</option>
                                <option value="oldest">الأقدم</option>
                                <option value="price-asc">السعر: من الأقل للأعلى</option>
                                <option value="price-desc">السعر: من الأعلى للأقل</option>
                            </select>
                        </div>

                        <!-- Reset Button -->
                        <div class="lg:col-span-1 order-5">
                            <button
                                id="reset-filters"
                                type="button"
                                class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 px-5 py-4 border border-gray-200 rounded-lg text-sm font-semibold transition-colors flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-rotate-ccw-icon lucide-rotate-ccw">
                                    <path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8" />
                                    <path d="M3 3v5h5" />
                                </svg>
                            </button>
                        </div>

                    </div>
                </div>

                <!-- Results Count -->
                <div class="mt-4 text-sm text-gray-600 text-start">
                    <span id="results-count">48 إعلان متاح</span>
                </div>
            </div>


            <!-- Ads Grid Section -->
            <div>
                <div id="ads-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php
                    $ads = get_ads();
                    foreach ($ads as $ad):
                        include 'templates/ad-card.php';
                    endforeach;
                    ?>
                </div>
            </div>

            <?php
            // Pagination
            include 'templates/partials/pagination.php'; ?>

        </div>
    </div>
</div>

<?php include 'footer.php'; ?>