<?php
include 'header.php';
include 'includes/data.php';

// Get ad ID from URL
$ad_id = isset($_GET['id']) ? (int)$_GET['id'] : 1;
$ad = get_ad($ad_id);

// If ad not found, redirect to ads page
if (!$ad) {
    header('Location: ads.php');
    exit;
}

$breadcrumb_current = $ad['name'];
include 'templates/partials/default-breadcrumb.php';
?>

<div class="pt-4 pb-16">
    <div class="container">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">

            <!-- Main Content - Right Side in RTL (8 cols) -->
            <div class="lg:col-span-8 space-y-6">

                <!-- Header with Title & Actions -->
                <div class="flex items-start justify-between">
                    <!-- Badges & Title (End/Right in RTL) -->
                    <div>
                        <!-- Badges -->
                        <div class="flex items-center gap-2 mb-2">
                            <span class="<?php echo $ad['type'] === 'sell' ? 'bg-red-500' : 'bg-primary-500'; ?> text-white text-xs px-3 py-1 rounded-full">
                                <?php echo $ad['type'] === 'sell' ? 'بيع' : 'شراء'; ?>
                            </span>
                            <span class="bg-secondary-500 text-white text-xs px-3 py-1 rounded-full flex items-center gap-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                موثق
                            </span>
                        </div>
                        <h1 class="text-2xl font-bold text-gray-900 mb-2"><?php echo $ad['type'] === 'sell' ? 'بيع' : 'شراء'; ?> أسهم <?php echo $ad['name']; ?></h1>
                        <div class="flex items-center gap-4 text-sm text-gray-500">
                            <span class="flex items-center gap-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                منذ ساعتين
                            </span>
                            <span class="flex items-center gap-1">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                </svg>
                                45 مشاهدة
                            </span>
                            <span class="flex items-center gap-1">
                                #
                                AD-2024-1234
                            </span>
                        </div>
                    </div>
                    <!-- Action Buttons (Start/Left in RTL) -->
                    <div class="flex items-center gap-2">
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                            </svg>
                        </button>
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-50">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" />
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Stats -->
                <div class="grid grid-cols-3 gap-4">
                    <div class="bg-white rounded-xl p-5 text-center border border-gray-100">
                        <p class="text-sm text-gray-600 mb-2">سعر السهم</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="icon-riyal-symbol text-xl text-gray-900"></span>
                            <span class="text-2xl font-bold text-gray-900"><?php echo $ad['price']; ?></span>
                        </div>
                    </div>
                    <div class="bg-primary-50 rounded-xl p-5 text-center border border-primary-100">
                        <p class="text-sm text-gray-600 mb-2">عدد الأسهم</p>
                        <p class="text-2xl font-bold text-primary-600"><?php echo $ad['shares']; ?></p>
                    </div>
                    <div class="bg-secondary-50 rounded-xl p-5 text-center border border-secondary-100">
                        <p class="text-sm text-gray-600 mb-2">إجمالي الصفقة</p>
                        <div class="flex items-center justify-center gap-1">
                            <span class="text-2xl font-bold text-secondary-600">75,000</span>
                            <span class="icon-riyal-symbol text-xl text-secondary-600"></span>
                        </div>
                    </div>
                </div>

                <!-- Description -->
                <div class="bg-white rounded-2xl border border-gray-100 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7" />
                        </svg>
                        <h2 class="text-base font-bold text-gray-900">وصف الإعلان</h2>
                    </div>
                    <p class="text-sm text-gray-700 leading-relaxed">
                        أعرض للبيع 500 سهم من أسهم شركة الوطنية للتقنية. الأسهم مملوكة بالكامل وجاهزة للنقل. السعر المطلوب 150 ريال للسهم الواحد قابل للتفاوض بشكل بسيط للجادين.
                    </p>
                    <p class="text-sm text-gray-700 leading-relaxed mt-4">
                        الشركة حققت نمواً ممتازاً خلال السنوات الأخيرة وتتوقع استمرار النمو مع التوسع في العقود الحكومية.
                    </p>
                </div>

                <!-- Company Info -->
                <div class="bg-white rounded-2xl border border-primary-100 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                        <h2 class="text-base font-bold text-gray-900">معلومات الشركة</h2>
                    </div>
                    <div class="flex items-center gap-4 bg-gray-50 rounded-xl p-4">
                        <div class="w-20 h-20 site-card rounded-xl flex items-center justify-center flex-shrink-0">
                            <?php if (!empty($ad['image']) && file_exists($ad['image'])): ?>
                                <img src="<?php echo $ad['image']; ?>" alt="<?php echo $ad['name']; ?>" class="w-16 h-16 object-contain mix-blend-darken">
                            <?php endif; ?>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-bold text-gray-900 mb-1"><?php echo $ad['name']; ?></h3>
                            <p class="text-sm text-gray-600 mb-2"><?php echo $ad['sector']; ?></p>
                            <div class="flex items-center gap-2">
                                <span class="text-xs text-secondary-600 flex items-center gap-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    موثقة
                                </span>
                                <span class="text-xs text-gray-500">الرياض</span>
                            </div>
                        </div>
                        <button class="w-10 h-10 flex items-center justify-center bg-white border border-gray-200 rounded-lg hover:bg-gray-100">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                        </button>
                    </div>
                </div>

            </div>

            <!-- Sidebar - Left Side in RTL (4 cols) -->
            <div class="lg:col-span-4 space-y-6">

                <!-- Seller Card -->
                <div class="bg-[#E7EFEF] rounded-2xl p-5">
                    <div class="flex items-center gap-4">
                        <img src="images/avatar.jpg" alt="البائع" class="w-20 h-20 rounded-full object-cover border-4 border-white shadow-sm">
                        <div class="flex-1">
                            <h3 class="text-base font-bold text-gray-900 mb-1">محمد عبدالله الشمري</h3>
                            <p class="text-sm text-gray-500 mb-2">عضو منذ 2022</p>
                            <span class="inline-flex items-center gap-1 text-xs text-secondary-600">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-3.5 h-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                موثق
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Calculator -->
                <div class="bg-white rounded-2xl border border-gray-100 p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                        </svg>
                        <span class="text-sm font-bold text-gray-900">احسب تكلفة الشراء</span>
                    </div>

                    <!-- Quantity Label -->
                    <p class="text-sm font-semibold text-gray-900 mb-3">عدد الأسهم المطلوبة</p>

                    <!-- Quantity Input -->
                    <div class="flex items-center border border-gray-200 rounded-lg mb-2">
                        <button id="qty-decrease" type="button" class="w-10 h-12 flex items-center justify-center text-gray-500 hover:bg-gray-50 border-e border-gray-200">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4" />
                            </svg>
                        </button>
                        <input type="number" id="qty-input" value="<?php echo (int)str_replace(',', '', $ad['shares']); ?>" min="100" max="<?php echo (int)str_replace(',', '', $ad['shares']); ?>" class="flex-1 h-12 text-center text-lg font-bold text-gray-900 border-0 focus:ring-0">
                        <button id="qty-increase" type="button" class="w-10 h-12 flex items-center justify-center text-gray-500 hover:bg-gray-50 border-s border-gray-200">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                            </svg>
                        </button>
                    </div>

                    <!-- Range Slider -->
                    <div class="relative mb-1">
                        <input type="range" id="qty-slider" min="100" max="<?php echo (int)str_replace(',', '', $ad['shares']); ?>" value="<?php echo (int)str_replace(',', '', $ad['shares']); ?>" class="w-full h-1.5 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-primary-500">
                    </div>
                    <div class="flex justify-between text-xs text-gray-400 mb-6">
                        <span>الحد الأقصى: <?php echo $ad['shares']; ?></span>
                        <span>الحد الأدنى: 100</span>
                    </div>

                    <!-- Calculations -->
                    <div class="border-t border-gray-100 pt-4 space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">سعر السهم</span>
                            <div class="flex items-center gap-1">
                                <span id="calc-price" class="font-bold text-gray-900"><?php echo $ad['price']; ?></span>
                                <span class="icon-riyal-symbol text-sm text-gray-900"></span>
                            </div>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">عدد الأسهم</span>
                            <span id="calc-qty" class="font-bold text-gray-900"><?php echo $ad['shares']; ?></span>

                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">ضريبة القيمة المضافة (15%)</span>
                            <div class="flex items-center gap-1">
                                <span id="calc-vat" class="font-bold text-gray-900">0</span>
                                <span class="icon-riyal-symbol text-sm text-gray-900"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="border-t border-gray-100 mt-4 pt-4">
                        <div class="flex justify-between items-center">
                            <span class="text-sm font-bold text-gray-900">الإجمالي</span>
                            <div class="flex items-center gap-1">
                                <span id="calc-total" class="text-xl font-bold text-gray-900">0</span>
                                <span class="icon-riyal-symbol text-gray-900"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <button class="w-full bg-primary-500 hover:bg-primary-600 text-white py-4 rounded-xl text-sm font-bold transition-colors flex items-center justify-center gap-2 mt-6">
                        تقديم عرض شراء
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                        </svg>
                    </button>

                    <!-- Trust Badge -->
                    <p class="text-xs text-center text-gray-500 mt-3 flex items-center justify-center gap-1">
                        معاملة آمنة 100% مع ضمان مناقلة
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </p>
                </div>

                <!-- Safety Tips -->
                <div class="bg-primary-50 rounded-2xl p-5">
                    <div class="flex items-center gap-2 mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none">
                            <path d="M11.9982 8.49901C11.9982 11.9984 9.54858 13.7481 6.63707 14.763C6.48461 14.8146 6.319 14.8122 6.16815 14.756C3.24964 13.7481 0.800049 11.9984 0.800049 8.49901V3.59983C0.800049 3.41421 0.873786 3.2362 1.00504 3.10494C1.13629 2.97369 1.31431 2.89995 1.49993 2.89995C2.8997 2.89995 4.6494 2.06009 5.8672 0.99627C6.01547 0.86959 6.20409 0.799988 6.39911 0.799988C6.59413 0.799988 6.78275 0.86959 6.93102 0.99627C8.15582 2.06709 9.89852 2.89995 11.2983 2.89995C11.4839 2.89995 11.6619 2.97369 11.7932 3.10494C11.9244 3.2362 11.9982 3.41421 11.9982 3.59983V8.49901Z" stroke="#3D8FFF" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.36963 5.69946C4.53759 5.23658 4.86289 4.84745 5.28867 4.6001C5.71445 4.35276 6.21362 4.26292 6.69892 4.34631C7.18422 4.42969 7.62477 4.68099 7.94357 5.05627C8.26237 5.43155 8.43913 5.90695 8.44295 6.39934C8.44295 7.79911 6.3433 8.49899 6.3433 8.49899" stroke="#3D8FFF" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M6.39917 11.2985H6.40617" stroke="#3D8FFF" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="text-sm font-bold text-gray-800">نصائح الأمان والسلامة</span>
                    </div>
                    <ul class="space-y-3">
                        <?php
                        $tips = [
                            'تأكد من التحقق من هوية البائع والوثائق الرسمية',
                            'استخدم نظام الضمان المالي في المنصة دائماً',
                            'لا تحول أموالاً خارج المنصة تحت أي ظرف',
                            'راجع جميع مستندات الملكية قبل إتمام الصفقة',
                            'تواصل مع فريق الدعم عند أي استفسار'
                        ];
                        foreach ($tips as $tip):
                        ?>
                            <li class="flex items-center gap-2 text-sm text-gray-700 bg-white rounded-lg px-3 py-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-secondary-500 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span><?php echo $tip; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <!-- Report Button -->
                <div class="bg-red-50 rounded-2xl p-4">
                    <button class="w-full text-red-600 hover:text-red-700 py-2 text-sm font-semibold flex items-center justify-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none">
                            <path d="M0.800049 14.8V2.20005C0.800049 2.09138 0.824899 1.9842 0.87263 1.887C0.920362 1.7898 0.989664 1.70525 1.07505 1.64005C1.78907 1.0948 2.65752 0.800049 3.55005 0.800049C5.61255 0.800049 6.98755 2.20005 8.59149 2.20005C9.50815 2.20005 10.211 2.01338 10.7 1.64005C10.8022 1.56205 10.9236 1.51455 11.0508 1.50288C11.178 1.4912 11.3058 1.51581 11.42 1.57395C11.5342 1.63209 11.6302 1.72145 11.6974 1.83204C11.7645 1.94262 11.8 2.07005 11.8 2.20005V9.20005C11.8 9.30872 11.7752 9.4159 11.7275 9.5131C11.6797 9.6103 11.6104 9.69485 11.525 9.76005C10.811 10.3053 9.94258 10.6 9.05005 10.6C6.98755 10.6 5.61255 9.20005 3.55005 9.20005C2.53538 9.20007 1.55632 9.58088 0.800049 10.2696" stroke="#E52327" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        الإبلاغ عن هذا الإعلان
                    </button>
                </div>

            </div>

        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const qtyInput = document.getElementById('qty-input');
        const qtySlider = document.getElementById('qty-slider');
        const qtyDecrease = document.getElementById('qty-decrease');
        const qtyIncrease = document.getElementById('qty-increase');
        const calcPrice = document.getElementById('calc-price');
        const calcQty = document.getElementById('calc-qty');
        const calcVat = document.getElementById('calc-vat');
        const calcTotal = document.getElementById('calc-total');

        const price = <?php echo (int)str_replace(',', '', $ad['price']); ?>;
        const minQty = 100;
        const maxQty = <?php echo (int)str_replace(',', '', $ad['shares']); ?>;

        function formatNumber(num) {
            return num.toLocaleString('en-US');
        }

        function updateCalculation() {
            let qty = parseInt(qtyInput.value) || minQty;
            qty = Math.max(minQty, Math.min(maxQty, qty));

            qtyInput.value = qty;
            qtySlider.value = qty;

            const subtotal = price * qty;
            const vat = subtotal * 0.15;
            const total = subtotal + vat;

            calcQty.textContent = formatNumber(qty);
            calcVat.textContent = formatNumber(Math.round(vat));
            calcTotal.textContent = formatNumber(Math.round(total));
        }

        qtyInput.addEventListener('input', updateCalculation);
        qtyInput.addEventListener('change', updateCalculation);

        qtySlider.addEventListener('input', function() {
            qtyInput.value = this.value;
            updateCalculation();
        });

        qtyDecrease.addEventListener('click', function() {
            let qty = parseInt(qtyInput.value) || minQty;
            if (qty > minQty) {
                qtyInput.value = qty - 10;
                updateCalculation();
            }
        });

        qtyIncrease.addEventListener('click', function() {
            let qty = parseInt(qtyInput.value) || minQty;
            if (qty < maxQty) {
                qtyInput.value = qty + 10;
                updateCalculation();
            }
        });

        // Initial calculation
        updateCalculation();
    });
</script>

<?php include 'footer.php'; ?>