<!-- ==================== Contact SECTION ==================== -->
<section id="contact" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">

        <div class="container">
            <div class="flex flex-wrap items-center justify-between gap-12">

                <!-- Text Content -->
                <div class="w-full lg:w-5/12 text-start">
                    <div class="relative">
                        <div class="z-10 relative">
                            <div class="lg:mb-8 text-center lg:text-start">
                                <p class="text-primary-600 text-base md:text-lg mb-4">أنضمي الينا</p>
                                <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold text-primary-900 mb-6 !leading-snug">
                                    هل أنتِ مستعدة لتسجيل طفلك؟
                                </h2>
                                <p class="text-gray-700 text-lg">
                                    انضمي إلى عائلة كيان المستقبل ودعي طفلك يستمتع بتجربة فنية فريدة
                                </p>
                            </div>

                            <div class="hidden lg:flex lg:justify-end">
                                <svg class="ltr:rotate-180" xmlns="http://www.w3.org/2000/svg" width="169" height="106" viewBox="0 0 169 106" fill="none">
                                    <path d="M167.35 1.44981C147.447 0.977191 113.637 -2.28111 101.863 19.2288C92.8284 35.733 108.826 51.792 113.725 66.9445C127.141 108.437 40.556 91.2489 21.3311 90.8597C16.3869 90.759 -4.70355 85.2824 2.47974 90.8105C8.96198 95.7984 29.4915 113.954 14.3627 98.0241C10.0329 93.4664 1.89973 92.9819 1.0038 85.6005C0.644302 82.6391 25.7802 71.838 28.8999 72.0275" stroke="#5A0E4C" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                </svg>
                            </div>
                        </div>

                        <svg class="hidden lg:flex absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" xmlns="http://www.w3.org/2000/svg" width="438" height="438" viewBox="0 0 438 438" fill="none">
                            <path d="M29.3448 27.9864L27.9984 29.4445C15.7594 41.6796 7.07296 57.0066 2.86639 73.7903C-1.34061 90.574 -0.909616 108.184 4.11293 124.742C9.1355 141.3 18.5613 156.184 31.3841 167.807C44.2069 179.429 59.946 187.354 76.922 190.735L219.094 219L190.592 76.8896C187.184 59.9653 179.252 44.2801 167.641 31.5004C156.029 18.7205 141.17 9.32366 124.644 4.30815C108.118 -0.707383 90.5407 -1.15414 73.7807 3.01473C57.021 7.18403 41.5917 15.8135 29.3448 27.9864L219.094 219L27.9984 408.667L29.3448 410.013C41.5852 422.247 56.919 430.929 73.7097 435.134C90.5004 439.34 108.118 438.911 124.684 433.888C141.248 428.868 156.139 419.446 167.767 406.629C179.394 393.811 187.322 378.079 190.704 361.11L219.094 219L76.922 247.377C59.946 250.758 44.2069 258.682 31.3841 270.305C18.5613 281.927 9.1355 296.812 4.11293 313.369C-0.909616 329.927 -1.34061 347.538 2.86639 364.321C7.07296 381.105 15.7594 396.432 27.9984 408.667L410.189 29.3324L408.842 27.9864C396.602 15.7522 381.268 7.06972 364.477 2.86494C347.687 -1.33986 330.069 -0.909301 313.504 4.11105C296.939 9.13138 282.048 18.5532 270.421 31.3703C258.793 44.1881 250.865 59.9206 247.483 76.8896L219.094 219L361.265 190.51C378.196 187.103 393.888 179.175 406.673 167.568C419.458 155.961 428.859 141.109 433.877 124.59C438.894 108.072 439.34 90.5022 435.171 73.7496C431 56.9965 422.367 41.574 410.189 29.3324L219.094 219L247.595 361.11C251.004 378.034 258.936 393.719 270.547 406.499C282.159 419.279 297.017 428.675 313.543 433.691C330.069 438.705 347.646 439.156 364.406 434.984C381.166 430.815 396.483 422.186 408.73 410.013L410.077 408.667C422.285 396.429 430.945 381.11 435.133 364.342C439.323 347.574 438.885 329.984 433.863 313.445C428.843 296.907 419.43 282.039 406.626 270.424C393.822 258.809 378.219 250.883 361.265 247.489L219.094 219L29.3448 27.9864Z" fill="url(#paint0_linear_52_1464)" />
                            <defs>
                                <linearGradient id="paint0_linear_52_1464" x1="219" y1="438.001" x2="219" y2="0" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="white" stop-opacity="0" />
                                    <stop offset="1" stop-color="white" stop-opacity="0.8" />
                                </linearGradient>
                            </defs>
                        </svg>
                    </div>
                </div>

                <!-- Form -->
                <div class="w-full lg:w-1/2">
                    <div class="contact-from-wrapper p-8 rounded-[32px] backdrop-blur-sm">
                        <!-- Full Name -->
                        <div class="mb-6">
                            <label for="full-name" class="block text-gray-900 mb-2 text-start">
                                الاسم الكامل <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <input type="text" id="full-name" name="full_name" autocomplete="name" placeholder="أدخل اسمك الكامل" class="w-full text-sm px-4 py-3 rounded-2xl border border-gray-100 bg-white text-start focus:outline-none focus:border-kayan-pink focus:placeholder-transparent">
                                <svg class="absolute end-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                        </div>

                        <!-- Email & Phone Row -->
                        <div class="lg:flex gap-4 mb-6">
                            <div class="flex-1 mb-6 lg:mb-0">
                                <label for="phone" class="block text-gray-900 mb-2 text-start">
                                    رقم الهاتف <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <input type="tel" id="phone" name="phone" autocomplete="tel" placeholder="أدخل رقم الهاتف للتواصل" class="w-full text-sm px-4 py-3 rounded-2xl border border-gray-100 bg-white text-right ltr:text-left focus:outline-none focus:border-kayan-pink focus:placeholder-transparent">
                                    <svg class="absolute end-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-1">
                                <label for="email" class="block text-gray-900 mb-2 text-start">
                                    البريد الإلكتروني <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <input type="email" id="email" name="email" autocomplete="email" placeholder="أدخل بريدك الإلكتروني" class="w-full text-sm px-4 py-3 rounded-2xl border border-gray-100 bg-white text-start focus:outline-none focus:border-kayan-pink focus:placeholder-transparent">
                                    <svg class="absolute end-4 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <!-- Notes -->
                        <div class="mb-6">
                            <label for="notes" class="block text-gray-900 mb-2 text-start">ملاحظة</label>
                            <textarea id="notes" name="notes" rows="4" placeholder="اكتب ملاحظاتك هنا" class="w-full text-sm px-4 py-3 rounded-2xl border border-gray-100 bg-white text-start focus:outline-none focus:border-kayan-pink focus:placeholder-transparent resize-none"></textarea>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="w-full flex items-center justify-center gap-2 px-4 sm:px-6 py-2.5 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#7F1469] hover:to-[#CD23A7] active:scale-[0.97]">
                            سجلي الأن
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
</section>