<!-- ==================== why-us SECTION ==================== -->
<section id="why-us" class="py-12 bg-white">
    <div class="container">

        <div class="flex flex-col lg:flex-row items-center justify-between mb-8 lg:mb-16 gap-4 lg:gap-12">
            <!-- Section Header -->
            <div class="text-center lg:text-start">
                <p class="text-primary-600 text-base md:text-lg mb-4">لماذا تختار كيان؟</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold !leading-snug text-secondary-900">
                    مميزات تجعلنا <span class="text-secondary-800">الأفضل</span>
                </h2>
            </div>

            <div>
                <div class="flex items-center gap-4 animate-float">
                    <svg class="hidden lg:block ltr:rotate-180" xmlns="http://www.w3.org/2000/svg" width="142" height="42" viewBox="0 0 142 42" fill="none">
                        <path d="M139.912 27.7811C128.238 28.5296 115.611 28.2765 108.047 18.1221C105.396 14.5637 100.768 8.61296 103.422 3.88782C106.143 -0.957563 109.837 4.9812 111.645 8.91502C113.597 13.1646 113.782 17.339 111.588 21.6807C105.934 32.8658 87.9472 23.7566 80.294 19.6473C75.7053 17.1834 68.6723 11.0185 68.9869 5.41293C69.3524 -1.09437 75.747 5.71596 76.9819 7.44639C84.7083 18.2732 75.586 28.932 64.8759 31.3397C53.328 33.9357 41.9728 31.8481 30.3838 31.8481C24.2131 31.8481 18.1732 30.8314 11.9962 30.8314C10.2637 30.8314 5.3055 30.3944 6.91414 29.7581C10.9848 28.1477 13.9598 25.0372 17.5927 22.9235C18.9076 22.1584 9.41236 26.6699 7.08538 27.5552C2.66945 29.2353 -0.792144 28.7876 5.25817 31.6221C9.32953 33.53 14.5181 35.9336 16.5646 39.982" stroke="#0D607F" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                    <p class="text-gray-600 text-center lg:text-start lg:max-w-xs">نحن نهتم بأدق التفاصيل لضمان تجربة فريدة لطفلك تجمع بين المتعة والتعلم والأمان</p>
                </div>
            </div>
        </div>

        <!-- why-us Carousel -->
        <div class="relative">
            <!-- Navigation Arrows -->
            <button class="block lg:hidden why-us-swiper-prev group absolute top-1/3 -translate-y-1/3 right-4 z-20 w-11 h-11 rounded-full bg-white flex items-center justify-center border border-gray-200 transition-all duration-300 hover:scale-110 hover:bg-gradient-to-r hover:from-primary-600 hover:to-primary-800 hover:border-transparent" aria-label="الشريحة السابقة">
                <svg class="w-5 h-5 text-gray-800 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                </svg>
            </button>
            <button class="block lg:hidden why-us-swiper-next group absolute top-1/3 -translate-y-1/3 left-4 z-20 w-11 h-11 rounded-full bg-white flex items-center justify-center border border-gray-200 transition-all duration-300 hover:scale-110 hover:bg-gradient-to-r hover:from-primary-600 hover:to-primary-800 hover:border-transparent" aria-label="الشريحة التالية">
                <svg class="w-5 h-5 text-gray-800 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                </svg>
            </button>

            <!-- Swiper Container -->
            <div class="swiper why-us-swiper">
                <div class="swiper-wrapper">

                    <!-- box 1 -->
                    <div class="swiper-slide">
                        <div class="text-center group">
                            <div class="box-mask mx-auto mb-8 relative">
                                <img class="mask mask-1 object-cover" src="dist/images/box-1.webp" width="200" height="200" alt="رعاية شاملة">
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-4">رعاية شاملة</h3>
                            <p class="text-gray-600 text-sm max-w-xs mx-auto">بيئة آمنة وصحية تضمن راحة طفلك واطمئنانك</p>
                        </div>
                    </div>

                    <!-- box 2 -->
                    <div class="swiper-slide">
                        <div class="text-center group">
                            <div class="box-mask mx-auto mb-8 relative">
                                <img class="mask mask-2 object-cover" src="dist/images/box-2.webp" width="200" height="200" alt="تعليم ترفيهي">
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-4">تعليم ترفيهي</h3>
                            <p class="text-gray-600 text-sm max-w-xs mx-auto">مناهج تعليمية مبتكرة تمزج بين المتعة والفائدة</p>
                        </div>
                    </div>

                    <!-- box 3 -->
                    <div class="swiper-slide">
                        <div class="text-center group">
                            <div class="box-mask mx-auto mb-8 relative">
                                <img class="mask mask-3 object-cover" src="dist/images/box-3.webp" width="200" height="200" alt="تنمية مهارات">
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-4">تنمية مهارات</h3>
                            <p class="text-gray-600 text-sm max-w-xs mx-auto">برامج متخصصة لتطوير القدرات الذهنية والحركية</p>
                        </div>
                    </div>

                    <!-- box 4 -->
                    <div class="swiper-slide">
                        <div class="text-center group">
                            <div class="box-mask mx-auto mb-8 relative">
                                <img class="mask mask-4 object-cover" src="dist/images/box-4.webp" width="200" height="200" alt="تغذية صحية">
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-4">تغذية صحية</h3>
                            <p class="text-gray-600 text-sm max-w-xs mx-auto">وجبات متوازنة ومتابعة دقيقة لصحة الطفل</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- why-us Swiper Initialization -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        new Swiper('.why-us-swiper', {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: {
                delay: 4000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.why-us-swiper-next',
                prevEl: '.why-us-swiper-prev',
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 24,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 32,
                },
            },
        });
    });
</script>