<!-- ==================== Services SECTION ==================== -->
<section id="services" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">

        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-8 lg:mb-16">
                <p class="text-primary-600 text-base md:text-lg mb-4">جولة داخل المركز</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold !leading-snug text-primary-900">
                    أركان تعليمية <span class="text-secondary-800">متطورة</span>
                </h2>
            </div>

            <!-- services Carousel -->
            <div class="relative">
                <!-- Navigation Arrows -->
                <button class="services-swiper-prev group absolute top-1/3 -translate-y-1/3 right-4 z-20 w-11 h-11 rounded-full bg-white flex items-center justify-center border border-gray-200 transition-all duration-300 hover:scale-110 hover:bg-gradient-to-r hover:from-primary-600 hover:to-primary-800 hover:border-transparent" aria-label="الشريحة السابقة">
                    <svg class="w-5 h-5 text-gray-800 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
                <button class="services-swiper-next group absolute top-1/3 -translate-y-1/3 left-4 z-20 w-11 h-11 rounded-full bg-white flex items-center justify-center border border-gray-200 transition-all duration-300 hover:scale-110 hover:bg-gradient-to-r hover:from-primary-600 hover:to-primary-800 hover:border-transparent" aria-label="الشريحة التالية">
                    <svg class="w-5 h-5 text-gray-800 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>

                <!-- Swiper Container -->
                <div class="swiper services-swiper">
                    <div class="swiper-wrapper">

                        <!-- Service 1 -->
                        <div class="swiper-slide">
                            <a href="service-theater.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/childrens-corner-theater.webp" class="rounded-full" width="275" height="275" alt="ركن مسرح الطفل">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD23A7" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن مسرح الطفل</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة تفاعلية تنمّي الثقة والتعبير والإبداع من خلال اللعب والتمثيل.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 2 -->
                        <div class="swiper-slide">
                            <a href="service-languages.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/language-learning-corner.webp" class="rounded-full" width="275" height="275" alt="ركن تعلم اللغات">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#2323CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن تعلم اللغات</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">بيئة تعليمية ممتعة تساعد الطفل على اكتساب اللغات وبناء مهارات التواصل.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 3 -->
                        <div class="swiper-slide">
                            <a href="service-drawing-arts.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/drawing-and-arts-corner.webp" class="rounded-full" width="275" height="275" alt="ركن الرسم والفنون">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#23CD9D" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن الرسم والفنون</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة إبداعية تطوّر خيال الطفل وتعزز التعبير الفني بالألوان.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 4 -->
                        <div class="swiper-slide">
                            <a href="service-skills.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/intellectual-skills-corner.webp" class="rounded-full" width="275" height="275" alt="ركن المهارات الفكرية">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#1AAEE6" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن المهارات الفكرية</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">أنشطة ذكية لتنمية التفكير، التركيز، وحل المشكلات بأسلوب ممتع.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 5 -->
                        <div class="swiper-slide">
                            <a href="service-entertainment.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/entertainment-and-play-corner.webp" class="rounded-full" width="275" height="275" alt="ركن الترفيه واللعب">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD7023" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن الترفيه واللعب</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة آمنة تجمع بين اللعب والمتعة وتنمية المهارات.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 6 -->
                        <div class="swiper-slide">
                            <a href="service-kitchen.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/kitchen-and-cooking-corner.webp" class="rounded-full" width="275" height="275" alt="ركن المطبخ والطبخ">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD2323" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن المطبخ والطبخ</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">تجربة تعليمية ممتعة تعزز الاعتماد على النفس والعمل الجماعي.</p>
                                </div>
                            </a>
                        </div>

                        <!-- Service 7 -->
                        <div class="swiper-slide">
                            <a href="service-sports.php" class="block hover:scale-105 transition-transform duration-300">
                                <div class="text-center group">
                                    <div class="service-circle mx-auto mb-8 relative">
                                        <img src="dist/images/childrens-sports-club.webp" class="rounded-full" width="275" height="275" alt="النادي الرياضي للأطفال">
                                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#8623CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                                        </svg>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">النادي الرياضي للأطفال</h3>
                                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">أنشطة حركية تساعد على تقوية الجسم وبناء عادات صحية.</p>
                                </div>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    
</section>

<!-- services Swiper Initialization -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        new Swiper('.services-swiper', {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: {
                delay: 4000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.services-swiper-next',
                prevEl: '.services-swiper-prev',
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 24,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 32,
                },
            },
        });
    });
</script>