<!-- ==================== App SECTION ==================== -->
<section id="app" class="py-12 bg-white">
    <div class="container">

        <!-- App -->
        <div class="flex flex-col lg:flex-row items-center justify-between gap-12">
            <div>
                <div class="text-center lg:text-start">
                    <p class="text-primary-600 text-base md:text-lg mb-4">حمل تطبيق كيان</p>
                    <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold !leading-snug text-secondary-900">
                        تابع يوميات <span class="text-secondary-800">بطلك الصغير</span>
                    </h2>
                    <p class="text-gray-600 text-center lg:text-start mt-6 lg:max-w-lg">تطبيقنا يجعلك قريباً من طفلك دائماً. صور، تقارير يومية، ومتابعة فورية للوجبات والأنشطة بلمسة واحدة.</p>
                    <div class="flex gap-2 justify-center lg:justify-start mt-8">
                        <a href="https://apps.apple.com/tn/app/future-kayan/id6446227208" class="block">
                            <img src="dist/images/apple-app.png" alt="App Store" class="h-14">
                        </a>
                        <a href="https://play.google.com/store/apps/details?id=com.asooltech.futurekyan" class="block">
                            <img src="dist/images/google-app.png" alt="Google Play" class="h-14">
                        </a>
                    </div>
                </div>
            </div>

            <div class="lg:max-w-md">
                <img src="dist/images/app.webp" class="object-contain w-64 lg:w-full lg:h-full lg:object-cover" alt="App">
            </div>
        </div>

        <div class="mt-12 mb-12 text-center">
            <svg class="mx-auto max-w-xs" xmlns="http://www.w3.org/2000/svg" width="390" height="148" viewBox="0 0 390 148" fill="none">
                <path d="M389 2.92627C312.461 -7.07243 245.273 21.9859 202.134 86.7964C180.045 119.979 226.19 172.305 248.036 132.925C268.408 96.2024 204.041 49.8518 176.856 42.6868C117.874 27.1411 60.8812 30.883 1 30.883" stroke="#D1D5DB" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
            </svg>
        </div>

        <!-- Gallery -->

        <div>
            <div class="flex flex-col lg:flex-row lg:items-end justify-between mb-8 lg:mb-16 gap-6 lg:gap-12">

                <!-- Section Header -->
                <div class="text-center lg:text-start">
                    <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold !leading-snug text-secondary-900">
                        لحظات <span class="text-secondary-800">من كيان</span>
                    </h2>
                </div>

                <div>
                    <p class="text-gray-600 text-center lg:text-start lg:max-w-lg">نشارككم أجمل اللحظات التي يعيشها الأطفال داخل أركان كيان التعليمية والترفيهية.</p>
                </div>

                <div class="hidden lg:block">
                    <a href="gallery.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <span class="whitespace-nowrap">عرض المزيد من الصور</span>
                    </a>
                </div>
            </div>


            <div class="grid grid-cols-12 gap-6 items-center">

                <!-- LEFT column with planet below -->
                <div class="col-span-12 lg:col-span-3 flex flex-col gap-6">
                    <!-- LEFT image -->
                    <div class="flex-1 overflow-hidden h-[250px] lg:min-h-[250px]">
                        <img src="dist/images/gallery/img-1.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                    <!-- Planet decoration - hidden on mobile -->
                    <div class="hidden lg:flex justify-center animate-float">
                        <img src="dist/images/kid-planet.png" class="w-20" alt="image" />
                    </div>
                </div>

                <!-- MIDDLE 2x2 grid -->
                <div class="col-span-12 lg:col-span-6 grid grid-cols-1 lg:grid-cols-6 gap-6">
                    <div class="col-span-1 lg:col-span-4 overflow-hidden h-[250px] lg:self-end">
                        <img src="dist/images/gallery/img-2.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                    <div class="col-span-1 lg:col-span-2 overflow-hidden h-[250px] lg:h-[190px] lg:self-end">
                        <img src="dist/images/gallery/img-3.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                    <div class="col-span-1 lg:col-span-2 overflow-hidden h-[250px] lg:h-[190px]">
                        <img src="dist/images/gallery/img-4.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                    <div class="col-span-1 lg:col-span-4 overflow-hidden h-[250px]">
                        <img src="dist/images/gallery/img-5.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                </div>

                <!-- RIGHT column with sun above -->
                <div class="col-span-12 lg:col-span-3 flex flex-col gap-6">
                    <!-- Sun decoration - hidden on mobile -->
                    <div class="hidden lg:flex justify-center animate-float">
                        <img src="dist/images/kids-kindergarten-sunwold.png" class="w-20" alt="image" />
                    </div>
                    <!-- RIGHT image -->
                    <div class="flex-1 overflow-hidden h-[250px] lg:min-h-[250px]">
                        <img src="dist/images/gallery/img-6.webp" class="w-full h-full object-cover rounded-xl" alt="image" />
                    </div>
                </div>

            </div>

        </div>

    </div>
</section>