<?php

// Default values if not set
$breadcrumb_title = $breadcrumb_title ?? 'الصفحة';
$breadcrumb_items = $breadcrumb_items ?? [];
?>

<!-- ==================== BREADCRUMB ==================== -->
<div class="bg-gray-50 py-4">
    <div class="container mx-auto px-4">
        <nav class="flex items-center justify-start gap-2 text-sm">
            <!-- Home Link -->
            <a href="index.php" class="text-gray-600 hover:text-secondary-600 transition-colors flex items-center gap-1">
                <svg class="w-3 h-3" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                </svg>
                <span>الرئيسية</span>
            </a>

            <?php if (!empty($breadcrumb_items)): ?>
                <?php foreach ($breadcrumb_items as $item): ?>
                    <!-- Separator -->
                    <svg class="w-2 h-2 text-gray-400 rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                    <!-- Item -->
                    <a href="<?php echo htmlspecialchars($item['url']); ?>" class="text-gray-600 hover:text-secondary-600 transition-colors">
                        <?php echo htmlspecialchars($item['title']); ?>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>

            <!-- Separator -->
            <svg class="w-3 h-3 text-gray-400 rtl:rotate-180" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
            </svg>

            <!-- Current Page -->
            <span class="text-gray-800 font-bold"><?php echo htmlspecialchars($breadcrumb_title); ?></span>
        </nav>
    </div>
</div>