/** @type {import('tailwindcss').Config} */
module.exports = {
    content: ["./**/*.php", "./src/**/*.js"],
    theme: {
        extend: {
            colors: {
                // Primary Colors (Pink)
                primary: {
                    50: '#FDE9F7',
                    100: '#F9C8EC',
                    200: '#F49ADB',
                    300: '#EE6BC9',
                    400: '#E943BC',
                    500: '#E426B7', // Main primary
                    600: '#CC1FA5',
                    700: '#A61A88',
                    800: '#7F1469',
                    900: '#5A0E4C',
                },

                // Secondary Colors (Blue)
                secondary: {
                    50: '#EAF8FF',
                    100: '#CFF0FF',
                    200: '#9FE3FF',
                    300: '#6ED6FF',
                    400: '#4ACCFF',
                    500: '#2EC6FD', // Main secondary
                    600: '#1AAEE6',
                    700: '#1387B3',
                    800: '#0D607F',
                    900: '#07394D',
                },

                // Gray Colors (Complete Scale)
                gray: {
                    50: '#F9FBFB',
                    100: '#F3F4F6',
                    200: '#E5E7EB',
                    300: '#D1D5DB',
                    400: '#9CA3AF',
                    500: '#6B7280',
                    600: '#6B7280',
                    700: '#374151',
                    800: '#1F2937',
                    900: '#111827',
                    950: '#030712',
                },

                // Semantic Colors
                error: '#d10004',
                success: '#10b981',
                warning: '#f59e0b',
            },
            container: {
                center: true,
                padding: {
                    DEFAULT: '1rem',
                    sm: '1rem',
                    lg: '1rem',
                    xl: '1rem',
                    '2xl': '1rem',
                },
                screens: {
                    lg: '100%',
                    xl: '1280px',
                },
            },
            fontFamily: {
                'zain': ['Zain', 'sans-serif'],
                'somar': ['Somar Sans', 'Tajawal', 'sans-serif'],
            },
            borderRadius: {
                '4xl': '32px',
                '5xl': '100px',
            },
            spacing: {
                '18': '4.5rem',
                '22': '5.5rem',
                '30': '7.5rem',
            },
            fontSize: {
                '4.5xl': '40px',
                '5.5xl': '50px',
                '6xl': '56px',
                '7xl': '60px',
            },
            lineHeight: {
                'tight': '1.1',
                'snug': '1.2',
            },
            letterSpacing: {
                'tight': '-0.03em',
                'tighter': '-1.5px',
                'tightest': '-1.8px',
            },
            boxShadow: {
                'card': '0 4px 20px rgba(0, 0, 0, 0.08)',
                'button': '0 4px 15px rgba(205, 35, 167, 0.3)',
            },
            animation: {
                'float': 'float 3s ease-in-out infinite',
                'fade-in': 'fadeIn 0.5s ease-out',
            },
            keyframes: {
                float: {
                    '0%, 100%': {
                        transform: 'translateY(0)'
                    },
                    '50%': {
                        transform: 'translateY(-10px)'
                    },
                },
                fadeIn: {
                    '0%': {
                        opacity: '0',
                        transform: 'translateY(20px)'
                    },
                    '100%': {
                        opacity: '1',
                        transform: 'translateY(0)'
                    },
                }
            }
        },
    },
    plugins: [
        require('@tailwindcss/typography'),
    ],
}