<?php

/**
 * Services Page Template
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'أركان المركز';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== Services SECTION ==================== -->
<section id="services" class="relative overflow-hidden pt-16 pb-12">

    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-8 lg:mb-16">
            <p class="text-primary-600 text-base md:text-lg mb-4">جولة داخل المركز</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold !leading-snug text-primary-900">
                أركان تعليمية <span class="text-secondary-800">متطورة</span>
            </h2>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-12 lg:gap-16">

            <!-- Service 1 -->
            <a href="service-theater.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/childrens-corner-theater.webp" class="rounded-full" width="275" height="275" alt="ركن مسرح الطفل">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD23A7" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن مسرح الطفل</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة تفاعلية تنمّي الثقة والتعبير والإبداع من خلال اللعب والتمثيل.</p>
                </div>
            </a>

            <!-- Service 2 -->
            <a href="service-languages.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/language-learning-corner.webp" class="rounded-full" width="275" height="275" alt="ركن تعلم اللغات">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#2323CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن تعلم اللغات</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">بيئة تعليمية ممتعة تساعد الطفل على اكتساب اللغات وبناء مهارات التواصل.</p>
                </div>
            </a>

            <!-- Service 3 -->
            <a href="service-drawing-arts.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/drawing-and-arts-corner.webp" class="rounded-full" width="275" height="275" alt="ركن الرسم والفنون">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#23CD9D" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن الرسم والفنون</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة إبداعية تطوّر خيال الطفل وتعزز التعبير الفني بالألوان.</p>
                </div>
            </a>

            <!-- Service 4 -->
            <a href="service-skills.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/intellectual-skills-corner.webp" class="rounded-full" width="275" height="275" alt="ركن المهارات الفكرية">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#1AAEE6" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن المهارات الفكرية</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">أنشطة ذكية لتنمية التفكير، التركيز، وحل المشكلات بأسلوب ممتع.</p>
                </div>
            </a>

            <!-- Service 5 -->
            <a href="service-entertainment.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/entertainment-and-play-corner.webp" class="rounded-full" width="275" height="275" alt="ركن الترفيه واللعب">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD7023" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن الترفيه واللعب</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">مساحة آمنة تجمع بين اللعب والمتعة وتنمية المهارات.</p>
                </div>
            </a>

            <!-- Service 6 -->
            <a href="service-kitchen.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/kitchen-and-cooking-corner.webp" class="rounded-full" width="275" height="275" alt="ركن المطبخ والطبخ">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD2323" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">ركن المطبخ والطبخ</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">تجربة تعليمية ممتعة تعزز الاعتماد على النفس والعمل الجماعي.</p>
                </div>
            </a>

            <!-- Service 7 -->
            <a href="service-sports.php" class="block hover:scale-105 transition-transform duration-300">
                <div class="text-center group">
                    <div class="service-circle mx-auto mb-8 relative">
                        <img src="dist/images/childrens-sports-club.webp" class="rounded-full" width="275" height="275" alt="النادي الرياضي للأطفال">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#8623CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4 group-hover:text-secondary-600 transition-colors">النادي الرياضي للأطفال</h3>
                    <p class="text-gray-600 text-sm mb-6 max-w-xs mx-auto">أنشطة حركية تساعد على تقوية الجسم وبناء عادات صحية.</p>
                </div>
            </a>

        </div>


    </div>


</section>

<!-- services Swiper Initialization -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        new Swiper('.services-swiper', {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: {
                delay: 4000,
                disableOnInteraction: false,
            },
            navigation: {
                nextEl: '.services-swiper-next',
                prevEl: '.services-swiper-prev',
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 24,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 32,
                },
            },
        });
    });
</script>

<?php include 'footer.php'; ?>