<?php

/**
 * Service Page Template - Children's Sports Club
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'النادي الرياضي للأطفال';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="max-w-4xl mx-auto px-4">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div>
                <div class="relative">
                    <div class="service-circle relative">
                        <img src="dist/images/childrens-sports-club.webp" width="275" height="275" alt="النادي الرياضي للأطفال">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#8623CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="text-center lg:text-start">
                <p class="text-primary-600 text-base md:text-lg mb-4">أركان المركز</p>
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                    النادي الرياضي للأطفال
                </h1>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg mb-8">
                    لأجسامٍ أقوى وعقولٍ أذكى .. كيان المستقبل يقدم أكثر من مجرد رياضة
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== INTRO SECTION ==================== -->
<section id="intro" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">النادي الرياضي في كيان</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    أجسام أقوى <span class="text-secondary-800">وعقول أذكى</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    أصبح من الضروري توفير بيئة تعليمية متكاملة تعزز من نمو الأطفال البدني والعقلي. يأتي "كيان المستقبل" ليقدم نموذجًا فريدًا يجمع بين التعليم والترفيه، حيث يوفر نادي رياضي للأطفال يهدف إلى تنمية مهاراتهم الحركية والعقلية منذ الصغر.
                </p>

                <div class="flex flex-row justify-center items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== MOTOR SKILLS SECTION ==================== -->
<section id="motor-skills" class="py-12 bg-white">

    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">المهارات الحركية</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    نادي رياضي للأطفال <span class="text-secondary-800">لتطوير مهاراتهم الحركية من الصغر</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start">
                    تُعد الأنشطة الحركية للأطفال في سن مبكرة أساسًا لتطوير قدراتهم البدنية والعقلية. من خلال التمارين المخصصة، يتم تعزيز تطوير المهارات البدنية مثل التوازن والمرونة والقوة، مما يساهم في بناء أساس قوي لنموهم المستقبلي. بالإضافة إلى ذلك، تسهم هذه الأنشطة في تنمية التنسيق الحركي للأطفال، مما يعزز من قدرتهم على التحكم في حركاتهم وتفاعلهم مع البيئة المحيطة.
                </p>

                <!-- Skills Grid -->
                <div class="grid grid-cols-3 gap-4 mt-6">
                    <div class="bg-purple-50 rounded-2xl p-6 text-center">
                        <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-6">التوازن</h3>
                    </div>
                    <div class="bg-pink-50 rounded-2xl p-6 text-center">
                        <div class="w-12 h-12 rounded-full bg-pink-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-pink-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-6">المرونة</h3>
                    </div>
                    <div class="bg-blue-50 rounded-2xl p-6 text-center">
                        <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.59 14.37a6 6 0 01-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 006.16-12.12A14.98 14.98 0 009.631 8.41m5.96 5.96a14.926 14.926 0 01-5.841 2.58m-.119-8.54a6 6 0 00-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 00-2.58 5.84m2.699 2.7c-.103.021-.207.041-.311.06a15.09 15.09 0 01-2.448-2.448 14.9 14.9 0 01.06-.312m-2.24 2.39a4.493 4.493 0 00-1.757 4.306 4.493 4.493 0 004.306-1.758M16.5 9a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-6">القوة</h3>
                    </div>
                </div>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/childrens-sports-club.webp" width="275" height="275" alt="النادي الرياضي للأطفال">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#8623CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== GROWTH SECTION ==================== -->
<section id="growth" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">النمو الشامل</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    كيف يساهم النادي الرياضي <span class="text-secondary-800">في نمو طفلك العقلي والبدني؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mt-6 max-w-4xl mx-auto">
                    لا يقتصر دور النادي الرياضي للأطفال على الجانب البدني فحسب، بل يمتد ليشمل التطوير العقلي والاجتماعي.
                </p>
            </div>

            <!-- Benefits Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Benefit 1 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-purple-500 to-violet-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m.94 3.198l.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0112 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 016 18.719m12 0a5.971 5.971 0 00-.941-3.197m0 0A5.995 5.995 0 0012 12.75a5.995 5.995 0 00-5.058 2.772m0 0a3 3 0 00-4.681 2.72 8.986 8.986 0 003.74.477m.94-3.197a5.971 5.971 0 00-.94 3.197M15 6.75a3 3 0 11-6 0 3 3 0 016 0zm6 3a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0zm-13.5 0a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">التفاعل مع الأقران</h3>
                    <p class="text-gray-600 text-sm">يتعلم الأطفال مهارات التواصل والعمل الجماعي من خلال المشاركة في الأنشطة الجماعية.</p>
                </div>

                <!-- Benefit 2 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-pink-500 to-rose-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">الثقة بالنفس</h3>
                    <p class="text-gray-600 text-sm">تعزز الأنشطة الرياضية من ثقة الأطفال بأنفسهم وقدرتهم على التفاعل الاجتماعي.</p>
                </div>

                <!-- Benefit 3 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 18v-5.25m0 0a6.01 6.01 0 001.5-.189m-1.5.189a6.01 6.01 0 01-1.5-.189m3.75 7.478a12.06 12.06 0 01-4.5 0m3.75 2.383a14.406 14.406 0 01-3 0M14.25 18v-.192c0-.983.658-1.823 1.508-2.316a7.5 7.5 0 10-7.517 0c.85.493 1.509 1.333 1.509 2.316V18"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">تحسين التركيز</h3>
                    <p class="text-gray-600 text-sm">ممارسة الرياضة تساعد في تحسين التركيز والانتباه لدى الأطفال.</p>
                </div>

                <!-- Benefit 4 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">الأداء الأكاديمي</h3>
                    <p class="text-gray-600 text-sm">التركيز والانتباه المحسن ينعكس إيجابًا على الأداء الأكاديمي للأطفال.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== SAFE ACTIVITIES SECTION ==================== -->
<section id="safe-activities" class="py-12 bg-white">
    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div class="order-2 lg:order-1">
                <div class="service-circle relative">
                    <img src="dist/images/childrens-sports-club.webp" width="275" height="275" alt="النادي الرياضي للأطفال">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#8623CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

            <!-- Content -->
            <div class="order-1 lg:order-2">
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">أنشطة آمنة</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    أنشطة رياضية ممتعة وآمنة <span class="text-secondary-800">تحفز نمو طفلك</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base mb-6 leading-relaxed text-center lg:text-start">
                    يقدم "كيان المستقبل" مجموعة متنوعة من الأنشطة البدنية للأطفال في سن مبكرة، مصممة خصيصًا لتكون ممتعة وآمنة. تشمل هذه الأنشطة تمارين وألعاب تفاعلية تهدف إلى تنمية مهارات الأطفال عبر الرياضة، مع التركيز على الجوانب التعليمية والتربوية.
                </p>

                <!-- Features -->
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-6">
                    <div class="flex items-center gap-3 bg-purple-50 rounded-xl p-4">
                        <div class="w-10 h-10 rounded-full bg-purple-100 flex items-center justify-center flex-shrink-0">
                            <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z"></path>
                            </svg>
                        </div>
                        <span class="font-medium text-gray-900 text-sm">بيئة آمنة ومحفزة</span>
                    </div>
                    <div class="flex items-center gap-3 bg-blue-50 rounded-xl p-4">
                        <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center flex-shrink-0">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z"></path>
                            </svg>
                        </div>
                        <span class="font-medium text-gray-900 text-sm">مدربين متخصصين</span>
                    </div>
                    <div class="flex items-center gap-3 bg-green-50 rounded-xl p-4">
                        <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center flex-shrink-0">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"></path>
                            </svg>
                        </div>
                        <span class="font-medium text-gray-900 text-sm">أنشطة تعليمية وتربوية</span>
                    </div>
                    <div class="flex items-center gap-3 bg-pink-50 rounded-xl p-4">
                        <div class="w-10 h-10 rounded-full bg-pink-100 flex items-center justify-center flex-shrink-0">
                            <svg class="w-5 h-5 text-pink-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.182 15.182a4.5 4.5 0 01-6.364 0M21 12a9 9 0 11-18 0 9 9 0 0118 0zM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75zm-.375 0h.008v.015h-.008V9.75zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75zm-.375 0h.008v.015h-.008V9.75z"></path>
                            </svg>
                        </div>
                        <span class="font-medium text-gray-900 text-sm">التعلم من خلال اللعب</span>
                    </div>
                </div>

                <p class="text-gray-700 text-sm sm:text-base leading-relaxed text-center lg:text-start">
                    تشرف على هذه الأنشطة مجموعة من المدربين المتخصصين الذين يضمنون سلامة الأطفال ويشجعونهم على الاستمتاع بالتعلم من خلال اللعب.
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- ==================== WHY KAYAN SECTION ==================== -->
<section id="why-kayan" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">لماذا كيان؟</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    ليه تختار كيان المستقبل <span class="text-secondary-800">أفضل نادي</span>
                </h2>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Feature 1 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-purple-500 to-violet-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">برامج رياضية مصممة بعناية</h3>
                    <p class="text-gray-600 text-sm">برامج تناسب مختلف الأعمار والقدرات لضمان تطور كل طفل.</p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">بيئة تعليمية آمنة ومحفزة</h3>
                    <p class="text-gray-600 text-sm">بيئة تشجع الأطفال على الاستكشاف والتعلم بأمان تام.</p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">فريق مدربين مؤهلين</h3>
                    <p class="text-gray-600 text-sm">مدربون يراعون احتياجات كل طفل بشكل فردي ومتخصص.</p>
                </div>

                <!-- Feature 4 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-orange-500 to-red-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">تركيز على القيم التربوية</h3>
                    <p class="text-gray-600 text-sm">التعاون والانضباط والاحترام قيم أساسية في برامجنا.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== VARIOUS ACTIVITIES SECTION ==================== -->
<section id="various-activities" class="py-12 bg-white">
    <div class="container">
        <div class="max-w-4xl mx-auto text-center">
            <p class="text-primary-600 text-base md:text-lg mb-4">أنشطة متنوعة</p>
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                أنشطة رياضية متنوعة <span class="text-secondary-800">تناسب جميع اهتمامات أطفالك</span>
            </h2>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed mb-8">
                في "كيان المستقبل"، ندرك أن لكل طفل اهتماماته الخاصة، لذا نقدم مجموعة واسعة من الأنشطة لتلبية هذه الاهتمامات:
            </p>

            <!-- Activities Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-3xl p-8 text-center">
                    <div class="w-16 h-16 rounded-full bg-gradient-to-r from-purple-500 to-violet-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m.94 3.198l.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0112 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 016 18.719m12 0a5.971 5.971 0 00-.941-3.197m0 0A5.995 5.995 0 0012 12.75a5.995 5.995 0 00-5.058 2.772m0 0a3 3 0 00-4.681 2.72 8.986 8.986 0 003.74.477m.94-3.197a5.971 5.971 0 00-.94 3.197M15 6.75a3 3 0 11-6 0 3 3 0 016 0zm6 3a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0zm-13.5 0a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">أنشطة جماعية</h3>
                    <p class="text-gray-600">تعزز من العمل الجماعي والتعاون بين الأطفال وتنمي مهاراتهم الاجتماعية.</p>
                </div>

                <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-3xl p-8 text-center">
                    <div class="w-16 h-16 rounded-full bg-gradient-to-r from-blue-500 to-cyan-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-3">برامج تطوير المهارات الفردية</h3>
                    <p class="text-gray-600">برامج خاصة لتطوير قدرات كل طفل بشكل فردي حسب احتياجاته ومستواه.</p>
                </div>
            </div>

            <p class="text-gray-700 text-sm sm:text-base leading-relaxed">
                تهدف هذه الأنشطة إلى توفير تجربة شاملة تساعد الأطفال على النمو والتطور في جميع الجوانب.
            </p>
        </div>
    </div>
</section>

<!-- ==================== CTA SECTION ==================== -->
<section id="cta" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">سجلي الآن</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    سجّل طفلك اليوم <span class="text-secondary-800">في أفضل نادي رياضي للأطفال</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed mb-8">
                    انضم إلى "كيان المستقبل" وامنح طفلك الفرصة للاستفادة من بيئة تعليمية متكاملة تجمع بين الرياضة والتعلم. من خلال برامجنا المصممة بعناية، سيتمكن طفلك من تطوير مهاراته البدنية والعقلية في جو من المرح والأمان. لا تفوت هذه الفرصة، وسجل طفلك اليوم لتكون جزءًا من رحلتنا نحو بناء جيل قوي وواعٍ.
                </p>

                <div class="flex flex-row justify-center items-stretch gap-3">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">سجل طفلك اليوم</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-12 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== FAQ SECTION ==================== -->
<section id="faq" class="py-12 bg-white">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-10">
            <p class="text-primary-600 text-base md:text-lg mb-4">الأسئلة الشائعة</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                أسئلة <span class="text-secondary-800">شائعة</span>
            </h2>
        </div>

        <!-- FAQ Items -->
        <div class="max-w-3xl mx-auto space-y-4">
            <!-- FAQ Item 1 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">وش الفائدة من تسجيل الطفل في نادي رياضي من عمر مبكر؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        الفائدة كبيرة! النادي يساعد في تطوير المهارات الحركية، يبني الثقة بالنفس، يحفز النشاط الذهني، وينمّي مهارات التواصل الاجتماعي عند الطفل، غير إنه يعزز نمط الحياة الصحي من بدري.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">هل الرياضة ممكن تأثر إيجابيًا على تحصيل الطفل الدراسي؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        نعم. الأبحاث تثبت إن الأطفال اللي يمارسون الرياضة بشكل منتظم عندهم تركيز أفضل، ذاكرتهم أقوى، ونشاطهم في الصف أعلى، لأن الرياضة تحفّز الدورة الدموية وتنشّط الدماغ.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">وش أفضل أنواع الرياضات للأطفال؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        يعتمد على عمر الطفل واهتماماته، لكن بشكل عام الرياضات اللي تشمل الجري، القفز، التوازن، والمرونة مثل الجمباز، السباحة، الكاراتيه، والأنشطة الجماعية مثل كرة القدم ممتازة لبناء المهارات الاجتماعية والحركية.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">هل من الأفضل يشارك الطفل في رياضة فردية أو جماعية؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        كل نوع له فوائده. الرياضات الفردية تعزز التركيز والتحكم بالنفس، والرياضات الجماعية تبني روح الفريق والتعاون. الأفضل هو التنويع بينهم حسب شخصية الطفل.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 5 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">كم مرة بالأسبوع يفضل يشارك الطفل في نشاط رياضي؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        من مرتين إلى ثلاث مرات بالأسبوع يعتبر ممتاز، على حسب عمر الطفل وجدول الأسرة. الأهم يكون النشاط منتظم وممتع للطفل علشان يستمر فيه.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Toggle Script -->
<script>
    function toggleFaq(button) {
        const content = button.nextElementSibling;
        const icon = button.querySelector('.faq-icon');

        // Toggle content visibility
        content.classList.toggle('hidden');

        // Rotate icon
        icon.classList.toggle('rotate-180');
    }
</script>

<?php include 'footer.php'; ?>
