<?php

/**
 * Service Page Template - Intellectual Skills Corner
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'ركن المهارات الفكرية';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="max-w-4xl mx-auto px-4">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div>
                <div class="relative">
                    <div class="service-circle relative">
                        <img src="dist/images/intellectual-skills-corner.webp" width="275" height="275" alt="ركن المهارات الفكرية">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#1AAEE6" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="text-center lg:text-start">
                <p class="text-primary-600 text-base md:text-lg mb-4">أركان المركز</p>
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                    ركن المهارات الفكرية
                </h1>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg mb-8">
                    من اللعب إلى التفكير.. تنمية مهارات التفكير عند الأطفال في مركز كيان
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== INTRO SECTION ==================== -->
<section id="intro" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">المهارات الفكرية في كيان</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    أساس التفكير <span class="text-secondary-800">والقدرات العقلية</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    تعد مرحلة الطفولة من أهم مراحل النمو العقلي والمعرفي، حيث يتشكل خلالها أساس التفكير والقدرات العقلية التي سترافق الطفل طوال حياته. ولتحقيق تنمية مهارات التفكير عند الأطفال، يمكن الجمع بين اللعب والتعلم في بيئة تعليمية محفزة.
                </p>

                <div class="flex flex-row justify-center items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== LEARNING ENVIRONMENT SECTION ==================== -->
<section id="learning-environment" class="py-12 bg-white">

    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">بيئة تعليمية محفزة</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    كيفية تنمية مهارات التفكير <span class="text-secondary-800">من خلال بيئة تعليمية محفّزة؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start mb-6">
                    تعتبر البيئة التعليمية المحفزة حجر الزاوية في تطوير مهارات التفكير لدى الأطفال. لتحقيق ذلك، ينصح بما يلي:
                </p>

                <ul class="space-y-4">
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #1AAEE620">
                            <svg class="w-4 h-4" style="color: #1AAEE6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">توفير موارد تعليمية متنوعة:</span>
                            <span class="text-gray-700"> استخدام الكتب، الألعاب التعليمية، والأدوات التي تشجع على التفكير الإبداعي.</span>
                        </div>
                    </li>
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #1AAEE620">
                            <svg class="w-4 h-4" style="color: #1AAEE6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">تخصيص وقت للأنشطة الإبداعية:</span>
                            <span class="text-gray-700"> مثل الرسم والتلوين والأنشطة الفنية التي تحفز الخيال وتطوير التفكير الإبداعي.</span>
                        </div>
                    </li>
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #1AAEE620">
                            <svg class="w-4 h-4" style="color: #1AAEE6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">تشجيع الاستكشاف والفضول:</span>
                            <span class="text-gray-700"> طرح أسئلة مفتوحة تدفع الطفل للتفكير والتحليل، مثل: "ماذا تعتقد سيحدث إذا فعلنا ذلك؟"</span>
                        </div>
                    </li>
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #1AAEE620">
                            <svg class="w-4 h-4" style="color: #1AAEE6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">تنظيم أنشطة جماعية:</span>
                            <span class="text-gray-700"> الأنشطة التي تتطلب التعاون والمشاركة تعزز من مهارات التفكير الاجتماعي وحل المشكلات.</span>
                        </div>
                    </li>
                </ul>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/intellectual-skills-corner.webp" width="275" height="275" alt="ركن المهارات الفكرية">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#1AAEE6" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== SMART ACTIVITIES SECTION ==================== -->
<section id="smart-activities" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">أنشطة ذكية</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    تعزيز تركيز <span class="text-secondary-800">وذكاء الأطفال</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mt-6">
                    اكتشف طريقتنا الخاصة في تنمية قدرات طفلك من خلال أنشطة ذكية ومتنوعة
                </p>
            </div>

            <!-- Activities Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Activity 1 -->
                <div class="bg-white/80 rounded-2xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-14 h-14 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M14.25 6.087c0-.355.186-.676.401-.959.221-.29.349-.634.349-1.003 0-1.036-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003.215.283.401.604.401.959v0a.64.64 0 01-.657.643 48.39 48.39 0 01-4.163-.3c.186 1.613.293 3.25.315 4.907a.656.656 0 01-.658.663v0c-.355 0-.676-.186-.959-.401a1.647 1.647 0 00-1.003-.349c-1.036 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349.283-.215.604-.401.959-.401v0c.31 0 .555.26.532.57a48.039 48.039 0 01-.642 5.056c1.518.19 3.058.309 4.616.354a.64.64 0 00.657-.643v0c0-.355-.186-.676-.401-.959a1.647 1.647 0 01-.349-1.003c0-1.035 1.008-1.875 2.25-1.875 1.243 0 2.25.84 2.25 1.875 0 .369-.128.713-.349 1.003-.215.283-.4.604-.4.959v0c0 .333.277.599.61.58a48.1 48.1 0 005.427-.63 48.05 48.05 0 00.582-4.717.532.532 0 00-.533-.57v0c-.355 0-.676.186-.959.401-.29.221-.634.349-1.003.349-1.035 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.37 0 .713.128 1.003.349.283.215.604.401.96.401v0a.656.656 0 00.658-.663 48.422 48.422 0 00-.37-5.36c-1.886.342-3.81.574-5.766.689a.578.578 0 01-.61-.58v0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">ألعاب الألغاز والتركيب</h3>
                    <p class="text-gray-600 text-sm">مثل تركيب المكعبات وبناء الأشكال، تُنمّي مهارات التفكير المنطقي وحل المشكلات.</p>
                </div>

                <!-- Activity 2 -->
                <div class="bg-white/80 rounded-2xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-14 h-14 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">القصص التفاعلية</h3>
                    <p class="text-gray-600 text-sm">قراءة القصص مع الطفل ومناقشتها تعزز من التفكير الإبداعي والتحليلي.</p>
                </div>

                <!-- Activity 3 -->
                <div class="bg-white/80 rounded-2xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-14 h-14 rounded-full bg-green-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.75 3.104v5.714a2.25 2.25 0 01-.659 1.591L5 14.5M9.75 3.104c-.251.023-.501.05-.75.082m.75-.082a24.301 24.301 0 014.5 0m0 0v5.714c0 .597.237 1.17.659 1.591L19.8 15.3M14.25 3.104c.251.023.501.05.75.082M19.8 15.3l-1.57.393A9.065 9.065 0 0112 15a9.065 9.065 0 00-6.23-.693L5 14.5m14.8.8l1.402 1.402c1.232 1.232.65 3.318-1.067 3.611A48.309 48.309 0 0112 21c-2.773 0-5.491-.235-8.135-.687-1.718-.293-2.3-2.379-1.067-3.61L5 14.5"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">التجارب العلمية البسيطة</h3>
                    <p class="text-gray-600 text-sm">إجراء تجارب علمية آمنة تحفز الفضول والتفكير التحليلي لدى الأطفال.</p>
                </div>

                <!-- Activity 4 -->
                <div class="bg-white/80 rounded-2xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-14 h-14 rounded-full bg-orange-100 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-7 h-7 text-orange-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">الأنشطة البدنية والرياضية</h3>
                    <p class="text-gray-600 text-sm">تحسن التركيز والانتباه، مما ينعكس إيجابًا على القدرات الفكرية.</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== WHAT WE OFFER SECTION ==================== -->
<section id="what-we-offer" class="py-12 bg-white">
    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div class="order-2 lg:order-1">
                <div class="service-circle relative">
                    <img src="dist/images/intellectual-skills-corner.webp" width="275" height="275" alt="ركن المهارات الفكرية">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#1AAEE6" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

            <!-- Content -->
            <div class="order-1 lg:order-2">
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">ماذا نقدم؟</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    خطوتك الأولى لبناء <span class="text-secondary-800">عقلية مبدعة</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base mb-6 leading-relaxed text-center lg:text-start">
                    في ركن المهارات الفكرية، نركز على تنمية التفكير التحليلي عند الأطفال بطريقة ممتعة وفعالة. نقدّم مجموعة متنوعة من الأنشطة التي تشجع على التفكير المنظم:
                </p>

                <!-- Features Grid -->
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
                    <div class="bg-blue-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">الألعاب الذكية والألغاز</h3>
                        <p class="text-gray-600 text-xs">تعزز مهارات حل المشكلات</p>
                    </div>

                    <div class="bg-green-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m.94 3.198l.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0112 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 016 18.719m12 0a5.971 5.971 0 00-.941-3.197m0 0A5.995 5.995 0 0012 12.75a5.995 5.995 0 00-5.058 2.772m0 0a3 3 0 00-4.681 2.72 8.986 8.986 0 003.74.477m.94-3.197a5.971 5.971 0 00-.94 3.197M15 6.75a3 3 0 11-6 0 3 3 0 016 0zm6 3a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0zm-13.5 0a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">الأنشطة التعاونية</h3>
                        <p class="text-gray-600 text-xs">تنمي العمل الجماعي</p>
                    </div>

                    <div class="bg-purple-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">التدريب على اتخاذ القرارات</h3>
                        <p class="text-gray-600 text-xs">تفكير منظم ومدروس</p>
                    </div>
                </div>

                <p class="text-gray-700 text-sm sm:text-base leading-relaxed text-center lg:text-start">
                    هذه الأنشطة تهدف إلى تحفيز عقول الأطفال وتزويدهم بالأدوات اللازمة لمواجهة تحديات المستقبل بثقة وإبداع.
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- ==================== WHY KAYAN SECTION ==================== -->
<section id="why-kayan" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">لماذا كيان؟</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    ليش تختار كيان المستقبل <span class="text-secondary-800">لتنمية ذكاء طفلك؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mt-6">
                    مركز كيان المستقبل يعد وجهتك المثالية لتنمية مهارات التفكير والذكاء لدى طفلك
                </p>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Feature 1 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">بيئة تعليمية متجددة</h3>
                    <p class="text-gray-600 text-sm">نوفر بيئة تربوية تواكب أحدث التطورات العلمية والتربوية، تحفز الإبداع والتعلم المستمر.</p>
                </div>

                <!-- Feature 2 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-purple-500 to-pink-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">أنشطة متنوعة ومبتكرة</h3>
                    <p class="text-gray-600 text-sm">نقدّم برامج تعليمية تجمع بين التربية والتعلم والإبداع، تُناسب اهتمامات وقدرات الأطفال.</p>
                </div>

                <!-- Feature 3 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">فريق عمل مؤهل</h3>
                    <p class="text-gray-600 text-sm">يضم المركز مختصين في التربية والتعليم يعملون على تقديم أفضل الأساليب والبرامج.</p>
                </div>

                <!-- Feature 4 -->
                <div class="bg-white/80 rounded-3xl p-6 text-center transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-orange-500 to-red-500 flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 mb-2">تعاون مع الأهل</h3>
                    <p class="text-gray-600 text-sm">نؤمن بأهمية الشراكة مع الأهل في عملية التعليم، ونحرص على إشراكهم في تقدم أبنائهم.</p>
                </div>
            </div>

            <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mt-10 text-center max-w-4xl mx-auto">
                باختيارك كيان المستقبل، تضمن لطفلك بيئة تعليمية تعزز من قدراته الفكرية وتعده لمستقبل مشرق.
            </p>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== FAQ SECTION ==================== -->
<section id="faq" class="py-12 bg-white">

    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-10">
            <p class="text-primary-600 text-base md:text-lg mb-4">الأسئلة الشائعة</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                أسئلة <span class="text-secondary-800">شائعة</span>
            </h2>
        </div>

        <!-- FAQ Items -->
        <div class="max-w-3xl mx-auto space-y-4">
            <!-- FAQ Item 1 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">ما هي مهارات التفكير عند الأطفال؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        مهارات التفكير عند الأطفال هي القدرات التي تمكنهم من معالجة المعلومات، والتحليل، والتقييم، واتخاذ القرارات. تشمل هذه المهارات التفكير الإبداعي، وحل المشكلات، والتخطيط، والتنظيم.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">ما هي طرق تنمية مهارات الطفل؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal mb-3">يمكن تنمية مهارات الطفل من خلال:</p>
                    <ul class="text-secondary-900 text-sm leading-normal space-y-2">
                        <li><strong>التعلم عن طريق اللعب:</strong> استخدام الألعاب التعليمية والأنشطة الترفيهية التي تُحفّز التفكير.</li>
                        <li><strong>طرح أسئلة مفتوحة:</strong> تشجيع الطفل على التفكير والتحليل من خلال أسئلة تتطلب تفكيرًا عميقًا.</li>
                        <li><strong>توفير بيئة غنية بالمعلومات:</strong> تقديم موارد تعليمية متنوعة تُحفّز الفضول والتعلم.</li>
                        <li><strong>تعليم حل المشكلات:</strong> مساعدة الطفل على مواجهة التحديات وإيجاد حلول مبتكرة.</li>
                    </ul>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">ما هي المهارات الفكرية؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        المهارات الفكرية هي القدرات العقلية التي يستخدمها الفرد في التفكير، والتحليل، والتقييم، واتخاذ القرارات. تشمل هذه المهارات القدرة على التفكير المنطقي والإبداعي والنقدي.
                    </p>
                </div>
            </div>
        </div>
    </div>

</section>

<?php include 'footer.php'; ?>