<?php

/**
 * Service Page Template - Language Learning Corner
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'ركن تعلم اللغات';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="max-w-4xl mx-auto px-4">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div>
                <div class="relative">
                    <div class="service-circle relative">
                        <img src="dist/images/language-learning-corner.webp" width="275" height="275" alt="ركن تعلم اللغات">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#2323CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="text-center lg:text-start">
                <p class="text-primary-600 text-base md:text-lg mb-4">أركان المركز</p>
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                    ركن تعلم اللغات
                </h1>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg mb-8">
                    بناء جسور التواصل .. كيف تمكن اللغات طفلك من استكشاف الثقافات؟
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== INTRO SECTION ==================== -->
<section id="intro" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">تعلم اللغات في كيان</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    جسر يربط الأطفال <span class="text-secondary-800">بثقافات العالم</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    في عالمٍ يتسم بالتنوع والتواصل المستمر، يعتبر تعلم اللغات جسرًا حيويًا يربط الأطفال بثقافات العالم المختلفة. يسهم إتقان لغة جديدة في توسيع آفاق الطفل، وتعزيز فهمه واحترامه للتنوع الثقافي، وسنكتشف سويًا كيف يمكن لتعلم اللغات أن يكون تجربة ممتعة وفعالة للأطفال، مع التركيز على الأساليب التفاعلية والفوائد المتعددة لبدء هذه الرحلة في سن مبكرة.
                </p>

                <div class="flex flex-row justify-center items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== FUN LEARNING ==================== -->
<section id="fun-learning" class="py-12 bg-white">

    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">تعلم بمتعة</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    تعلم اللغات للأطفال <span class="text-secondary-800">بسهولة ومتعة</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start">
                    يعد تقديم اللغات للأطفال بطريقة مرحة وتفاعلية أمرًا أساسيًا لجعل عملية التعلم ممتعة وفعّالة. الأساليب التقليدية قد تكون مملة أو معقدة للأطفال، لذا من الأفضل استخدام تقنيات تدمج بين التعلم واللعب.
                </p>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start mt-4">
                    على سبيل المثال، يمكن استخدام الألعاب التفاعلية، الأغاني، والقصص المصورة لتقديم المفردات والتراكيب اللغوية بطريقة جذابة. تظهر الدراسات أن الأطفال يتعلمون بشكل أفضل عندما يكونون مستمتعين ومشاركين بنشاط في العملية التعليمية.
                </p>

                <!-- Skills Grid -->
                <div class="grid grid-cols-3 gap-4 mt-6">
                    <div class="bg-blue-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M14.25 6.087c0-.355.186-.676.401-.959.221-.29.349-.634.349-1.003 0-1.036-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003.215.283.401.604.401.959v0a.64.64 0 01-.657.643 48.39 48.39 0 01-4.163-.3c.186 1.613.293 3.25.315 4.907a.656.656 0 01-.658.663v0c-.355 0-.676-.186-.959-.401a1.647 1.647 0 00-1.003-.349c-1.036 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349.283-.215.604-.401.959-.401v0c.31 0 .555.26.532.57a48.039 48.039 0 01-.642 5.056c1.518.19 3.058.309 4.616.354a.64.64 0 00.657-.643v0c0-.355-.186-.676-.401-.959a1.647 1.647 0 01-.349-1.003c0-1.035 1.008-1.875 2.25-1.875 1.243 0 2.25.84 2.25 1.875 0 .369-.128.713-.349 1.003-.215.283-.4.604-.4.959v0c0 .333.277.599.61.58a48.1 48.1 0 005.427-.63 48.05 48.05 0 00.582-4.717.532.532 0 00-.533-.57v0c-.355 0-.676.186-.959.401-.29.221-.634.349-1.003.349-1.035 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.37 0 .713.128 1.003.349.283.215.604.401.96.401v0a.656.656 0 00.658-.663 48.422 48.422 0 00-.37-5.36c-1.886.342-3.81.574-5.766.689a.578.578 0 01-.61-.58v0z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-4">ألعاب تفاعلية</h3>
                    </div>
                    <div class="bg-indigo-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-indigo-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 9l10.5-3m0 6.553v3.75a2.25 2.25 0 01-1.632 2.163l-1.32.377a1.803 1.803 0 11-.99-3.467l2.31-.66a2.25 2.25 0 001.632-2.163zm0 0V2.25L9 5.25v10.303m0 0v3.75a2.25 2.25 0 01-1.632 2.163l-1.32.377a1.803 1.803 0 01-.99-3.467l2.31-.66A2.25 2.25 0 009 15.553z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-4">أغاني مرحة</h3>
                    </div>
                    <div class="bg-purple-50 rounded-2xl p-4 text-center">
                        <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-2">
                            <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 text-sm mt-4">قصص مصورة</h3>
                    </div>
                </div>

            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/language-learning-corner.webp" width="275" height="275" alt="ركن تعلم اللغات">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#2323CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

        </div>
    </div>

</section>

<!-- ==================== KAYAN APPROACH ==================== -->
<section id="kayan-approach" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">منهجية كيان</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    في ركن تعلم اللغات <span class="text-secondary-800">نؤمن بأن التعلم تجربة حية</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    نستخدم أساليب مبتكرة مثل الألعاب التفاعلية والقصص المليئة بالمغامرات والأغاني المرحة، مما يساعد الأطفال على اكتساب اللغة بشكل سلس وطبيعي.
                </p>
            </div>

            <!-- Features Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-4xl mx-auto">
                <div class="bg-white/80 backdrop-blur-sm rounded-2xl p-6">
                    <div class="w-16 h-16 rounded-full bg-blue-100 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M20.25 8.511c.884.284 1.5 1.128 1.5 2.097v4.286c0 1.136-.847 2.1-1.98 2.193-.34.027-.68.052-1.02.072v3.091l-3-3c-1.354 0-2.694-.055-4.02-.163a2.115 2.115 0 01-.825-.242m9.345-8.334a2.126 2.126 0 00-.476-.095 48.64 48.64 0 00-8.048 0c-1.131.094-1.976 1.057-1.976 2.192v4.286c0 .837.46 1.58 1.155 1.951m9.345-8.334V6.637c0-1.621-1.152-3.026-2.76-3.235A48.455 48.455 0 0011.25 3c-2.115 0-4.198.137-6.24.402-1.608.209-2.76 1.614-2.76 3.235v6.226c0 1.621 1.152 3.026 2.76 3.235.577.075 1.157.14 1.74.194V21l4.155-4.155"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 text-lg mb-2">حوارات تمثيلية</h3>
                    <p class="text-gray-600 text-sm">نشجع الأطفال على المشاركة في حوارات تمثيلية لتطبيق اللغة في مواقف حياتية واقعية</p>
                </div>

                <div class="bg-white/80 backdrop-blur-sm rounded-2xl p-6">
                    <div class="w-16 h-16 rounded-full bg-indigo-100 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3"></path>
                        </svg>
                    </div>
                    <h3 class="font-bold text-gray-900 text-lg mb-2">تكنولوجيا حديثة</h3>
                    <p class="text-gray-600 text-sm">نستخدم التطبيقات التعليمية التفاعلية التي تُحفّز الأطفال على التعلم من خلال اللعب</p>
                </div>
            </div>

        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== WHY EARLY LEARNING ==================== -->
<section id="why-early" class="py-12 bg-white">
    <div class="container">
        <div class="flex flex-col lg:flex-row-reverse items-center gap-8 lg:gap-16">

            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">البداية المبكرة</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    ليش يبدأ طفلك <span class="text-secondary-800">يتعلم لغة جديدة؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start">
                    تظهر الأبحاث أن الأطفال يمتلكون قدرة فريدة على تعلم اللغات في سن مبكرة. وفقًا لدراسة نشرت في موقع "يونيسف"، فإن الأطفال الذين يتعرضون للغات متعددة في سن مبكرة يظهرون مرونة معرفية أكبر وقدرة محسنة على حل المشكلات.
                </p>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start mt-4">
                    بالإضافة إلى ذلك، فإن تعلم لغة جديدة يُعزز من فهم الطفل لثقافته وثقافات الآخرين، مما يُنمّي لديه حس الاحترام والتقدير للتنوع. علاوة على ذلك، فإن تعلم اللغات في سن مبكرة يسهم في تطوير مهارات الاستماع والتركيز، ويعزز من ثقة الطفل بنفسه عند التواصل مع الآخرين.
                </p>
            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/language-learning-corner.webp" width="275" height="275" alt="ركن تعلم اللغات">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#2323CD" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== INTERACTIVE METHODS ==================== -->
<section id="interactive-methods" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">طرق تفاعلية</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    طرقنا لتعليم اللغات <span class="text-secondary-800">بأسلوب تفاعلي</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    في ركن تعلم اللغات بمركز كيان، نركز على استخدام اللغة كأداة تواصل حقيقية، وليس كمادة دراسية فقط. ندمج اللغة في مواقف حياتية واقعية، مما يساعد الأطفال على الشعور بالراحة والثقة عند استخدامها في الحياة اليومية.
                </p>
            </div>

        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== BENEFITS ==================== -->
<section id="benefits" class="py-12 bg-white">
    <div class="container">
        <div class="max-w-4xl mx-auto text-center mb-10">
            <p class="text-primary-600 text-base md:text-lg mb-4">الفوائد</p>
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                فوائد تعلم اللغات <span class="text-secondary-800">من عمر مبكر</span>
            </h2>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                تعلم اللغات في سن مبكرة يحمل العديد من الفوائد التي تؤثر إيجابيًا على نمو الطفل
            </p>
        </div>

        <!-- Benefits Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-blue-50 rounded-2xl p-6 text-center">
                <div class="w-16 h-16 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 18v-5.25m0 0a6.01 6.01 0 001.5-.189m-1.5.189a6.01 6.01 0 01-1.5-.189m3.75 7.478a12.06 12.06 0 01-4.5 0m3.75 2.383a14.406 14.406 0 01-3 0M14.25 18v-.192c0-.983.658-1.823 1.508-2.316a7.5 7.5 0 10-7.517 0c.85.493 1.509 1.333 1.509 2.316V18"></path>
                    </svg>
                </div>
                <h3 class="font-bold text-gray-900 text-lg mb-2">القدرات المعرفية</h3>
                <p class="text-gray-600 text-sm">تعزيز مهارات التفكير النقدي، وحل المشكلات، والإبداع</p>
            </div>

            <div class="bg-indigo-50 rounded-2xl p-6 text-center">
                <div class="w-16 h-16 rounded-full bg-indigo-100 flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"></path>
                    </svg>
                </div>
                <h3 class="font-bold text-gray-900 text-lg mb-2">الأداء الأكاديمي</h3>
                <p class="text-gray-600 text-sm">أداء أفضل في المواد الدراسية مثل الرياضيات والقراءة</p>
            </div>

            <div class="bg-purple-50 rounded-2xl p-6 text-center">
                <div class="w-16 h-16 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418"></path>
                    </svg>
                </div>
                <h3 class="font-bold text-gray-900 text-lg mb-2">التفاهم الثقافي</h3>
                <p class="text-gray-600 text-sm">فهم واحترام الثقافات المختلفة والتقبل والتعاطف</p>
            </div>

            <div class="bg-cyan-50 rounded-2xl p-6 text-center">
                <div class="w-16 h-16 rounded-full bg-cyan-100 flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-cyan-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15.59 14.37a6 6 0 01-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 006.16-12.12A14.98 14.98 0 009.631 8.41m5.96 5.96a14.926 14.926 0 01-5.841 2.58m-.119-8.54a6 6 0 00-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 00-2.58 5.84m2.699 2.7c-.103.021-.207.041-.311.06a15.09 15.09 0 01-2.448-2.448 14.9 14.9 0 01.06-.312m-2.24 2.39a4.493 4.493 0 00-1.757 4.306 4.493 4.493 0 004.306-1.758M16.5 9a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z"></path>
                    </svg>
                </div>
                <h3 class="font-bold text-gray-900 text-lg mb-2">الفرص المستقبلية</h3>
                <p class="text-gray-600 text-sm">فرص واسعة في مجالات التعليم والعمل مستقبلاً</p>
            </div>
        </div>

    </div>
</section>

<!-- ==================== FAQ SECTION ==================== -->
<section id="faq" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">الأسئلة الشائعة</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    أسئلة <span class="text-secondary-800">شائعة</span>
                </h2>
            </div>

            <!-- FAQ Items -->
            <div class="max-w-3xl mx-auto space-y-4">
                <!-- FAQ Item 1 -->
                <div class="bg-white rounded-2xl overflow-hidden">
                    <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                        <h3 class="font-bold text-gray-900">ما هي قدرة الطفل على تعلم اللغات؟</h3>
                        <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="faq-content hidden px-6 pb-6">
                        <p class="text-secondary-900 text-sm leading-relaxed">
                            الأطفال يمتلكون قدرة فطرية على تعلم اللغات، خاصة في السنوات الأولى من حياتهم، حيث يكون الدماغ في أقصى درجات مرونته لاستيعاب الأصوات والتراكيب اللغوية الجديدة.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 2 -->
                <div class="bg-white rounded-2xl overflow-hidden">
                    <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                        <h3 class="font-bold text-gray-900">ما هي فوائد تعلم اللغات للأطفال؟</h3>
                        <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="faq-content hidden px-6 pb-6">
                        <p class="text-secondary-900 text-sm leading-relaxed">
                            يشمل ذلك تطوير المهارات المعرفية، تحسين الأداء الأكاديمي، تعزيز التفاهم الثقافي، وتوسيع الفرص المستقبلية في مجالات التعليم والعمل.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 3 -->
                <div class="bg-white rounded-2xl overflow-hidden">
                    <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                        <h3 class="font-bold text-gray-900">ما هي أهمية اللغة عند الطفل؟</h3>
                        <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="faq-content hidden px-6 pb-6">
                        <p class="text-secondary-900 text-sm leading-relaxed">
                            تعتبر اللغة أداة أساسية للتواصل والتعبير عن الذات، وتلعب دورًا محوريًا في تطوير الهوية الشخصية والاجتماعية للطفل.
                        </p>
                    </div>
                </div>

                <!-- FAQ Item 4 -->
                <div class="bg-white rounded-2xl overflow-hidden">
                    <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                        <h3 class="font-bold text-gray-900">كيف تتعلم لغة الأطفال؟</h3>
                        <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="faq-content hidden px-6 pb-6">
                        <p class="text-secondary-900 text-sm leading-relaxed">
                            يتم ذلك من خلال استخدام أساليب تفاعلية وممتعة مثل اللعب، الأغاني، والقصص، بالإضافة إلى توفير بيئة غنية بالتفاعل اللغوي والدعم المستمر من الأهل والمعلمين.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== CTA SECTION ==================== -->
<section id="cta" class="py-12 bg-white">
    <div class="container">
        <div class="max-w-4xl mx-auto text-center">
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                سجلي طفلك الآن <span class="text-secondary-800">في ركن تعلم اللغات</span>
            </h2>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mb-8">
                امنحي طفلك فرصة اكتشاف عالم جديد من خلال تعلم اللغات بطريقة ممتعة وتفاعلية
            </p>

            <div class="flex flex-row justify-center items-stretch gap-2">

                <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                        <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <span class="whitespace-nowrap">سجلي طفلك الآن</span>
                </a>

                <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                        <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                    </svg>
                </a>
            </div>

        </div>
    </div>
</section>

<?php include 'footer.php'; ?>
