<?php

/**
 * Service Page Template - Drawing and Arts Corner
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'ركن الرسم والفنون';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="max-w-4xl mx-auto px-4">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Image -->
            <div>
                <div class="relative">
                    <div class="service-circle relative">
                        <img src="dist/images/drawing-and-arts-corner.webp" width="275" height="275" alt="ركن الرسم والفنون">
                        <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD23A7" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Content -->
            <div class="text-center lg:text-start">
                <p class="text-primary-600 text-base md:text-lg mb-4">أركان المركز</p>
                <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                    ركن الرسم والفنون
                </h1>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg mb-8">
                    تعلم الرسم للأطفال والقراءة .. مزيج من الخيال والتعبير الفني يشعل إبداع الأطفال وينمي مهاراتهم
                </p>

                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== INTRO SECTION ==================== -->
<section id="intro" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="max-w-4xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">ركن القراءة والرسم</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    مزيج من الخيال <span class="text-secondary-800">والتعبير الفني</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal">
                    في ظل التقدم التكنولوجي والتنوع بمصادر المعلومات، تبرز أهمية الأنشطة التي تجمع بين التعليم والترفيه، خاصة تلك التي تنمي خيال الأطفال ومهاراتهم الإبداعية. يعد تعلم الرسم للأطفال والقراءة في "ركن القراءة والرسم" في مركز كيان نموذجًا مثاليًا لهذا التوازن، حيث يجمع بين متعة القراءة وألوان الرسم ليخلق بيئة غنية بالخيال والتعبير الفني.
                </p>

                <div class="flex flex-row justify-center items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== WORKSHOPS SECTION ==================== -->
<section id="workshops" class="py-12 bg-white">

    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">

            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">ورش العمل</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    ورش رسم ممتعة <span class="text-secondary-800">للأطفال</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed text-center lg:text-start">
                    تقدم في كيان ورش عمل مخصصة لتعليم الرسم للأطفال والقراءة، تهدف إلى تعزيز مهاراتهم الفنية وتوسيع آفاقهم الإبداعية. تتميز هذه الورش بتقديم أنشطة متنوعة تشجع الأطفال على التعبير عن أنفسهم من خلال الألوان والأشكال.
                </p>
                <div class="flex flex-row justify-center lg:justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>
            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/drawing-and-arts-corner.webp" width="275" height="275" alt="ركن الرسم والفنون">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD23A7" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- ==================== WHY DRAWING SECTION ==================== -->
<section id="why-drawing" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <!-- Section Header -->
            <div class="text-center mb-10">
                <p class="text-primary-600 text-base md:text-lg mb-4">أهمية الرسم</p>
                <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                    ليش مهم <span class="text-secondary-800">يتعلم طفلك الرسم؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-normal mt-6">
                    تعليم الرسم للأطفال والقراءة ليس مجرد نشاط ترفيهي، بل هو استثمار في تطوير جوانب متعددة من شخصياتهم
                </p>
            </div>

            <!-- Benefits Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
                <!-- Benefit 1 -->
                <div class="bg-white/80 rounded-3xl p-8 transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-secondary-600 to-secondary-800 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10.05 4.575a1.575 1.575 0 10-3.15 0v3m3.15-3v-1.5a1.575 1.575 0 013.15 0v1.5m-3.15 0l.075 5.925m3.075.75V4.575m0 0a1.575 1.575 0 013.15 0V15M6.9 7.575a1.575 1.575 0 10-3.15 0v8.175a6.75 6.75 0 006.75 6.75h2.018a5.25 5.25 0 003.712-1.538l1.732-1.732a5.25 5.25 0 001.538-3.712l.003-2.024a.668.668 0 01.198-.471 1.575 1.575 0 10-2.228-2.228 3.818 3.818 0 00-1.12 2.687M6.9 7.575V12m6.27 4.318A4.49 4.49 0 0116.35 15m.002 0h-.002"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4">تنمية المهارات الحركية الدقيقة</h3>
                    <p class="text-gray-600 text-sm leading-normal">
                        الرسم يُحسّن التنسيق بين اليد والعين، ويعزز التحكم في الحركات الدقيقة.
                    </p>
                </div>

                <!-- Benefit 2 -->
                <div class="bg-white/80 rounded-3xl p-8 transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 18v-5.25m0 0a6.01 6.01 0 001.5-.189m-1.5.189a6.01 6.01 0 01-1.5-.189m3.75 7.478a12.06 12.06 0 01-4.5 0m3.75 2.383a14.406 14.406 0 01-3 0M14.25 18v-.192c0-.983.658-1.823 1.508-2.316a7.5 7.5 0 10-7.517 0c.85.493 1.509 1.333 1.509 2.316V18"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4">تعزيز التفكير الإبداعي والتصويري</h3>
                    <p class="text-gray-600 text-sm leading-normal">
                        الرسم يساعد الأطفال على التعبير عن أفكارهم ومشاعرهم بصريًا، ويعزز خيالهم وابتكارهم.
                    </p>
                </div>

                <!-- Benefit 3 -->
                <div class="bg-white/80 rounded-3xl p-8 transition-all duration-300 hover:-translate-y-2">
                    <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-red-500 to-pink-500 flex items-center justify-center mb-6">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-4">تحسين القدرة على التعبير عن المشاعر</h3>
                    <p class="text-gray-600 text-sm leading-normal">
                        يُساعد الرسم الأطفال على فهم مشاعرهم والتعبير عنها، مما يُساهم في تطوير ذكائهم العاطفي.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== CREATIVITY DEVELOPMENT SECTION ==================== -->
<section id="creativity" class="py-12 bg-white">
    <div class="container">
        <div class="flex flex-col lg:flex-row items-center gap-8 lg:gap-16">
            <!-- Content -->
            <div>
                <p class="text-primary-600 text-base md:text-lg mb-4 text-center lg:text-start">تنمية الإبداع</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6 text-center lg:text-start">
                    كيف ننمّي الإبداع <span class="text-secondary-800">عند الأطفال؟</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base mb-6 leading-relaxed text-center lg:text-start">
                    تنمية الإبداع لدى الأطفال تتطلب بيئة محفزة ومجموعة من الأنشطة التي تشجعهم على التفكير خارج الصندوق:
                </p>

                <ul class="space-y-4">
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #23CD9D20">
                            <svg class="w-4 h-4" style="color: #23CD9D" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">توفير بيئة غنية بالمحفزات:</span>
                            <span class="text-gray-700"> وجود مواد وأدوات متنوعة يحفز الأطفال على الاستكشاف والتجربة.</span>
                        </div>
                    </li>
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #23CD9D20">
                            <svg class="w-4 h-4" style="color: #23CD9D" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">تشجيع الأنشطة الفنية المتنوعة:</span>
                            <span class="text-gray-700"> مثل الرسم والتلوين والنحت، التي تعبّر عن مشاعرهم وأفكارهم بطرق مختلفة.</span>
                        </div>
                    </li>
                    <li class="flex items-start gap-3">
                        <div class="w-6 h-6 rounded-full flex items-center justify-center flex-shrink-0 mt-1" style="background: #23CD9D20">
                            <svg class="w-4 h-4" style="color: #23CD9D" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </div>
                        <div>
                            <span class="font-bold text-gray-900">التحفيز على الاستكشاف والتعلم الذاتي:</span>
                            <span class="text-gray-700"> تشجيع الأطفال على طرح الأسئلة والبحث عن إجابات ينمي فضولهم ويعزز مهاراتهم المعرفية.</span>
                        </div>
                    </li>
                </ul>

                <div class="flex flex-row justify-start items-stretch gap-2 mt-8">

                    <a href="contact.php" class="inline-flex items-center justify-center gap-2 px-6 py-2.5 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" width="15" height="16" viewBox="0 0 15 16" fill="none">
                            <path d="M9.90015 9.20001V10.74L11.0201 11.44" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.90015 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M13.4 4.65001V3.60001C13.4 3.22871 13.2525 2.87261 12.99 2.61006C12.7274 2.34751 12.3714 2.20001 12 2.20001H2.20005C1.82875 2.20001 1.47265 2.34751 1.2101 2.61006C0.947548 2.87261 0.800049 3.22871 0.800049 3.60001V13.4C0.800049 13.7713 0.947548 14.1274 1.2101 14.39C1.47265 14.6525 1.82875 14.8 2.20005 14.8H4.65005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M0.800049 6.39996H4.30005" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M4.30005 0.799988V3.59999" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                            <path d="M9.89995 14.8C12.2195 14.8 14.1 12.9196 14.1 10.6C14.1 8.28037 12.2195 6.39996 9.89995 6.39996C7.58036 6.39996 5.69995 8.28037 5.69995 10.6C5.69995 12.9196 7.58036 14.8 9.89995 14.8Z" stroke="white" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                        <span class="whitespace-nowrap">احجزي لطفلك الآن</span>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-11 aspect-square rounded-full flex items-center justify-center bg-[#128C7E] transition-all duration-300 ease-out hover:scale-110 hover:shadow-lg active:scale-95 shrink-0">
                        <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path d="M14.5125 11.985C14.265 11.8609 13.0475 11.2625 12.8208 11.1792C12.5933 11.0967 12.4283 11.0559 12.2625 11.3042C12.0983 11.5517 11.6233 12.1092 11.4792 12.2742C11.335 12.44 11.19 12.46 10.9425 12.3367C10.695 12.2117 9.89667 11.9509 8.95083 11.1075C8.215 10.4509 7.7175 9.64003 7.57333 9.3917C7.42917 9.1442 7.55833 9.01003 7.68167 8.8867C7.79333 8.77587 7.93 8.59753 8.05333 8.45337C8.1775 8.30837 8.21833 8.20504 8.30167 8.0392C8.38417 7.8742 8.34333 7.73003 8.28083 7.60587C8.21833 7.4817 7.72333 6.26253 7.5175 5.7667C7.31583 5.2842 7.11167 5.35003 6.96 5.3417C6.81583 5.33503 6.65083 5.33337 6.485 5.33337C6.32 5.33337 6.05167 5.39503 5.825 5.64337C5.59833 5.89087 4.95833 6.49003 4.95833 7.7092C4.95833 8.92754 5.84583 10.105 5.96917 10.2709C6.09333 10.4359 7.71583 12.9375 10.2 14.01C10.7908 14.265 11.2517 14.4175 11.6117 14.5309C12.205 14.72 12.745 14.6934 13.1708 14.6292C13.6467 14.5584 14.6358 14.03 14.8425 13.4517C15.0492 12.8734 15.0492 12.3775 14.9867 12.2742C14.925 12.1709 14.7608 12.1092 14.5125 11.985ZM9.99417 18.1542H9.99083C8.51564 18.1543 7.06757 17.7577 5.79833 17.0059L5.4975 16.8275L2.38 17.6459L3.21167 14.6059L3.01583 14.2942C2.1912 12.9811 1.75495 11.4614 1.7575 9.91087C1.75833 5.3692 5.45417 1.6742 9.9975 1.6742C12.1975 1.6742 14.2658 2.53253 15.8208 4.0892C16.5881 4.85305 17.1962 5.76147 17.61 6.7619C18.0238 7.76233 18.2351 8.8349 18.2317 9.91753C18.2292 14.4592 14.5342 18.1542 9.99417 18.1542ZM17.005 2.9067C16.0868 1.98247 14.9944 1.24965 13.7909 0.750701C12.5875 0.251754 11.2969 -0.00339687 9.99417 3.4148e-05C4.53167 3.4148e-05 0.0858333 4.44587 0.0833333 9.91004C0.0833333 11.6567 0.539167 13.3617 1.40667 14.8642L0 20L5.25417 18.6217C6.70716 19.4133 8.33536 19.8282 9.99 19.8284H9.99417C15.4558 19.8284 19.9025 15.3825 19.905 9.91753C19.9062 8.6193 19.6507 7.33365 19.1533 6.13448C18.6559 4.93532 17.9264 3.8463 17.0067 2.93003" fill="white"></path>
                        </svg>
                    </a>
                </div>

            </div>

            <!-- Image -->
            <div>
                <div class="service-circle relative">
                    <img src="dist/images/drawing-and-arts-corner.webp" width="275" height="275" alt="ركن الرسم والفنون">
                    <svg class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2" width="275" height="275" viewBox="0 0 282 282" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 71C1 71 71 1 141 1M141 1C211 1 281 71 281 141C281 211 211 281 141 281C71 281 1 211 1 141C1 71 71 1 141 1Z" stroke="#CD23A7" stroke-width="2" stroke-linecap="round" stroke-dasharray="1 1" />
                    </svg>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==================== SAFE ACTIVITIES SECTION ==================== -->
<section id="safe-activities" class="gradient-section relative overflow-hidden">

    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

    <div class="py-12">
        <div class="container">
            <div class="max-w-5xl mx-auto text-center">
                <p class="text-primary-600 text-base md:text-lg mb-4">السلامة أولاً</p>
                <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-6">
                    أنشطة فنية آمنة <span class="text-secondary-800">وممتعة</span>
                </h2>
                <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed">
                    في كيان، تراعي معايير السلامة والجودة في جميع الأنشطة المقدمة. تستخدم مواد آمنة وصديقة للبيئة، ويشرف على الورش مختصون في مجال التربية الفنية، لضمان تجربة ممتعة وآمنة للأطفال.
                </p>

                <!-- Safety Features -->
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 mt-10">
                    <div class="bg-white/80 rounded-2xl p-6">
                        <div class="w-14 h-14 rounded-full bg-green-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">مواد آمنة</h3>
                        <p class="text-gray-600 text-sm">جميع الأدوات والمواد آمنة وصديقة للبيئة</p>
                    </div>

                    <div class="bg-white/80 rounded-2xl p-6">
                        <div class="w-14 h-14 rounded-full bg-blue-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-7 h-7 text-blue-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">إشراف متخصص</h3>
                        <p class="text-gray-600 text-sm">مختصون في التربية الفنية يشرفون على الورش</p>
                    </div>

                    <div class="bg-white/80 rounded-2xl p-6">
                        <div class="w-14 h-14 rounded-full bg-purple-100 flex items-center justify-center mx-auto mb-4">
                            <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.182 15.182a4.5 4.5 0 01-6.364 0M21 12a9 9 0 11-18 0 9 9 0 0118 0zM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75zm-.375 0h.008v.015h-.008V9.75zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75zm-.375 0h.008v.015h-.008V9.75z"></path>
                            </svg>
                        </div>
                        <h3 class="font-bold text-gray-900 mb-2">تجربة ممتعة</h3>
                        <p class="text-gray-600 text-sm">بيئة مرحة تشجع على الإبداع والاستمتاع</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>

</section>

<!-- ==================== FAQ SECTION ==================== -->
<section id="faq" class="py-12 bg-white">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-10">
            <p class="text-primary-600 text-base md:text-lg mb-4">الأسئلة الشائعة</p>
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-bold !leading-snug text-primary-900">
                أسئلة <span class="text-secondary-800">شائعة</span>
            </h2>
        </div>

        <!-- FAQ Items -->
        <div class="max-w-3xl mx-auto space-y-4">
            <!-- FAQ Item 1 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">كيف نعلم الأطفال الرسم؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        يتم تعليم الأطفال الرسم من خلال تقديم أنشطة تدريجية تناسب أعمارهم، بدءًا من التلوين البسيط وصولاً إلى تقنيات الرسم المتقدمة، مع التركيز على التعبير الشخصي والتجريب.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 2 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">ما هي الأشياء التي يرسمها الأطفال؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        يعتمد ذلك على مرحلة نموهم، حيث يبدأون برسم الأشكال البسيطة مثل الدوائر والخطوط، ثم يتطورون إلى رسم الأشخاص والحيوانات والمشاهد من خيالهم أو بيئتهم المحيطة.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 3 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">محتوى كورس رسم للأطفال؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        يشمل الكورس تعليم أساسيات الرسم، مثل استخدام الأدوات، فهم الأشكال والألوان، تقنيات التظليل، ورسم مواضيع متنوعة تحفز الإبداع والتفكير النقدي.
                    </p>
                </div>
            </div>

            <!-- FAQ Item 4 -->
            <div class="bg-secondary-50 rounded-2xl overflow-hidden">
                <button class="faq-toggle w-full flex items-center justify-between p-6 text-start" onclick="toggleFaq(this)">
                    <h3 class="font-bold text-gray-900">كيف أنمي مهارة الرسم عند الأطفال؟</h3>
                    <svg class="faq-icon w-6 h-6 text-secondary-600 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <div class="faq-content hidden px-6 pb-6">
                    <p class="text-secondary-900 text-sm leading-normal">
                        من خلال توفير بيئة داعمة، تشجيعهم على ممارسة الرسم بانتظام، تقديم ملاحظات إيجابية، وتوفير فرص للتعلم والتطور، مثل الالتحاق بورش عمل متخصصة.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>