<?php

/**
 * Our New Services Page
 * جديدنا
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'جديدنا';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="container">
        <div class="text-center max-w-4xl mx-auto">
            <p class="text-primary-600 text-base md:text-lg mb-4">خدمات جديدة</p>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-6">
                جديدنا
            </h1>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg leading-relaxed">
                في كيان المستقبل، نؤمن بأن كل طفل يحمل في داخله موهبة تستحق الاكتشاف، ونسعى لتقديم خدمات جديدة تُلهم عقولهم وتنمّي مهاراتهم.
            </p>
        </div>
    </div>
</section>

<!-- ==================== SERVICES BOXES ==================== -->
<section class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-8">

                <!-- Language Learning Pathway Box -->
                <div class="bg-white/80 rounded-3xl p-8 transition-all duration-300 text-center">
                    <div class="w-20 h-20 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 21l5.25-11.25L21 21m-9-3h7.5M3 5.621a48.474 48.474 0 016-.371m0 0c1.12 0 2.233.038 3.334.114M9 5.25V3m3.334 2.364C11.176 10.658 7.69 15.08 3 17.502m9.334-12.138c.896.061 1.785.147 2.666.257m-4.589 8.495a18.023 18.023 0 01-3.827-5.802"></path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">مسارات تعليم اللغات</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        نفتح أبواب العالم أمام أطفالكم مع دورات تقدَّم بأساليب شيّقة على أيدي الخبراء
                    </p>
                    <a href="#language-schedule" class="inline-flex items-center justify-center gap-2 px-6 py-3 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97]">
                        <span>عرض تفاصيل الخدمة</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </a>
                </div>

                <!-- After-School Follow-Up Box -->
                <div class="bg-white/80 rounded-3xl p-8 transition-all duration-300 text-center">
                    <div class="w-20 h-20 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"></path>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">خدمة متابعة ما بعد المدرسة</h3>
                    <p class="text-gray-600 mb-6 leading-relaxed">
                        في مركز كيان المستقبل هدفنا أن يصبح التعلم متعة، والتفوق عادة.
                    </p>
                    <a href="#after-school" class="inline-flex items-center justify-center gap-2 px-6 py-3 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl active:scale-[0.97]">
                        <span>عرض تفاصيل الخدمة</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </div>
    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
</section>

<!-- ==================== LANGUAGE SCHEDULE SECTION ==================== -->
<section id="language-schedule" class="pt-12 pb-12 bg-white scroll-mt-24">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-secondary-100 text-secondary-700 font-bold text-xl mb-4">١</div>
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-4">
                مسارات تعلم اللغات
            </h2>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg max-w-2xl mx-auto">
                تعلم لغات جديدة لن يكون مجرد دراسة، بل سيكون مغامرة مثيرة لاستكشاف ثقافات وأفكار جديدة!
            </p>
        </div>

        <!-- Schedule Table -->
        <div class="max-w-4xl mx-auto">
            <div class="bg-white rounded-3xl shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="bg-gradient-to-r from-secondary-600 to-secondary-800 text-white">
                                <th class="px-6 py-4 text-center font-bold">اللغة</th>
                                <th class="px-6 py-4 text-center font-bold">الأيام</th>
                                <th class="px-6 py-4 text-center font-bold">الوقت</th>
                                <th class="px-6 py-4 text-center font-bold">المميزات</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-5 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <span class="text-2xl">🇬🇧</span>
                                        <span class="font-bold text-gray-900">اللغة الإنجليزية</span>
                                    </div>
                                </td>
                                <td class="px-6 py-5 text-center text-gray-700">الأحد – الثلاثاء - الخميس</td>
                                <td class="px-6 py-5 text-center text-gray-700">من 3 إلى 4 عصرًا</td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-green-100 text-green-700 text-sm font-medium">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        شاملة وجبة الغداء
                                    </span>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-5 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <span class="text-2xl">🇪🇸</span>
                                        <span class="font-bold text-gray-900">اللغة الإسبانية</span>
                                    </div>
                                </td>
                                <td class="px-6 py-5 text-center text-gray-700">الثلاثاء – الأربعاء</td>
                                <td class="px-6 py-5 text-center text-gray-700">من 1 ظهرًا إلى 3 عصرًا</td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-green-100 text-green-700 text-sm font-medium">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        شاملة وجبة الغداء
                                    </span>
                                </td>
                            </tr>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-5 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <span class="text-2xl">🇫🇷</span>
                                        <span class="font-bold text-gray-900">اللغة الفرنسية</span>
                                    </div>
                                </td>
                                <td class="px-6 py-5 text-center text-gray-700">الأحد – الاثنين</td>
                                <td class="px-6 py-5 text-center text-gray-700">من 1 ظهرًا إلى 3 عصرًا</td>
                                <td class="px-6 py-5 text-center">
                                    <span class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-green-100 text-green-700 text-sm font-medium">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        شاملة وجبة الغداء
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- CTA Button -->
            <div class="text-center mt-8">
                <a href="https://wa.me/966505996562" target="_blank" class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-[#128c7e] text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl active:scale-[0.97]">
                    <svg class="w-6 h-6" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                        <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                    </svg>
                    <span>تواصل معنا للحجز</span>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- ==================== AFTER SCHOOL SECTION ==================== -->
<section id="after-school" class="pt-6 pb-12 bg-white scroll-mt-24">
    <div class="container">
        <!-- Section Header -->
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-primary-100 text-primary-700 font-bold text-xl mb-4">٢</div>
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold !leading-snug text-secondary-900 mb-4">
                خدمة متابعة ما بعد المدرسة
            </h2>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg max-w-2xl mx-auto">
                في خدمة متابعة ما بعد المدرسة فريقنا جاهز لمساعدة أطفالكم على تحقيق التفوق من خلال:
            </p>
        </div>

        <!-- Features List -->
        <div class="max-w-2xl mx-auto">
            <div class="bg-secondary-500/5 rounded-3xl shadow-sm p-8">
                <ul class="space-y-4">
                    <li class="flex items-center gap-4 p-4 bg-white rounded-2xl">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <span class="text-gray-800 font-medium text-lg">تنظيم ومراجعة يومية للدروس</span>
                    </li>
                    <li class="flex items-center gap-4 p-4 bg-white rounded-2xl">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <span class="text-gray-800 font-medium text-lg">إنجاز الواجبات بسرعة واحترافية</span>
                    </li>
                    <li class="flex items-center gap-4 p-4 bg-white rounded-2xl">
                        <div class="w-12 h-12 rounded-full bg-gradient-to-r from-green-500 to-green-600 flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                            </svg>
                        </div>
                        <span class="text-gray-800 font-medium text-lg">تقديم دعم لمعالجة أي صعوبات تعليمية</span>
                    </li>
                </ul>

                <!-- CTA Button -->
                <div class="text-center mt-8">
                    <a href="https://wa.me/966505996562" target="_blank" class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-[#128c7e] text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl active:scale-[0.97]">
                        <svg class="w-6 h-6" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                            <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                        </svg>
                        <span>تواصل معنا للمزيد من التفاصيل والحجز</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>