<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مركز كيان المستقبل - لضيافة الأطفال</title>

    <!-- Local Font -->
    <link rel="stylesheet" href="dist/font/zain/font.css">
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
    <link rel="stylesheet" href="dist/output.css">
</head>

<body class="overflow-x-hidden">

    <!-- ==================== HEADER ==================== -->
    <header id="main-header" class="relative z-50 bg-transparent transition-all duration-300">

        <!-- ==================== TOP BAR ==================== -->
        <div id="top-bar" class="bg-gradient-to-r from-secondary-700 to-secondary-800 py-3 px-4 rounded-b-[100px] mx-auto container hidden lg:block transition-all duration-300">
            <div class="flex items-center justify-center gap-8 text-white text-sm">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" width="13" height="16" viewBox="0 0 13 16" fill="none">
                        <path d="M11.9001 6.30002C11.9001 9.79516 8.02274 13.4352 6.72073 14.5594C6.59943 14.6506 6.45178 14.7 6.30002 14.7C6.14826 14.7 6.00061 14.6506 5.87932 14.5594C4.5773 13.4352 0.699951 9.79516 0.699951 6.30002C0.699951 4.81479 1.28996 3.39039 2.34017 2.34017C3.39039 1.28996 4.81479 0.699951 6.30002 0.699951C7.78525 0.699951 9.20965 1.28996 10.2599 2.34017C11.3101 3.39039 11.9001 4.81479 11.9001 6.30002Z" stroke="white" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M6.29998 8.40013C7.45979 8.40013 8.4 7.45991 8.4 6.3001C8.4 5.14029 7.45979 4.20007 6.29998 4.20007C5.14016 4.20007 4.19995 5.14029 4.19995 6.3001C4.19995 7.45991 5.14016 8.40013 6.29998 8.40013Z" stroke="white" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <span>الرياض ، حي الرائد ، شارع عبدالعزيز الاحسائي</span>
                </div>
                <a href="tel:+966505996562" class="flex items-center gap-2 hover:opacity-80 transition-opacity">
                    <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
                        <path d="M7.79915 9.44075C7.92307 9.49766 8.06267 9.51066 8.19497 9.47762C8.32726 9.44457 8.44435 9.36745 8.52695 9.25895L8.73995 8.97995C8.85173 8.83092 8.99667 8.70995 9.1633 8.62664C9.32992 8.54333 9.51366 8.49995 9.69995 8.49995H11.5C11.8182 8.49995 12.1234 8.62638 12.3485 8.85142C12.5735 9.07647 12.7 9.38169 12.7 9.69995V11.5C12.7 11.8182 12.5735 12.1234 12.3485 12.3485C12.1234 12.5735 11.8182 12.7 11.5 12.7C8.63561 12.7 5.88859 11.5621 3.8632 9.5367C1.83781 7.51131 0.699951 4.76429 0.699951 1.89995C0.699951 1.58169 0.826379 1.27647 1.05142 1.05142C1.27647 0.826379 1.58169 0.699951 1.89995 0.699951H3.69995C4.01821 0.699951 4.32344 0.826379 4.54848 1.05142C4.77352 1.27647 4.89995 1.58169 4.89995 1.89995V3.69995C4.89995 3.88625 4.85658 4.06998 4.77326 4.23661C4.68995 4.40323 4.56899 4.54818 4.41995 4.65995L4.13915 4.87055C4.029 4.95466 3.95136 5.0743 3.91943 5.20916C3.88749 5.34402 3.90322 5.48578 3.96395 5.61035C4.78396 7.27587 6.13261 8.62283 7.79915 9.44075Z" stroke="white" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <span>0505996562</span>
                </a>
                <a href="mailto:info@futurekayan.com" class="flex items-center gap-2 hover:opacity-80 transition-opacity">
                    <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" width="17" height="14" viewBox="0 0 17 14" fill="none">
                        <path d="M15.7002 2.94995L8.95695 7.2452C8.72812 7.37811 8.4682 7.44812 8.20357 7.44812C7.93894 7.44812 7.67902 7.37811 7.4502 7.2452L0.700195 2.94995" stroke="white" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M14.2002 0.699951H2.2002C1.37177 0.699951 0.700195 1.37152 0.700195 2.19995V11.2C0.700195 12.0284 1.37177 12.7 2.2002 12.7H14.2002C15.0286 12.7 15.7002 12.0284 15.7002 11.2V2.19995C15.7002 1.37152 15.0286 0.699951 14.2002 0.699951Z" stroke="white" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <span>info@futurekayan.com</span>
                </a>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="container mx-auto px-4 py-4 relative">
            <div class="flex items-center justify-between">

                <!-- Logo -->
                <div class="flex items-center gap-2">
                    <a href="index.php"><img src="dist/images/logo.png" alt="Logo" class="w-full h-full object-contain"></a>
                </div>

                <!-- Nav Links -->
                <div class="hidden lg:flex items-center gap-8 text-sm font-bold">
                    <a href="index.php" class="text-gray-900 hover:text-secondary-600 transition-colors">الرئيسية</a>
                    <a href="about.php" class="text-gray-900 hover:text-secondary-600 transition-colors">عن كيان</a>
                    <a href="services.php" class="text-gray-900 hover:text-secondary-600 transition-colors">أركان المركز</a>
                    <a href="gallery.php" class="text-gray-900 hover:text-secondary-600 transition-colors">معرض الصور</a>
                    <a href="our-new.php" class="text-gray-900 hover:text-secondary-600 transition-colors">جديدنا</a>
                    <a href="blog.php" class="text-gray-900 hover:text-secondary-600 transition-colors">المدونة</a>
                    <a href="contact.php" class="text-gray-900 hover:text-secondary-600 transition-colors">تواصل معنا</a>
                    <!-- Language Switcher -->
                    <button id="lang-switcher" class="flex items-center gap-1 px-3 py-1.5 rounded-full bg-secondary-100 text-secondary-700 hover:bg-secondary-200 transition-colors" onclick="toggleLanguage()">
                        <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" />
                        </svg>
                        <span id="lang-text">EN</span>
                    </button>
                </div>

                <!-- Mobile Menu Button -->
                <button class="lg:hidden text-primary-950 p-2" id="mobile-menu-btn" aria-label="فتح القائمة" aria-expanded="false" aria-controls="mobile-menu">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>

                <!-- Social Icons (Desktop) -->
                <div class="hidden lg:flex items-center gap-2 text-secondary-800">
                    <a href="https://www.snapchat.com/add/futurekayan1" target="_blank" aria-label="سناب شات" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg width="32" height="32" viewBox="0 0 192 192" xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none">
                            <path stroke="currentColor" stroke-linejoin="round" stroke-width="16" d="M95.918 22.002c-11.963-.087-24.145 4.54-32.031 13.717-6.995 7.405-9.636 17.901-9.284 27.868-.03 5.119.032 10.237.05 15.355-4.901-1.217-9.873-4.624-15.063-2.937-4.422 1.313-6.267 7.088-3.596 10.791 2.876 3.761 7.346 5.907 11.08 8.71 1.837 1.5 4.313 2.571 5.68 4.499-.001 4.62-2.425 8.897-4.722 12.786-5.597 8.802-14.342 15.531-23.705 20.18-2.39 1.035-4.59 4.144-2.473 6.499 3.862 3.622 9.327 4.778 14.195 6.486 2.047.64 5.078 1.34 4.886 4.084.335 2.923 2.205 6.066 5.492 6.078 7.873.91 16.289.522 23.345 4.741 6.917 4.006 14.037 8.473 22.255 8.96 8.188.767 16.623-.888 23.642-5.255 5.23-2.884 10.328-6.477 16.456-7.061 5.155-1.206 10.702-.151 15.685-2.072 3.193-1.367 2.762-5.244 4.104-7.808 2.532-1.747 5.77-1.948 8.59-3.102 3.687-1.47 8.335-2.599 10.268-6.413 1.148-3.038-2.312-4.698-4.453-5.88-11.38-5.874-21.631-14.921-26.121-27.191-.496-1.936-2.279-4.834.084-6.255 4.953-4.176 11.413-6.575 15.514-11.715 3.103-3.884.941-10.55-4.141-11.322-4.928-.78-9.525 1.893-14.152 3.127-.404-8.53.502-17.232-.776-25.746-2.429-13.808-13.514-25.157-26.813-29.124-4.521-1.401-9.266-2.037-13.996-2Z" />
                        </svg>

                    </a>

                    <a href="https://www.instagram.com/futurekayan" target="_blank" aria-label="انستغرام" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path d="M320.3 205C256.8 204.8 205.2 256.2 205 319.7C204.8 383.2 256.2 434.8 319.7 435C383.2 435.2 434.8 383.8 435 320.3C435.2 256.8 383.8 205.2 320.3 205zM319.7 245.4C360.9 245.2 394.4 278.5 394.6 319.7C394.8 360.9 361.5 394.4 320.3 394.6C279.1 394.8 245.6 361.5 245.4 320.3C245.2 279.1 278.5 245.6 319.7 245.4zM413.1 200.3C413.1 185.5 425.1 173.5 439.9 173.5C454.7 173.5 466.7 185.5 466.7 200.3C466.7 215.1 454.7 227.1 439.9 227.1C425.1 227.1 413.1 215.1 413.1 200.3zM542.8 227.5C541.1 191.6 532.9 159.8 506.6 133.6C480.4 107.4 448.6 99.2 412.7 97.4C375.7 95.3 264.8 95.3 227.8 97.4C192 99.1 160.2 107.3 133.9 133.5C107.6 159.7 99.5 191.5 97.7 227.4C95.6 264.4 95.6 375.3 97.7 412.3C99.4 448.2 107.6 480 133.9 506.2C160.2 532.4 191.9 540.6 227.8 542.4C264.8 544.5 375.7 544.5 412.7 542.4C448.6 540.7 480.4 532.5 506.6 506.2C532.8 480 541 448.2 542.8 412.3C544.9 375.3 544.9 264.5 542.8 227.5zM495 452C487.2 471.6 472.1 486.7 452.4 494.6C422.9 506.3 352.9 503.6 320.3 503.6C287.7 503.6 217.6 506.2 188.2 494.6C168.6 486.8 153.5 471.7 145.6 452C133.9 422.5 136.6 352.5 136.6 319.9C136.6 287.3 134 217.2 145.6 187.8C153.4 168.2 168.5 153.1 188.2 145.2C217.7 133.5 287.7 136.2 320.3 136.2C352.9 136.2 423 133.6 452.4 145.2C472 153 487.1 168.1 495 187.8C506.7 217.3 504 287.3 504 319.9C504 352.5 506.7 422.6 495 452z" />
                        </svg>
                    </a>

                    <a href="https://www.facebook.com/futurekayan" target="_blank" aria-label="فيسبوك" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                        </svg>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="واتساب" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#128c7e] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                        </svg>
                    </a>

                    <a href="tel:+966505996562" aria-label="اتصل بنا" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                        </svg>
                    </a>

                </div>
            </div>

            <!-- Mobile Menu Dropdown -->
            <div id="mobile-menu" class="lg:hidden absolute left-4 right-4 top-full z-50 bg-white rounded-3xl shadow-2xl overflow-hidden transition-all duration-300 ease-out opacity-0 -translate-y-4 pointer-events-none">

                <!-- Navigation Links -->
                <div class="p-5 space-y-1">
                    <a href="index.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                        الرئيسية
                    </a>
                    <a href="about.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        عن كيان
                    </a>
                    <a href="services.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                        أركان المركز
                    </a>
                    <a href="gallery.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        معرض الصور
                    </a>
                    <a href="our-new.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 18h-5" />
                            <path d="M18 14h-8" />
                            <path d="M4 22h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v16a2 2 0 0 1-4 0v-9a2 2 0 0 1 2-2h2" />
                            <rect width="8" height="4" x="10" y="6" rx="1" />
                        </svg>
                        جديدنا
                    </a>
                    <a href="blog.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15 18h-5" />
                            <path d="M18 14h-8" />
                            <path d="M4 22h16a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H8a2 2 0 0 0-2 2v16a2 2 0 0 1-4 0v-9a2 2 0 0 1 2-2h2" />
                            <rect width="8" height="4" x="10" y="6" rx="1" />
                        </svg>
                        المدونة
                    </a>
                    <a href="contact.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-gray-700 font-semibold hover:bg-gray-50 transition-all">
                        <svg class="w-5 h-5 text-secondary-600" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        تواصل معنا
                    </a>
                </div>

                <!-- Contact Info Section -->
                <div class="bg-gradient-to-br from-secondary-50 to-primary-50 px-5 py-4">
                    <div class="space-y-2">
                        <a href="https://maps.google.com/?q=السعودية,الرياض,حي الرائد,شارع عبدالعزيز الاحسائي" target="_blank" class="flex items-center gap-3 bg-white/80 backdrop-blur-sm rounded-xl px-4 py-3 text-sm text-gray-700 hover:bg-white hover:shadow-md transition-all">
                            <div class="w-8 h-8 rounded-full bg-secondary-100 flex items-center justify-center shrink-0">
                                <svg class="w-4 h-4 text-secondary-600" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 13 16" fill="none">
                                    <path d="M11.9001 6.30002C11.9001 9.79516 8.02274 13.4352 6.72073 14.5594C6.59943 14.6506 6.45178 14.7 6.30002 14.7C6.14826 14.7 6.00061 14.6506 5.87932 14.5594C4.5773 13.4352 0.699951 9.79516 0.699951 6.30002C0.699951 4.81479 1.28996 3.39039 2.34017 2.34017C3.39039 1.28996 4.81479 0.699951 6.30002 0.699951C7.78525 0.699951 9.20965 1.28996 10.2599 2.34017C11.3101 3.39039 11.9001 4.81479 11.9001 6.30002Z" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M6.29998 8.40013C7.45979 8.40013 8.4 7.45991 8.4 6.3001C8.4 5.14029 7.45979 4.20007 6.29998 4.20007C5.14016 4.20007 4.19995 5.14029 4.19995 6.3001C4.19995 7.45991 5.14016 8.40013 6.29998 8.40013Z" stroke="currentColor" stroke-width="1.4" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <span class="leading-tight">الرياض ، حي الرائد ، شارع عبدالعزيز الاحسائي</span>
                        </a>
                    </div>
                </div>

                <!-- Social Icons Section -->
                <div class="px-5 py-4 bg-gray-50 flex items-center justify-center gap-3 text-secondary-800">
                    <a href="https://www.snapchat.com/add/futurekayan1" target="_blank" aria-label="سناب شات" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg width="32" height="32" viewBox="0 0 192 192" xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none">
                            <path stroke="currentColor" stroke-linejoin="round" stroke-width="16" d="M95.918 22.002c-11.963-.087-24.145 4.54-32.031 13.717-6.995 7.405-9.636 17.901-9.284 27.868-.03 5.119.032 10.237.05 15.355-4.901-1.217-9.873-4.624-15.063-2.937-4.422 1.313-6.267 7.088-3.596 10.791 2.876 3.761 7.346 5.907 11.08 8.71 1.837 1.5 4.313 2.571 5.68 4.499-.001 4.62-2.425 8.897-4.722 12.786-5.597 8.802-14.342 15.531-23.705 20.18-2.39 1.035-4.59 4.144-2.473 6.499 3.862 3.622 9.327 4.778 14.195 6.486 2.047.64 5.078 1.34 4.886 4.084.335 2.923 2.205 6.066 5.492 6.078 7.873.91 16.289.522 23.345 4.741 6.917 4.006 14.037 8.473 22.255 8.96 8.188.767 16.623-.888 23.642-5.255 5.23-2.884 10.328-6.477 16.456-7.061 5.155-1.206 10.702-.151 15.685-2.072 3.193-1.367 2.762-5.244 4.104-7.808 2.532-1.747 5.77-1.948 8.59-3.102 3.687-1.47 8.335-2.599 10.268-6.413 1.148-3.038-2.312-4.698-4.453-5.88-11.38-5.874-21.631-14.921-26.121-27.191-.496-1.936-2.279-4.834.084-6.255 4.953-4.176 11.413-6.575 15.514-11.715 3.103-3.884.941-10.55-4.141-11.322-4.928-.78-9.525 1.893-14.152 3.127-.404-8.53.502-17.232-.776-25.746-2.429-13.808-13.514-25.157-26.813-29.124-4.521-1.401-9.266-2.037-13.996-2Z" />
                        </svg>

                    </a>

                    <a href="https://www.instagram.com/futurekayan" target="_blank" aria-label="انستغرام" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path d="M320.3 205C256.8 204.8 205.2 256.2 205 319.7C204.8 383.2 256.2 434.8 319.7 435C383.2 435.2 434.8 383.8 435 320.3C435.2 256.8 383.8 205.2 320.3 205zM319.7 245.4C360.9 245.2 394.4 278.5 394.6 319.7C394.8 360.9 361.5 394.4 320.3 394.6C279.1 394.8 245.6 361.5 245.4 320.3C245.2 279.1 278.5 245.6 319.7 245.4zM413.1 200.3C413.1 185.5 425.1 173.5 439.9 173.5C454.7 173.5 466.7 185.5 466.7 200.3C466.7 215.1 454.7 227.1 439.9 227.1C425.1 227.1 413.1 215.1 413.1 200.3zM542.8 227.5C541.1 191.6 532.9 159.8 506.6 133.6C480.4 107.4 448.6 99.2 412.7 97.4C375.7 95.3 264.8 95.3 227.8 97.4C192 99.1 160.2 107.3 133.9 133.5C107.6 159.7 99.5 191.5 97.7 227.4C95.6 264.4 95.6 375.3 97.7 412.3C99.4 448.2 107.6 480 133.9 506.2C160.2 532.4 191.9 540.6 227.8 542.4C264.8 544.5 375.7 544.5 412.7 542.4C448.6 540.7 480.4 532.5 506.6 506.2C532.8 480 541 448.2 542.8 412.3C544.9 375.3 544.9 264.5 542.8 227.5zM495 452C487.2 471.6 472.1 486.7 452.4 494.6C422.9 506.3 352.9 503.6 320.3 503.6C287.7 503.6 217.6 506.2 188.2 494.6C168.6 486.8 153.5 471.7 145.6 452C133.9 422.5 136.6 352.5 136.6 319.9C136.6 287.3 134 217.2 145.6 187.8C153.4 168.2 168.5 153.1 188.2 145.2C217.7 133.5 287.7 136.2 320.3 136.2C352.9 136.2 423 133.6 452.4 145.2C472 153 487.1 168.1 495 187.8C506.7 217.3 504 287.3 504 319.9C504 352.5 506.7 422.6 495 452z" />
                        </svg>
                    </a>

                    <a href="https://www.facebook.com/futurekayan" target="_blank" aria-label="فيسبوك" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                        </svg>
                    </a>

                    <a href="https://wa.me/966505996562" target="_blank" aria-label="واتساب" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#128c7e] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                        </svg>
                    </a>

                    <a href="tel:+966505996562" aria-label="اتصل بنا" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                        <!-- Background SVG -->
                        <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                            <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                        </svg>

                        <!-- Icon SVG -->
                        <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                        </svg>
                    </a>
                </div>
            </div>
        </nav>
    </header>

    <main id="main-content">