<?php

/**
 * Gallery Page Template
 */

// ===== GALLERY CONFIGURATION =====

// How many images to show initially and per "load more" click
$images_per_load = 8;

// Gallery categories
$gallery_categories = [
    'all' => 'الكل',
    'activities' => 'الأنشطة',
    'arts' => 'الفنون',
    'events' => 'الفعاليات',
    'facilities' => 'المرافق'
];

// All gallery images - add/remove your images here
$gallery_images = [
    ['src' => 'dist/images/gallery/img-1.webp', 'category' => 'activities', 'title' => 'أنشطة تعليمية'],
    ['src' => 'dist/images/gallery/img-2.webp', 'category' => 'arts', 'title' => 'ركن الفنون'],
    ['src' => 'dist/images/gallery/img-3.webp', 'category' => 'events', 'title' => 'فعاليات المركز'],
    ['src' => 'dist/images/gallery/img-4.webp', 'category' => 'facilities', 'title' => 'مرافق المركز'],
    ['src' => 'dist/images/gallery/img-5.webp', 'category' => 'activities', 'title' => 'وقت اللعب'],
    ['src' => 'dist/images/gallery/img-6.webp', 'category' => 'arts', 'title' => 'الرسم والتلوين'],
    ['src' => 'dist/images/gallery/img-7.webp', 'category' => 'events', 'title' => 'حفلات الأطفال'],
    ['src' => 'dist/images/gallery/img-8.webp', 'category' => 'facilities', 'title' => 'الفصول الدراسية'],
    ['src' => 'dist/images/gallery/img-9.webp', 'category' => 'facilities', 'title' => 'الفصول الدراسية']
];

$total_images = count($gallery_images);

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'معرض الصور';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="py-12 md:py-16 bg-white">

    <div class="container">

        <div class="text-center max-w-3xl mx-auto">
            <p class="text-primary-600 text-base md:text-lg mb-4">معرض الصور</p>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                لحظات من <span class="text-secondary-700">كيان المستقبل</span>
            </h1>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg">
                استعرضي أجمل اللحظات والذكريات التي نصنعها مع أطفالنا يومياً
            </p>
        </div>

        <!-- ==================== GALLERY CONTENT ==================== -->
        <div id="gallery-content" class="mt-12">

            <!-- Category Filter -->
            <div class="flex flex-wrap items-center justify-center gap-3 mb-12">
                <?php foreach ($gallery_categories as $key => $label): ?>
                    <button
                        class="gallery-filter-btn px-6 py-2 rounded-full text-sm font-bold transition-all duration-300 <?php echo $key === 'all' ? 'bg-gradient-to-r from-secondary-600 to-secondary-800 text-white' : 'bg-gray-100 text-gray-700 hover:bg-gray-100'; ?>"
                        data-category="<?php echo $key; ?>">
                        <?php echo $label; ?>
                    </button>
                <?php endforeach; ?>
            </div>

            <!-- Gallery Grid -->
            <div id="gallery-grid" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6" data-per-load="<?php echo $images_per_load; ?>">
                <?php foreach ($gallery_images as $index => $image): ?>
                    <div class="gallery-item group relative overflow-hidden rounded-2xl shadow-lg cursor-pointer <?php echo $index >= $images_per_load ? 'hidden' : ''; ?>"
                        data-category="<?php echo $image['category']; ?>"
                        data-index="<?php echo $index; ?>">
                        <img
                            src="<?php echo $image['src']; ?>"
                            alt="<?php echo $image['title']; ?>"
                            class="w-full h-64 object-cover transition-transform duration-500 group-hover:scale-110"
                            loading="lazy">

                        <!-- Overlay -->
                        <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                            <div class="absolute bottom-0 left-0 right-0 p-4">
                                <h3 class="text-white font-bold text-lg"><?php echo $image['title']; ?></h3>
                                <p class="text-white/80 text-sm"><?php echo $gallery_categories[$image['category']]; ?></p>
                            </div>

                            <!-- Zoom Icon -->
                            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
                                <div class="w-12 h-12 rounded-full bg-white/20 backdrop-blur-sm flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0zM10 7v3m0 0v3m0-3h3m-3 0H7" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- Load More Button -->
            <div class="text-center mt-12">
                <button
                    id="load-more-btn"
                    class="inline-flex items-center justify-center gap-2 px-8 py-3 rounded-full bg-gradient-to-r from-secondary-600 to-secondary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#47BEEB] hover:to-[#0F688A] active:scale-[0.97] <?php echo $total_images <= $images_per_load ? 'hidden' : ''; ?>">
                    <span>تحميل المزيد</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                    </svg>
                </button>

                <!-- No More Images Message (hidden by default) -->
                <p id="no-more-msg" class="hidden text-gray-500 mt-4">تم عرض جميع الصور</p>
            </div>

        </div>

    </div>

</section>

<!-- Lightbox Modal -->
<div id="lightbox" class="fixed inset-0 z-[9999] bg-black/90 hidden items-center justify-center p-4">
    <!-- Close Button -->
    <button id="lightbox-close" class="absolute top-4 right-4 w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors z-10">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
        </svg>
    </button>

    <!-- Navigation Arrows -->
    <button id="lightbox-prev" class="absolute left-4 top-1/2 -translate-y-1/2 w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
        </svg>
    </button>
    <button id="lightbox-next" class="absolute right-4 top-1/2 -translate-y-1/2 w-12 h-12 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors">
        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
        </svg>
    </button>

    <!-- Image Container -->
    <div class="max-w-5xl max-h-[90vh] flex items-center justify-center">
        <img id="lightbox-image" src="" alt="" class="max-w-full max-h-[85vh] object-contain rounded-lg">
    </div>

    <!-- Image Info -->
    <div id="lightbox-info" class="absolute bottom-4 left-1/2 -translate-x-1/2 text-center text-white">
        <h3 id="lightbox-title" class="text-lg font-bold"></h3>
        <p id="lightbox-counter" class="text-sm text-white/70"></p>
    </div>
</div>

<?php include 'footer.php'; ?>