<?php
$excludePages = ['contact.php', 'blog.php', 'blog-single.php'];

$currentPage = basename($_SERVER['PHP_SELF']);

if (!in_array($currentPage, $excludePages)) {
    include __DIR__ . '/template-parts/register.php';
}
?>

</main>

<!-- ==================== FOOTER ==================== -->
<footer class="gradient-footer">

    <div class="footer-inner pt-12">
        <div class="container">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 lg:gap-12 mb-8">

                <!-- About -->
                <div class="about-widget">
                    <div class="lg:flex gap-8">
                        <div>
                            <div class="mb-4 lg:mb-0 w-32 h-32">
                                <img src="dist/images/footer-logo.png" alt="Logo" class="w-full h-full object-contain">
                            </div>
                        </div>
                        <div class="text-start">
                            <h3 class="font-bold text-secondary-800 text-lg mb-4">مركز كيان المستقبل</h3>
                            <p class="text-gray-700 text-sm leading-normal">
                                مركز كيان المستقبل نسعى لبناء جيل طموح يكون قاعدة أساسية لمستقبل معرفي باهر ذو فكر مضيء وأهداف واضحة وطموحة. تقوم فكرة كيان المستقبل على استضافة الأطفال وتقديم الرعاية الكاملة لهم.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="quick-links-widget text-start">
                    <h3 class="font-bold text-secondary-800 text-lg mb-4">روابط سريعة</h3>
                    <ul class="space-y-3 text-sm text-gray-700">
                        <li><a href="about.php" class="hover:text-primary-600 transition-colors">عن كيان</a></li>
                        <li><a href="gallery.php" class="hover:text-primary-600 transition-colors">معرض الصور</a></li>
                        <li><a href="contact.php" class="hover:text-primary-600 transition-colors">تواصل معنا</a></li>
                        <li><a href="our-new.php" class="hover:text-primary-600 transition-colors">جديدنا</a></li>
                        <li><a href="blog.php" class="hover:text-primary-600 transition-colors">المدونة</a></li>
                    </ul>
                </div>

                <!-- App Download -->
                <div class="app-widget text-start">
                    <h3 class="font-bold text-secondary-800 text-lg mb-4">تابع يوميات بطلك الصغير</h3>
                    <p class="text-gray-700 text-sm mb-4 leading-relaxed">
                        تطبيقنا يجعلك قريباً من طفلك دائماً. صور، تقارير يومية، ومتابعة فورية للوجبات والأنشطة بلمسة واحدة.
                    </p>
                    <div class="flex gap-2 justify-start">
                        <a href="https://apps.apple.com/tn/app/future-kayan/id6446227208" class="block">
                            <img src="dist/images/apple-app.png" alt="App Store" class="h-14">
                        </a>
                        <a href="https://play.google.com/store/apps/details?id=com.asooltech.futurekyan" class="block">
                            <img src="dist/images/google-app.png" alt="Google Play" class="h-14">
                        </a>
                    </div>
                </div>
            </div>

            <!-- Divider -->
            <div class="border-t border-gray-100 mt-20 py-4">
                <div class="flex flex-wrap items-center justify-center lg:justify-between text-center lg:text-start">

                    <!-- Copyright -->
                    <p class="text-gray-600 text-sm">
                        © 2025 مركز كيان المستقبل- جميع الحقوق محفوظة
                        <a class="text-secondary-800" href="https://asooltech.com/" target="_blank">تصميم أصول تك</a>
                    </p>

                    <!-- Social Icons -->
                    <div class="flex items-center gap-2 text-secondary-800">
                        <a href="https://www.snapchat.com/add/futurekayan1" target="_blank" aria-label="سناب شات" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                            <!-- Background SVG -->
                            <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                            </svg>

                            <!-- Icon SVG -->
                            <svg width="32" height="32" viewBox="0 0 192 192" xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none">
                                <path stroke="currentColor" stroke-linejoin="round" stroke-width="16" d="M95.918 22.002c-11.963-.087-24.145 4.54-32.031 13.717-6.995 7.405-9.636 17.901-9.284 27.868-.03 5.119.032 10.237.05 15.355-4.901-1.217-9.873-4.624-15.063-2.937-4.422 1.313-6.267 7.088-3.596 10.791 2.876 3.761 7.346 5.907 11.08 8.71 1.837 1.5 4.313 2.571 5.68 4.499-.001 4.62-2.425 8.897-4.722 12.786-5.597 8.802-14.342 15.531-23.705 20.18-2.39 1.035-4.59 4.144-2.473 6.499 3.862 3.622 9.327 4.778 14.195 6.486 2.047.64 5.078 1.34 4.886 4.084.335 2.923 2.205 6.066 5.492 6.078 7.873.91 16.289.522 23.345 4.741 6.917 4.006 14.037 8.473 22.255 8.96 8.188.767 16.623-.888 23.642-5.255 5.23-2.884 10.328-6.477 16.456-7.061 5.155-1.206 10.702-.151 15.685-2.072 3.193-1.367 2.762-5.244 4.104-7.808 2.532-1.747 5.77-1.948 8.59-3.102 3.687-1.47 8.335-2.599 10.268-6.413 1.148-3.038-2.312-4.698-4.453-5.88-11.38-5.874-21.631-14.921-26.121-27.191-.496-1.936-2.279-4.834.084-6.255 4.953-4.176 11.413-6.575 15.514-11.715 3.103-3.884.941-10.55-4.141-11.322-4.928-.78-9.525 1.893-14.152 3.127-.404-8.53.502-17.232-.776-25.746-2.429-13.808-13.514-25.157-26.813-29.124-4.521-1.401-9.266-2.037-13.996-2Z" />
                            </svg>

                        </a>

                        <a href="https://www.instagram.com/futurekayan" target="_blank" aria-label="انستغرام" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                            <!-- Background SVG -->
                            <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                            </svg>

                            <!-- Icon SVG -->
                            <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                                <path d="M320.3 205C256.8 204.8 205.2 256.2 205 319.7C204.8 383.2 256.2 434.8 319.7 435C383.2 435.2 434.8 383.8 435 320.3C435.2 256.8 383.8 205.2 320.3 205zM319.7 245.4C360.9 245.2 394.4 278.5 394.6 319.7C394.8 360.9 361.5 394.4 320.3 394.6C279.1 394.8 245.6 361.5 245.4 320.3C245.2 279.1 278.5 245.6 319.7 245.4zM413.1 200.3C413.1 185.5 425.1 173.5 439.9 173.5C454.7 173.5 466.7 185.5 466.7 200.3C466.7 215.1 454.7 227.1 439.9 227.1C425.1 227.1 413.1 215.1 413.1 200.3zM542.8 227.5C541.1 191.6 532.9 159.8 506.6 133.6C480.4 107.4 448.6 99.2 412.7 97.4C375.7 95.3 264.8 95.3 227.8 97.4C192 99.1 160.2 107.3 133.9 133.5C107.6 159.7 99.5 191.5 97.7 227.4C95.6 264.4 95.6 375.3 97.7 412.3C99.4 448.2 107.6 480 133.9 506.2C160.2 532.4 191.9 540.6 227.8 542.4C264.8 544.5 375.7 544.5 412.7 542.4C448.6 540.7 480.4 532.5 506.6 506.2C532.8 480 541 448.2 542.8 412.3C544.9 375.3 544.9 264.5 542.8 227.5zM495 452C487.2 471.6 472.1 486.7 452.4 494.6C422.9 506.3 352.9 503.6 320.3 503.6C287.7 503.6 217.6 506.2 188.2 494.6C168.6 486.8 153.5 471.7 145.6 452C133.9 422.5 136.6 352.5 136.6 319.9C136.6 287.3 134 217.2 145.6 187.8C153.4 168.2 168.5 153.1 188.2 145.2C217.7 133.5 287.7 136.2 320.3 136.2C352.9 136.2 423 133.6 452.4 145.2C472 153 487.1 168.1 495 187.8C506.7 217.3 504 287.3 504 319.9C504 352.5 506.7 422.6 495 452z" />
                            </svg>
                        </a>

                        <a href="https://www.facebook.com/futurekayan" target="_blank" aria-label="فيسبوك" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                            <!-- Background SVG -->
                            <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                            </svg>

                            <!-- Icon SVG -->
                            <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="1.6" viewBox="0 0 24 24">
                                <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                            </svg>
                        </a>

                        <a href="https://wa.me/966505996562" target="_blank" aria-label="واتساب" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                            <!-- Background SVG -->
                            <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#128c7e] transition-all duration-300" />
                            </svg>

                            <!-- Icon SVG -->
                            <svg class="w-5 h-5 z-10 transition-all duration-300 group-hover:text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                                <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                            </svg>
                        </a>

                        <a href="tel:+966505996562" aria-label="اتصل بنا" class="group w-8 h-8 relative rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110 hover:rotate-6">
                            <!-- Background SVG -->
                            <svg class="absolute inset-0 w-full h-full transition-all duration-300" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                <path d="M29.159 10.5491C29.3484 9.49472 29.2798 8.41018 28.9589 7.38816C28.638 6.36611 28.0745 5.43699 27.3163 4.68019C26.5582 3.92336 25.6281 3.36138 24.6055 3.04227C23.5829 2.72315 22.4983 2.65638 21.4443 2.84768C20.8333 1.96877 20.0188 1.25074 19.0702 0.754864C18.1216 0.25899 17.0671 0 15.9967 0C14.9263 0 13.8718 0.25899 12.9232 0.754864C11.9745 1.25074 11.16 1.96877 10.5491 2.84768C9.496 2.65886 8.41293 2.72748 7.39216 3.0477C6.37139 3.36794 5.4432 3.93024 4.68672 4.68672C3.93024 5.4432 3.36794 6.37139 3.0477 7.39216C2.72748 8.41293 2.65886 9.496 2.84768 10.5491C1.96877 11.16 1.25074 11.9745 0.754864 12.9232C0.25899 13.8718 0 14.9263 0 15.9967C0 17.0671 0.25899 18.1216 0.754864 19.0702C1.25074 20.0188 1.96877 20.8333 2.84768 21.4443C2.6573 22.4985 2.725 23.583 3.045 24.6053C3.36499 25.6276 3.92781 26.5573 4.68525 27.3148C5.44272 28.0722 6.37235 28.635 7.39466 28.955C8.41696 29.275 9.50154 29.3427 10.5557 29.1523C11.1667 30.0312 11.9812 30.7492 12.9298 31.2451C13.8784 31.741 14.9329 32 16.0033 32C17.0737 32 18.1282 31.741 19.0768 31.2451C20.0255 30.7492 20.84 30.0312 21.451 29.1523C22.5046 29.3415 23.5884 29.2728 24.6098 28.9523C25.6312 28.6317 26.5599 28.0688 27.3165 27.3115C28.0732 26.5542 28.6353 25.625 28.955 24.6033C29.2747 23.5817 29.3424 22.4978 29.1523 21.4443C30.0312 20.8333 30.7492 20.0188 31.2451 19.0702C31.741 18.1216 32 17.0671 32 15.9967C32 14.9263 31.741 13.8718 31.2451 12.9232C30.7492 11.9745 30.0379 11.16 29.159 10.5491Z" class="fill-[#E0F5FF] group-hover:fill-[#1387B3] transition-all duration-300" />
                            </svg>

                            <!-- Icon SVG -->
                            <svg class="w-4 h-4 z-10 transition-all duration-300 group-hover:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                            </svg>
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</footer>

<!-- Sticky Contact Buttons -->
<div id="sticky-contact" class="fixed bottom-6 right-6 z-50">
    <!-- Mobile: Always visible buttons -->
    <div class="flex md:hidden flex-col gap-3">
        <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-14 h-14 rounded-full bg-[#128c7e] flex items-center justify-center shadow-lg hover:scale-110 transition-transform">
            <svg class="w-8 h-8 text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z"></path>
            </svg>
        </a>
        <a href="tel:+966505996562" aria-label="اتصل بنا" class="w-14 h-14 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center shadow-lg hover:scale-110 transition-transform">
            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
            </svg>
        </a>
    </div>

    <!-- Desktop: Toggle button with expandable menu -->
    <div class="hidden md:block">
        <!-- Expanded buttons (hidden by default) -->
        <div id="sticky-buttons" class="flex flex-col gap-3 mb-3 opacity-0 translate-y-4 pointer-events-none transition-all duration-300">
            <a href="https://wa.me/966505996562" target="_blank" aria-label="تواصل عبر واتساب" class="w-14 h-14 rounded-full bg-[#128c7e] flex items-center justify-center shadow-lg hover:scale-110 transition-transform">
                <svg class="w-8 h-8 text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640"><!--!Font Awesome Free v7.1.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                    <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z"></path>
                </svg>
            </a>
            <a href="tel:+966505996562" aria-label="اتصل بنا" class="w-14 h-14 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center shadow-lg hover:scale-110 transition-transform">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                </svg>
            </a>
        </div>
        <!-- Toggle button -->
        <button id="sticky-toggle" aria-label="فتح قائمة التواصل" aria-expanded="false" class="w-14 h-14 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center shadow-lg hover:scale-110 transition-all duration-300">
            <svg id="toggle-icon-open" class="w-7 h-7 text-white transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z" />
            </svg>
            <svg id="toggle-icon-close" class="w-7 h-7 text-white absolute transition-transform duration-300 opacity-0 rotate-90" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
            </svg>
        </button>
    </div>
</div>

<script>
    // Sticky contact toggle for desktop
    document.addEventListener('DOMContentLoaded', function() {
        const toggle = document.getElementById('sticky-toggle');
        const buttons = document.getElementById('sticky-buttons');
        const iconOpen = document.getElementById('toggle-icon-open');
        const iconClose = document.getElementById('toggle-icon-close');
        let isOpen = false;

        if (toggle) {
            toggle.addEventListener('click', function() {
                isOpen = !isOpen;
                if (isOpen) {
                    buttons.classList.remove('opacity-0', 'translate-y-4', 'pointer-events-none');
                    buttons.classList.add('opacity-100', 'translate-y-0');
                    iconOpen.classList.add('opacity-0', 'rotate-90');
                    iconClose.classList.remove('opacity-0', 'rotate-90');
                } else {
                    buttons.classList.add('opacity-0', 'translate-y-4', 'pointer-events-none');
                    buttons.classList.remove('opacity-100', 'translate-y-0');
                    iconOpen.classList.remove('opacity-0', 'rotate-90');
                    iconClose.classList.add('opacity-0', 'rotate-90');
                }
            });
        }
    });
</script>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<!-- Swiper RTL Support -->
<script src="dist/js/swiper-rtl.js"></script>
<!-- Main JavaScript -->
<script src="dist/js/main.js"></script>

<?php
// Page-specific scripts
$current_page = basename($_SERVER['PHP_SELF']);
if ($current_page === 'gallery.php'): ?>
    <script src="dist/js/gallery.js"></script>
<?php endif; ?>
<!-- Language Switcher Script -->
<script>
function toggleLanguage() {
    const html = document.documentElement;
    const langText = document.getElementById('lang-text');
    const currentLang = html.getAttribute('lang');

    if (currentLang === 'ar') {
        html.setAttribute('lang', 'en');
        html.setAttribute('dir', 'ltr');
        langText.textContent = 'AR';
        localStorage.setItem('lang', 'en');
    } else {
        html.setAttribute('lang', 'ar');
        html.setAttribute('dir', 'rtl');
        langText.textContent = 'EN';
        localStorage.setItem('lang', 'ar');
    }

    // Reinitialize Swipers with new direction
    if (typeof initializeSwipers === 'function') {
        setTimeout(initializeSwipers, 100);
    }
}

// Check saved language on page load
document.addEventListener('DOMContentLoaded', function() {
    const savedLang = localStorage.getItem('lang');
    const langText = document.getElementById('lang-text');
    if (savedLang === 'en') {
        document.documentElement.setAttribute('lang', 'en');
        document.documentElement.setAttribute('dir', 'ltr');
        if (langText) langText.textContent = 'AR';
    }
});
</script>
</body>

</html>
