/**
 * Swiper RTL Support
 * Handles Swiper initialization and reinitialization for RTL/LTR switching
 */

// Store Swiper instances for reinitialization
window.swiperInstances = {};

// Swiper configurations
window.swiperConfigs = {
    'why-us': {
        selector: '.why-us-swiper',
        config: {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: { delay: 4000, disableOnInteraction: false },
            navigation: { nextEl: '.why-us-swiper-next', prevEl: '.why-us-swiper-prev' },
            breakpoints: {
                640: { slidesPerView: 2, spaceBetween: 20 },
                768: { slidesPerView: 3, spaceBetween: 24 },
                1024: { slidesPerView: 4, spaceBetween: 32 }
            }
        }
    },
    'testimonials': {
        selector: '.testimonials-swiper',
        config: {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: { delay: 5000, disableOnInteraction: false },
            navigation: { nextEl: '.testimonials-swiper-next', prevEl: '.testimonials-swiper-prev' },
            breakpoints: {
                640: { slidesPerView: 1, spaceBetween: 20 },
                768: { slidesPerView: 2, spaceBetween: 24 },
                1024: { slidesPerView: 3, spaceBetween: 24 }
            }
        }
    },
    'services': {
        selector: '.services-swiper',
        config: {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            autoplay: { delay: 4000, disableOnInteraction: false },
            navigation: { nextEl: '.services-swiper-next', prevEl: '.services-swiper-prev' },
            breakpoints: {
                640: { slidesPerView: 2, spaceBetween: 20 },
                768: { slidesPerView: 3, spaceBetween: 24 },
                1024: { slidesPerView: 4, spaceBetween: 32 }
            }
        }
    }
};

// Initialize all Swipers with RTL support
function initializeSwipers() {
    const isRTL = document.documentElement.dir === 'rtl';

    Object.keys(window.swiperConfigs).forEach(function(key) {
        const swiperData = window.swiperConfigs[key];
        const element = document.querySelector(swiperData.selector);

        if (element) {
            // Destroy existing instance if any
            if (window.swiperInstances[key]) {
                window.swiperInstances[key].destroy(true, true);
            }

            // Deep clone config to avoid modifying original
            const config = JSON.parse(JSON.stringify(swiperData.config));

            // Set RTL mode
            if (isRTL) {
                config.rtl = true;
            }

            window.swiperInstances[key] = new Swiper(swiperData.selector, config);
        }
    });
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    // Wait for Swiper to be available
    setTimeout(initializeSwipers, 300);
});

// Export for use in toggleLanguage
window.initializeSwipers = initializeSwipers;
