// Main JavaScript File

// FAQ Toggle Function (for service pages)
function toggleFaq(button) {
    const content = button.nextElementSibling;
    const icon = button.querySelector('.faq-icon');

    // Toggle content visibility
    content.classList.toggle('hidden');

    // Rotate icon
    icon.classList.toggle('rotate-180');
}

document.addEventListener('DOMContentLoaded', function() {
    const menuBtn = document.getElementById('mobile-menu-btn');
    const menu = document.getElementById('mobile-menu');
    const topBar = document.getElementById('top-bar');
    const header = document.getElementById('main-header');
    const heroSection = document.getElementById('hero-section');
    let isMenuOpen = false;
    let isHeaderSticky = false;
    let headerHeight = 0;

    // Calculate header height and apply negative margin to hero
    function setHeroMargin() {
        // Temporarily reset to get true height
        header.style.position = 'relative';
        headerHeight = header.offsetHeight;

        if (!isHeaderSticky && heroSection) {
            heroSection.style.marginTop = -headerHeight + 'px';
            heroSection.style.paddingTop = headerHeight + 'px';
        }
    }

    // Set on load (only if hero section exists)
    if (heroSection) {
        setHeroMargin();
        // Update on resize
        window.addEventListener('resize', setHeroMargin);
    } else {
        // Still calculate header height for scroll behavior
        headerHeight = header.offsetHeight;
    }

    // Mobile Menu Toggle
    menuBtn.addEventListener('click', function() {
        isMenuOpen = !isMenuOpen;

        if (isMenuOpen) {
            menu.classList.remove('opacity-0', '-translate-y-4', 'pointer-events-none');
            menu.classList.add('opacity-100', 'translate-y-0', 'pointer-events-auto');
            menuBtn.innerHTML = `<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>`;
        } else {
            menu.classList.add('opacity-0', '-translate-y-4', 'pointer-events-none');
            menu.classList.remove('opacity-100', 'translate-y-0', 'pointer-events-auto');
            menuBtn.innerHTML = `<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
            </svg>`;
        }
    });

    // Sticky Header on Scroll
    window.addEventListener('scroll', function() {
        const scrollY = window.scrollY;

        if (scrollY > headerHeight) {
            if (!isHeaderSticky) {
                // Make header sticky
                header.classList.add('header-sticky');
                header.style.position = 'fixed';
                header.style.top = '0';
                header.style.left = '0';
                header.style.right = '0';
                header.style.zIndex = '9999';
                header.style.backgroundColor = '#ffffff';
                header.style.boxShadow = '0 10px 15px -3px rgba(0, 0, 0, 0.055)';
                header.style.animation = 'slideDown 0.3s ease-out forwards';
                // Hide topbar directly
                if (topBar) topBar.style.display = 'none';
                isHeaderSticky = true;
            }
        } else {
            if (isHeaderSticky) {
                // Return header to normal
                header.classList.remove('header-sticky');
                header.style.position = 'relative';
                header.style.top = '';
                header.style.left = '';
                header.style.right = '';
                header.style.backgroundColor = 'transparent';
                header.style.boxShadow = '';
                header.style.animation = '';
                // Show topbar directly (restore to default, CSS will handle lg:block)
                if (topBar) topBar.style.display = '';
                isHeaderSticky = false;
            }
        }
    });
});