<?php

/**
 * Contact Page Template
 */

include 'header.php';

// Breadcrumb
$breadcrumb_title = 'تواصل معنا';
include 'template-parts/breadcrumb.php';
?>

<!-- ==================== PAGE HEADER ==================== -->
<section class="pt-20 pb-12 bg-white">
    <div class="container">
        <div class="text-center max-w-3xl mx-auto">
            <p class="text-primary-600 text-base md:text-lg mb-4">تواصل معنا</p>
            <h1 class="text-3xl sm:text-4xl md:text-5xl font-bold text-[#07394D] !leading-snug mb-4">
                نحن هنا <span class="text-secondary-700">لمساعدتك</span>
            </h1>
            <p class="text-gray-700 text-sm sm:text-base md:text-lg">
                لديك استفسار أو ترغبين في تسجيل طفلك؟ تواصلي معنا وسنرد عليك في أقرب وقت
            </p>
        </div>
    </div>
</section>

<!-- ==================== CONTACT CONTENT ==================== -->
<section id="contact-content" class="gradient-section relative overflow-hidden">
    <!-- Wave Top -->
    <div class="mt-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
    <div class="py-12">
        <div class="container">

            <div class="flex flex-col lg:flex-row gap-8">

                <!-- Contact Form -->
                <div class="lg:w-2/3">
                    <div class="bg-white/80 rounded-3xl p-6 md:p-10">
                        <h2 class="text-2xl md:text-3xl font-bold text-secondary-900 mb-2">أرسلي لنا رسالة</h2>
                        <p class="text-gray-600 mb-8">املئي النموذج أدناه وسنتواصل معك في أقرب وقت</p>

                        <form id="contact-form" class="space-y-6">
                            <!-- Row 1: Name & Phone -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-gray-700 font-semibold mb-2">الاسم الكامل <span class="text-red-500">*</span></label>
                                    <input type="text" id="name" name="name" required autocomplete="name"
                                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none"
                                        placeholder="أدخلي اسمك الكامل">
                                </div>
                                <div>
                                    <label for="phone" class="block text-gray-700 font-semibold mb-2">رقم الجوال <span class="text-red-500">*</span></label>
                                    <input type="tel" id="phone" name="phone" required autocomplete="tel"
                                        class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none text-right"
                                        placeholder="05xxxxxxxx">
                                </div>
                            </div>

                            <!-- Row 2: Email -->
                            <div>
                                <label for="email" class="block text-gray-700 font-semibold mb-2">البريد الإلكتروني</label>
                                <input type="email" id="email" name="email" autocomplete="email"
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none"
                                    placeholder="example@email.com">
                            </div>

                            <!-- Row 3: Child Age & Service -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="child_age" class="block text-gray-700 font-semibold mb-2">عمر الطفل</label>
                                    <select id="child_age" name="child_age"
                                        class="w-full pl-10 pr-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none bg-white appearance-none bg-[url('data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20fill%3D%22none%22%20viewBox%3D%220%200%2024%2024%22%20stroke%3D%22%236b7280%22%20stroke-width%3D%222%22%3E%3Cpath%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%20d%3D%22M19%209l-7%207-7-7%22%2F%3E%3C%2Fsvg%3E')] bg-[length:1.25rem] bg-[left_0.75rem_center] bg-no-repeat">
                                        <option value="">اختاري عمر الطفل</option>
                                        <option value="1-2">1-2 سنة</option>
                                        <option value="2-3">2-3 سنوات</option>
                                        <option value="3-4">3-4 سنوات</option>
                                        <option value="4-5">4-5 سنوات</option>
                                        <option value="5-6">5-6 سنوات</option>
                                        <option value="6+">أكثر من 6 سنوات</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="service" class="block text-gray-700 font-semibold mb-2">الخدمة المطلوبة</label>
                                    <select id="service" name="service"
                                        class="w-full pl-10 pr-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none bg-white appearance-none bg-[url('data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20fill%3D%22none%22%20viewBox%3D%220%200%2024%2024%22%20stroke%3D%22%236b7280%22%20stroke-width%3D%222%22%3E%3Cpath%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%20d%3D%22M19%209l-7%207-7-7%22%2F%3E%3C%2Fsvg%3E')] bg-[length:1.25rem] bg-[left_0.75rem_center] bg-no-repeat">
                                        <option value="">اختاري الخدمة</option>
                                        <option value="full_day">ضيافة يوم كامل</option>
                                        <option value="half_day">ضيافة نصف يوم</option>
                                        <option value="hourly">ضيافة بالساعة</option>
                                        <option value="summer_camp">معسكر صيفي</option>
                                        <option value="activities">أنشطة وبرامج</option>
                                        <option value="other">أخرى</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Row 4: Message -->
                            <div>
                                <label for="message" class="block text-gray-700 font-semibold mb-2">رسالتك <span class="text-red-500">*</span></label>
                                <textarea id="message" name="message" rows="5" required
                                    class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-secondary-500 focus:ring-2 focus:ring-secondary-200 transition-all outline-none resize-none"
                                    placeholder="اكتبي رسالتك هنا..."></textarea>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit"
                                class="w-full flex items-center justify-center gap-2 px-4 sm:px-6 py-4 rounded-full bg-gradient-to-r from-primary-600 to-primary-800 text-white text-sm sm:text-base font-bold transition-all duration-300 ease-out hover:scale-[1.03] hover:shadow-xl hover:from-[#7F1469] hover:to-[#CD23A7] active:scale-[0.97]">
                                <span>إرسال الرسالة</span>
                            </button>

                            <!-- Form Message -->
                            <div id="form-message" class="hidden"></div>
                        </form>
                    </div>
                </div>

                <!-- Contact Info Sidebar -->
                <div class="lg:w-1/3 space-y-6">
                    <!-- Contact Cards -->
                    <div class="bg-white/80 rounded-3xl p-6">
                        <h3 class="text-xl font-bold text-secondary-900 mb-6">معلومات التواصل</h3>

                        <div class="space-y-4">
                            <!-- Phone -->
                            <a href="tel:+966505996562" class="flex items-center gap-4 bg-gradient-to-br from-primary-50 to-secondary-50 rounded-2xl p-4 hover:shadow-md transition-all">
                                <div class="w-12 h-12 rounded-xl bg-gradient-to-r from-secondary-600 to-secondary-800 flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-gray-500 text-sm">اتصلي بنا</p>
                                    <p class="text-gray-900 font-bold" dir="ltr">0505996562</p>
                                </div>
                            </a>

                            <!-- WhatsApp -->
                            <a href="https://wa.me/966505996562" target="_blank" class="flex items-center gap-4 bg-gradient-to-br from-primary-50 to-secondary-50 rounded-2xl p-4 hover:shadow-md transition-all">
                                <div class="w-12 h-12 rounded-xl bg-[#128c7e] flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-white" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                                        <path d="M476.9 161.1C435 119.1 379.2 96 319.9 96C197.5 96 97.9 195.6 97.9 318C97.9 357.1 108.1 395.3 127.5 429L96 544L213.7 513.1C246.1 530.8 282.6 540.1 319.8 540.1L319.9 540.1C442.2 540.1 544 440.5 544 318.1C544 258.8 518.8 203.1 476.9 161.1zM319.9 502.7C286.7 502.7 254.2 493.8 225.9 477L219.2 473L149.4 491.3L168 423.2L163.6 416.2C145.1 386.8 135.4 352.9 135.4 318C135.4 216.3 218.2 133.5 320 133.5C369.3 133.5 415.6 152.7 450.4 187.6C485.2 222.5 506.6 268.8 506.5 318.1C506.5 419.9 421.6 502.7 319.9 502.7zM421.1 364.5C415.6 361.7 388.3 348.3 383.2 346.5C378.1 344.6 374.4 343.7 370.7 349.3C367 354.9 356.4 367.3 353.1 371.1C349.9 374.8 346.6 375.3 341.1 372.5C308.5 356.2 287.1 343.4 265.6 306.5C259.9 296.7 271.3 297.4 281.9 276.2C283.7 272.5 282.8 269.3 281.4 266.5C280 263.7 268.9 236.4 264.3 225.3C259.8 214.5 255.2 216 251.8 215.8C248.6 215.6 244.9 215.6 241.2 215.6C237.5 215.6 231.5 217 226.4 222.5C221.3 228.1 207 241.5 207 268.8C207 296.1 226.9 322.5 229.6 326.2C232.4 329.9 268.7 385.9 324.4 410C359.6 425.2 373.4 426.5 391 423.9C401.7 422.3 423.8 410.5 428.4 397.5C433 384.5 433 373.4 431.6 371.1C430.3 368.6 426.6 367.2 421.1 364.5z" />
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-gray-500 text-sm">واتساب</p>
                                    <p class="text-gray-900 font-bold">راسلينا الآن</p>
                                </div>
                            </a>

                            <!-- Email -->
                            <a href="mailto:info@futurekayan.com" class="flex items-center gap-4 bg-gradient-to-br from-primary-50 to-secondary-50 rounded-2xl p-4 hover:shadow-md transition-all">
                                <div class="w-12 h-12 rounded-xl bg-gradient-to-r from-primary-600 to-primary-800 flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-gray-500 text-sm">البريد الإلكتروني</p>
                                    <p class="text-gray-900 font-bold text-sm">info@futurekayan.com</p>
                                </div>
                            </a>

                            <!-- Location -->
                            <a href="https://www.google.com/maps/place/24%C2%B042'46.4%22N+46%C2%B038'11.6%22E/@24.7128889,46.6365556,17z/data=!3m1!4b1!4m4!3m3!8m2!3d24.7128889!4d46.6365556?entry=ttu&g_ep=EgoyMDI1MTIwOS4wIKXMDSoASAFQAw%3D%3D" target="_blank" class="flex items-center gap-4 bg-gradient-to-br from-primary-50 to-secondary-50 rounded-2xl p-4 hover:shadow-md transition-all">
                                <div class="w-12 h-12 rounded-xl bg-gradient-to-r from-red-500 to-red-600 flex items-center justify-center flex-shrink-0">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-gray-500 text-sm">العنوان</p>
                                    <p class="text-gray-900 font-bold text-sm">الرياض ، حي الرائد ، شارع عبدالعزيز الاحسائي</p>
                                </div>
                            </a>
                        </div>
                    </div>

                    <!-- Working Hours -->
                    <div class="bg-white/80 rounded-3xl p-6">
                        <h3 class="text-xl font-bold text-secondary-900 mb-4">ساعات العمل</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                <span class="text-gray-600">الأحد - الخميس</span>
                                <span class="text-secondary-700 font-bold">7:00 ص - 6:00 م</span>
                            </div>
                            <div class="flex justify-between items-center py-2">
                                <span class="text-gray-600">الجمعة - السبت</span>
                                <span class="text-red-500 font-bold">مغلق</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-12">
                <div class="rounded-3xl overflow-hidden">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m17!1m12!1m3!1d3624.4074332043297!2d46.6365556!3d24.712888899999996!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m2!1m1!2zMjTCsDQyJzQ2LjQiTiA0NsKwMzgnMTEuNiJF!5e0!3m2!1sen!2seg!4v1766262095399!5m2!1sen!2seg" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>

        </div>
    </div>
    <!-- Wave Bottom -->
    <div class="mb-[-1px]">
        <svg xmlns="http://www.w3.org/2000/svg" class="rotate-180" fill="white" viewBox="0 0 1000 100" preserveAspectRatio="none">
            <path class="elementor-shape-fill" opacity="0.33" d="M473,67.3c-203.9,88.3-263.1-34-320.3,0C66,119.1,0,59.7,0,59.7V0h1000v59.7 c0,0-62.1,26.1-94.9,29.3c-32.8,3.3-62.8-12.3-75.8-22.1C806,49.6,745.3,8.7,694.9,4.7S492.4,59,473,67.3z"></path>
            <path class="elementor-shape-fill" opacity="0.66" d="M734,67.3c-45.5,0-77.2-23.2-129.1-39.1c-28.6-8.7-150.3-10.1-254,39.1 s-91.7-34.4-149.2,0C115.7,118.3,0,39.8,0,39.8V0h1000v36.5c0,0-28.2-18.5-92.1-18.5C810.2,18.1,775.7,67.3,734,67.3z"></path>
            <path class="elementor-shape-fill" d="M766.1,28.9c-200-57.5-266,65.5-395.1,19.5C242,1.8,242,5.4,184.8,20.6C128,35.8,132.3,44.9,89.9,52.5C28.6,63.7,0,0,0,0 h1000c0,0-9.9,40.9-83.6,48.1S829.6,47,766.1,28.9z"></path>
        </svg>
    </div>
</section>

<?php include 'footer.php'; ?>